/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.telemetry;

import ddtrot.dd.trace.api.telemetry.ConfigInversionMetricCollector;
import ddtrot.dd.trace.api.telemetry.MetricCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigInversionMetricCollectorImpl
implements MetricCollector<ConfigInversionMetric>,
ConfigInversionMetricCollector {
    private static final Logger log = LoggerFactory.getLogger(ConfigInversionMetricCollectorImpl.class);
    private static final String CONFIG_INVERSION_KEY_TAG = "config_name:";
    private static final String CONFIG_INVERSION_METRIC_NAME = "untracked.config.detected";
    private static final String NAMESPACE = "tracers";
    private static final ConfigInversionMetricCollectorImpl INSTANCE = new ConfigInversionMetricCollectorImpl();
    private final BlockingQueue<ConfigInversionMetric> metricsQueue = new ArrayBlockingQueue<ConfigInversionMetric>(1024);

    private ConfigInversionMetricCollectorImpl() {
    }

    public static ConfigInversionMetricCollectorImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public void setUndocumentedEnvVarMetric(String configName) {
        this.setMetricConfigInversionMetric(CONFIG_INVERSION_KEY_TAG + configName);
    }

    private void setMetricConfigInversionMetric(String ... tags) {
        if (!this.metricsQueue.offer(new ConfigInversionMetric(NAMESPACE, true, CONFIG_INVERSION_METRIC_NAME, "count", (Number)1, tags))) {
            log.debug("Unable to add telemetry metric {} for {}", (Object)CONFIG_INVERSION_METRIC_NAME, (Object)tags[0]);
        }
    }

    @Override
    public void prepareMetrics() {
    }

    @Override
    public Collection<ConfigInversionMetric> drain() {
        if (this.metricsQueue.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ConfigInversionMetric> drained = new ArrayList<ConfigInversionMetric>(this.metricsQueue.size());
        this.metricsQueue.drainTo(drained);
        return drained;
    }

    public static class ConfigInversionMetric
    extends MetricCollector.Metric {
        public ConfigInversionMetric(String namespace, boolean common, String metricName, String type, Number value, String ... tags) {
            super(namespace, common, metricName, type, value, tags);
        }
    }
}

