/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.naming.v0;

import ddtrot.dd.trace.api.naming.NamingSchema;
import ddtrot.dd.trace.api.remoteconfig.ServiceNameCollector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CloudNamingV0
implements NamingSchema.ForCloud {
    public static final String JAVA_AWS_SDK = "java-aws-sdk";
    private final boolean allowInferredServices;

    public CloudNamingV0(boolean allowInferredServices) {
        this.allowInferredServices = allowInferredServices;
    }

    @Override
    @Nonnull
    public String operationForRequest(@Nonnull String provider, @Nonnull String cloudService, @Nonnull String qualifiedOperation) {
        return "aws.http";
    }

    @Override
    public String serviceForRequest(@Nonnull String provider, @Nullable String cloudService) {
        if (!this.allowInferredServices) {
            return null;
        }
        if (cloudService == null) {
            ServiceNameCollector.get().addService(JAVA_AWS_SDK);
            return JAVA_AWS_SDK;
        }
        switch (cloudService) {
            case "sns": 
            case "sqs": {
                ServiceNameCollector.get().addService(cloudService);
                return cloudService;
            }
        }
        ServiceNameCollector.get().addService(JAVA_AWS_SDK);
        return JAVA_AWS_SDK;
    }

    @Override
    @Nonnull
    public String operationForFaas(@Nonnull String provider) {
        return "dd-tracer-serverless-span";
    }
}

