/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.flare;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class TracerFlare {
    private static final Map<Class<?>, Reporter> reporters = new ConcurrentHashMap();

    public static void prepareForFlare() {
        for (Reporter reporter : reporters.values()) {
            try {
                reporter.prepareForFlare();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void addReportsToFlare(ZipOutputStream zip) throws IOException {
        ArrayList<Throwable> errors = null;
        for (Reporter reporter : reporters.values()) {
            try {
                reporter.addReportToFlare(zip);
            }
            catch (Throwable e) {
                if (null == errors) {
                    errors = new ArrayList<Throwable>();
                }
                errors.add(e);
            }
        }
        if (null != errors) {
            zip.putNextEntry(new ZipEntry("flare_errors.txt"));
            for (Throwable e : errors) {
                zip.write(e.toString().getBytes(StandardCharsets.UTF_8));
                zip.write(10);
            }
        }
    }

    public static void cleanupAfterFlare() {
        for (Reporter reporter : reporters.values()) {
            try {
                reporter.cleanupAfterFlare();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void addReporter(Reporter reporter) {
        reporters.put(reporter.getClass(), reporter);
    }

    public static void addText(ZipOutputStream zip, String section, String text) throws IOException {
        zip.putNextEntry(new ZipEntry(section));
        if (null != text) {
            zip.write(text.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static void addBinary(ZipOutputStream zip, String section, byte[] bytes) throws IOException {
        zip.putNextEntry(new ZipEntry(section));
        if (null != bytes) {
            zip.write(bytes);
        }
    }

    public static interface Reporter {
        default public void prepareForFlare() {
        }

        public void addReportToFlare(ZipOutputStream var1) throws IOException;

        default public void cleanupAfterFlare() {
        }
    }
}

