/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.json;

import ddtrot.dd.json.JsonStructure;
import ddtrot.dd.json.LenientJsonStructure;
import ddtrot.dd.json.SafeJsonStructure;
import java.io.ByteArrayOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public final class JsonWriter
implements Flushable,
AutoCloseable {
    private static final int INITIAL_CAPACITY = 256;
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream(256);
    private final OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.outputStream, StandardCharsets.UTF_8);
    private final JsonStructure structure;
    private boolean requireComma;

    public JsonWriter() {
        this(true);
    }

    public JsonWriter(boolean safe) {
        this.structure = safe ? new SafeJsonStructure() : new LenientJsonStructure();
        this.requireComma = false;
    }

    public JsonWriter beginObject() {
        this.structure.beginObject();
        this.injectCommaIfNeeded();
        this.write('{');
        return this;
    }

    public JsonWriter endObject() {
        this.structure.endObject();
        this.write('}');
        this.endsValue();
        return this;
    }

    public JsonWriter name(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.structure.addName();
        this.injectCommaIfNeeded();
        this.writeStringLiteral(name);
        this.write(':');
        return this;
    }

    public JsonWriter nullValue() {
        this.structure.addValue();
        this.injectCommaIfNeeded();
        this.writeStringRaw("null");
        this.endsValue();
        return this;
    }

    public JsonWriter jsonValue(String value) {
        this.injectCommaIfNeeded();
        this.writeStringRaw(value);
        this.endsValue();
        return this;
    }

    public JsonWriter value(boolean value) {
        this.structure.addValue();
        this.injectCommaIfNeeded();
        this.writeStringRaw(value ? "true" : "false");
        this.endsValue();
        return this;
    }

    public JsonWriter value(String value) {
        if (value == null) {
            return this.nullValue();
        }
        this.structure.addValue();
        this.injectCommaIfNeeded();
        this.writeStringLiteral(value);
        this.endsValue();
        return this;
    }

    public JsonWriter value(int value) {
        this.structure.addValue();
        this.injectCommaIfNeeded();
        this.writeStringRaw(Integer.toString(value));
        this.endsValue();
        return this;
    }

    public JsonWriter value(long value) {
        this.structure.addValue();
        this.injectCommaIfNeeded();
        this.writeStringRaw(Long.toString(value));
        this.endsValue();
        return this;
    }

    public JsonWriter value(float value) {
        if (Float.isNaN(value)) {
            return this.nullValue();
        }
        this.structure.addValue();
        this.injectCommaIfNeeded();
        this.writeStringRaw(Float.toString(value));
        this.endsValue();
        return this;
    }

    public JsonWriter value(double value) {
        if (Double.isNaN(value)) {
            return this.nullValue();
        }
        this.structure.addValue();
        this.injectCommaIfNeeded();
        this.writeStringRaw(Double.toString(value));
        this.endsValue();
        return this;
    }

    public JsonWriter beginArray() {
        this.structure.beginArray();
        this.injectCommaIfNeeded();
        this.write('[');
        return this;
    }

    public JsonWriter endArray() {
        this.structure.endArray();
        this.endsValue();
        this.write(']');
        return this;
    }

    public byte[] toByteArray() {
        this.flush();
        return this.outputStream.toByteArray();
    }

    public String toString() {
        return new String(this.toByteArray(), StandardCharsets.UTF_8);
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        try {
            this.outputStream.close();
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void injectCommaIfNeeded() {
        if (this.requireComma) {
            this.write(',');
        }
        this.requireComma = false;
    }

    private void endsValue() {
        this.requireComma = true;
    }

    private void write(char ch) {
        try {
            this.writer.write(ch);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeStringLiteral(String str) {
        try {
            this.writer.write(34);
            block10: for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c > '\u007f') {
                    this.writer.write(92);
                    this.writer.write(117);
                    String hexCharacter = Integer.toHexString(c).toUpperCase(Locale.ROOT);
                    if (c < '\u1000') {
                        this.writer.write(48);
                        if (c < '\u0100') {
                            this.writer.write(48);
                        }
                    }
                    this.writer.append(hexCharacter);
                    continue;
                }
                switch (c) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        this.writer.write(92);
                        this.writer.write(c);
                        continue block10;
                    }
                    case '\b': {
                        this.writer.write(92);
                        this.writer.write(98);
                        continue block10;
                    }
                    case '\f': {
                        this.writer.write(92);
                        this.writer.write(102);
                        continue block10;
                    }
                    case '\n': {
                        this.writer.write(92);
                        this.writer.write(110);
                        continue block10;
                    }
                    case '\r': {
                        this.writer.write(92);
                        this.writer.write(114);
                        continue block10;
                    }
                    case '\t': {
                        this.writer.write(92);
                        this.writer.write(116);
                        continue block10;
                    }
                    default: {
                        this.writer.write(c);
                    }
                }
            }
            this.writer.write(34);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeStringRaw(String str) {
        try {
            this.writer.write(str);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

