/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.compiler.utils;

import ddtrot.dd.compiler.annotations.SourceLines;
import ddtrot.dd.compiler.annotations.SourcePath;
import java.lang.reflect.Executable;

public class CompilerUtils {
    public static final int LINE_UNKNOWN = -1;

    public static String getSourcePath(Class<?> clazz) {
        SourcePath sourcePathAnnotation = clazz.getAnnotation(SourcePath.class);
        if (sourcePathAnnotation != null) {
            return sourcePathAnnotation.value();
        }
        if (clazz.isAnonymousClass()) {
            try {
                Class<?> enclosingClass = clazz.getEnclosingClass();
                if (enclosingClass != null) {
                    return CompilerUtils.getSourcePath(enclosingClass);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getStartLine(Executable executable) {
        SourceLines methodLines = executable.getAnnotation(SourceLines.class);
        return methodLines != null ? methodLines.start() : -1;
    }

    public static int getEndLine(Executable executable) {
        SourceLines methodLines = executable.getAnnotation(SourceLines.class);
        return methodLines != null ? methodLines.end() : -1;
    }

    public static int getStartLine(Class<?> clazz) {
        SourceLines classLines = clazz.getAnnotation(SourceLines.class);
        return classLines != null ? classLines.start() : -1;
    }

    public static int getEndLine(Class<?> clazz) {
        SourceLines classLines = clazz.getAnnotation(SourceLines.class);
        return classLines != null ? classLines.end() : -1;
    }
}

