/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.sampling;

import datadog.trace.api.sampling.Sampler;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import javax.annotation.Nullable;

public class AdaptiveSampler
implements Sampler {
    private final double emaAlpha;
    private final int samplesPerWindow;
    private final AtomicReference<Counts> countsRef;
    private volatile double probability = 1.0;
    private volatile long samplesBudget;
    private double totalCountRunningAverage = 0.0;
    private double avgSamples;
    private final int budgetLookback;
    private final double budgetAlpha;
    private int countsSlotIdx = 0;
    private final Counts[] countsSlots = new Counts[]{new Counts(), new Counts()};
    private final ConfigListener listener;
    private final Duration windowDuration;
    private final AgentTaskScheduler taskScheduler;

    protected AdaptiveSampler(Duration windowDuration, int samplesPerWindow, int averageLookback, int budgetLookback, @Nullable ConfigListener listener, AgentTaskScheduler taskScheduler, boolean startSampler) {
        if (averageLookback < 1) {
            throw new IllegalArgumentException("'averageLookback' argument must be at least 1");
        }
        if (budgetLookback < 1) {
            throw new IllegalArgumentException("'budgetLookback' argument must be at least 1");
        }
        this.samplesPerWindow = samplesPerWindow;
        this.budgetLookback = budgetLookback;
        this.samplesBudget = (long)samplesPerWindow + (long)budgetLookback * (long)samplesPerWindow;
        this.emaAlpha = AdaptiveSampler.computeIntervalAlpha(averageLookback);
        this.budgetAlpha = AdaptiveSampler.computeIntervalAlpha(budgetLookback);
        this.countsRef = new AtomicReference<Counts>(this.countsSlots[0]);
        this.listener = listener;
        if (listener != null) {
            listener.onWindowRoll(0L, 0L, this.samplesBudget, this.totalCountRunningAverage, this.probability);
        }
        this.windowDuration = windowDuration;
        this.taskScheduler = taskScheduler;
        if (startSampler) {
            this.start();
        }
    }

    public AdaptiveSampler(Duration windowDuration, int samplesPerWindow, int averageLookback, int budgetLookback, boolean startSampler) {
        this(windowDuration, samplesPerWindow, averageLookback, budgetLookback, null, AgentTaskScheduler.get(), startSampler);
    }

    public AdaptiveSampler(Duration windowDuration, int samplesPerWindow, int averageLookback, int budgetLookback, ConfigListener listener) {
        this(windowDuration, samplesPerWindow, averageLookback, budgetLookback, listener, AgentTaskScheduler.get(), true);
    }

    public void start() {
        this.taskScheduler.weakScheduleAtFixedRate(RollWindowTask.INSTANCE, this, this.windowDuration.toNanos(), this.windowDuration.toNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public boolean sample() {
        Counts counts = this.countsRef.get();
        counts.addTest();
        if (ThreadLocalRandom.current().nextDouble() < this.probability) {
            return counts.addSample(this.samplesBudget);
        }
        return false;
    }

    @Override
    public boolean keep() {
        Counts counts = this.countsRef.get();
        counts.addTest();
        counts.addSample();
        return true;
    }

    @Override
    public boolean drop() {
        Counts counts = this.countsRef.get();
        counts.addTest();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollWindow() {
        Counts counts = this.countsSlots[this.countsSlotIdx];
        try {
            this.countsSlotIdx = this.countsSlotIdx++ % 2;
            this.countsRef.set(this.countsSlots[this.countsSlotIdx]);
            long totalCount = counts.testCount();
            long sampledCount = counts.sampleCount();
            this.samplesBudget = this.calculateBudgetEma(sampledCount);
            this.totalCountRunningAverage = this.totalCountRunningAverage == 0.0 || this.emaAlpha <= 0.0 ? (double)totalCount : (this.totalCountRunningAverage += this.emaAlpha * ((double)totalCount - this.totalCountRunningAverage));
            this.probability = this.totalCountRunningAverage <= 0.0 ? 1.0 : Math.min((double)this.samplesBudget / this.totalCountRunningAverage, 1.0);
            if (this.listener != null) {
                this.listener.onWindowRoll(totalCount, sampledCount, this.samplesBudget, this.totalCountRunningAverage, this.probability);
            }
        }
        finally {
            counts.reset();
        }
    }

    private long calculateBudgetEma(long sampledCount) {
        this.avgSamples = Double.isNaN(this.avgSamples) || this.budgetAlpha <= 0.0 ? (double)sampledCount : this.avgSamples + this.budgetAlpha * ((double)sampledCount - this.avgSamples);
        return Math.round(Math.max((double)this.samplesPerWindow - this.avgSamples, 0.0) * (double)this.budgetLookback);
    }

    private static double computeIntervalAlpha(int lookback) {
        return 1.0 - Math.pow(lookback, -1.0 / (double)lookback);
    }

    long testCount() {
        return this.countsRef.get().testCount();
    }

    long sampleCount() {
        return this.countsRef.get().sampleCount();
    }

    private static class RollWindowTask
    implements AgentTaskScheduler.Task<AdaptiveSampler> {
        static final RollWindowTask INSTANCE = new RollWindowTask();

        private RollWindowTask() {
        }

        @Override
        public void run(AdaptiveSampler target) {
            target.rollWindow();
        }
    }

    @FunctionalInterface
    public static interface ConfigListener {
        public void onWindowRoll(long var1, long var3, long var5, double var7, double var9);
    }

    private static final class Counts {
        private final LongAdder testCount = new LongAdder();
        private static final AtomicLongFieldUpdater<Counts> SAMPLE_COUNT = AtomicLongFieldUpdater.newUpdater(Counts.class, "sampleCount");
        private volatile long sampleCount = 0L;

        private Counts() {
        }

        void addTest() {
            this.testCount.increment();
        }

        boolean addSample(long limit) {
            return SAMPLE_COUNT.getAndAccumulate(this, limit, (prev, lim) -> Math.min(prev + 1L, lim)) < limit;
        }

        void addSample() {
            SAMPLE_COUNT.incrementAndGet(this);
        }

        void reset() {
            this.testCount.reset();
            SAMPLE_COUNT.set(this, 0L);
        }

        long sampleCount() {
            return SAMPLE_COUNT.get(this);
        }

        long testCount() {
            return this.testCount.sum();
        }
    }
}

