/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.buffer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.LongConsumer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class InjectingPipeOutputStream
extends OutputStream {
    private final byte[] lookbehind;
    private int pos;
    private int count;
    private final byte[] marker;
    private final byte[] contentToInject;
    private boolean filter;
    private boolean wasDraining;
    private int matchingPos;
    private final Runnable onContentInjected;
    private final int bulkWriteThreshold;
    private final OutputStream downstream;
    private final LongConsumer onBytesWritten;
    private final LongConsumer onInjectionTime;
    private long bytesWritten = 0L;

    public InjectingPipeOutputStream(OutputStream downstream, byte[] marker, byte[] contentToInject) {
        this(downstream, marker, contentToInject, null, null, null);
    }

    public InjectingPipeOutputStream(OutputStream downstream, byte[] marker, byte[] contentToInject, Runnable onContentInjected, LongConsumer onBytesWritten, LongConsumer onInjectionTime) {
        this.downstream = downstream;
        this.marker = marker;
        this.lookbehind = new byte[marker.length];
        this.pos = 0;
        this.count = 0;
        this.matchingPos = 0;
        this.wasDraining = false;
        this.filter = true;
        this.contentToInject = contentToInject;
        this.onContentInjected = onContentInjected;
        this.onBytesWritten = onBytesWritten;
        this.onInjectionTime = onInjectionTime;
        this.bulkWriteThreshold = marker.length * 2 - 2;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.filter) {
            if (this.wasDraining) {
                this.drain();
            }
            this.downstream.write(b);
            ++this.bytesWritten;
            return;
        }
        if (this.count == this.lookbehind.length) {
            this.downstream.write(this.lookbehind[this.pos]);
            ++this.bytesWritten;
        } else {
            ++this.count;
        }
        this.lookbehind[this.pos] = (byte)b;
        this.pos = (this.pos + 1) % this.lookbehind.length;
        if (this.marker[this.matchingPos++] == b) {
            if (this.matchingPos == this.marker.length) {
                this.filter = false;
                long injectionStart = System.nanoTime();
                this.downstream.write(this.contentToInject);
                long injectionEnd = System.nanoTime();
                if (this.onInjectionTime != null) {
                    this.onInjectionTime.accept((injectionEnd - injectionStart) / 1000000L);
                }
                if (this.onContentInjected != null) {
                    this.onContentInjected.run();
                }
                this.drain();
            }
        } else {
            this.matchingPos = 0;
        }
    }

    @Override
    public void write(byte[] array, int off, int len) throws IOException {
        if (!this.filter) {
            if (this.wasDraining) {
                this.drain();
            }
            this.downstream.write(array, off, len);
            this.bytesWritten += (long)len;
            return;
        }
        if (len > this.bulkWriteThreshold) {
            int idx = this.arrayContains(array, off, len, this.marker);
            if (idx >= 0) {
                this.filter = false;
                this.drain();
                int bytesToWrite = idx;
                this.downstream.write(array, off, bytesToWrite);
                this.bytesWritten += (long)bytesToWrite;
                long injectionStart = System.nanoTime();
                this.downstream.write(this.contentToInject);
                long injectionEnd = System.nanoTime();
                if (this.onInjectionTime != null) {
                    this.onInjectionTime.accept((injectionEnd - injectionStart) / 1000000L);
                }
                if (this.onContentInjected != null) {
                    this.onContentInjected.run();
                }
                bytesToWrite = len - idx;
                this.downstream.write(array, off + idx, bytesToWrite);
                this.bytesWritten += (long)bytesToWrite;
            } else {
                for (int i = off; i < off + this.marker.length - 1; ++i) {
                    this.write(array[i]);
                }
                this.drain();
                boolean wasFiltering = this.filter;
                this.filter = false;
                int bytesToWrite = len - this.bulkWriteThreshold;
                this.downstream.write(array, off + this.marker.length - 1, bytesToWrite);
                this.bytesWritten += (long)bytesToWrite;
                this.filter = wasFiltering;
                for (int i = len - this.marker.length + 1; i < len; ++i) {
                    this.write(array[i]);
                }
            }
        } else {
            for (int i = off; i < off + len; ++i) {
                this.write(array[i]);
            }
        }
    }

    private int arrayContains(byte[] array, int off, int len, byte[] search) {
        for (int i = off; i < len - search.length; ++i) {
            if (array[i] != search[0]) continue;
            boolean found = true;
            int k = i;
            for (int j = 1; j < search.length; ++j) {
                if (array[++k] == search[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    private void drain() throws IOException {
        if (this.count > 0) {
            boolean wasFiltering = this.filter;
            this.filter = false;
            this.wasDraining = true;
            int start = (this.pos - this.count + this.lookbehind.length) % this.lookbehind.length;
            int cnt = this.count;
            for (int i = 0; i < cnt; ++i) {
                this.downstream.write(this.lookbehind[(start + i) % this.lookbehind.length]);
                ++this.bytesWritten;
                --this.count;
            }
            this.filter = wasFiltering;
            this.wasDraining = false;
        }
    }

    public void commit() throws IOException {
        if (this.filter || this.wasDraining) {
            this.drain();
        }
    }

    @Override
    public void flush() throws IOException {
        this.downstream.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.commit();
            if (this.onBytesWritten != null) {
                this.onBytesWritten.accept(this.bytesWritten);
            }
            this.bytesWritten = 0L;
        }
        finally {
            this.downstream.close();
        }
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }
}

