/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.json.JsonWriter;
import datadog.trace.bootstrap.environment.EnvironmentVariables;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class BootstrapInitializationTelemetry {
    private static final int DEFAULT_MAX_TAGS = 5;

    public static BootstrapInitializationTelemetry noOpInstance() {
        return NoOp.INSTANCE;
    }

    public static BootstrapInitializationTelemetry createFromForwarderPath(String forwarderPath) {
        return new JsonBased(new ForwarderJsonSender(forwarderPath));
    }

    public abstract void initMetaInfo(String var1, String var2);

    public abstract void onAbort(String var1);

    public abstract void onError(Throwable var1);

    public abstract void onError(String var1);

    public abstract void onFatalError(Throwable var1);

    public abstract void markIncomplete();

    public abstract void finish();

    public static final class NoOp
    extends BootstrapInitializationTelemetry {
        static final NoOp INSTANCE = new NoOp();

        private NoOp() {
        }

        @Override
        public void initMetaInfo(String attr, String value) {
        }

        @Override
        public void onAbort(String reasonCode) {
        }

        @Override
        public void onError(String reasonCode) {
        }

        @Override
        public void onError(Throwable t) {
        }

        @Override
        public void onFatalError(Throwable t) {
        }

        @Override
        public void markIncomplete() {
        }

        @Override
        public void finish() {
        }
    }

    public static final class JsonBased
    extends BootstrapInitializationTelemetry {
        private final JsonSender sender;
        private final Telemetry telemetry;
        private volatile boolean incomplete = false;

        JsonBased(JsonSender sender) {
            this.sender = sender;
            this.telemetry = new Telemetry();
        }

        @Override
        public void initMetaInfo(String attr, String value) {
            this.telemetry.setMetadata(attr, value);
        }

        @Override
        public void onAbort(String reasonCode) {
            this.onPoint("library_entrypoint.abort", Collections.singletonList("reason:" + reasonCode));
            this.markIncomplete();
            this.setResultMeta("abort", this.mapResultClass(reasonCode), reasonCode);
        }

        @Override
        public void onError(Throwable t) {
            this.setResultMeta("error", "internal_error", t.getMessage());
            List<String> causes = new ArrayList<String>();
            for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
                causes.add("error_type:" + cause.getClass().getName());
            }
            causes.add("error_type:" + t.getClass().getName());
            int maxTags = this.maxTags();
            int numCauses = causes.size();
            if (numCauses > maxTags) {
                causes = causes.subList(numCauses - maxTags, numCauses);
            }
            this.onPoint("library_entrypoint.error", causes);
        }

        @Override
        public void onError(String reasonCode) {
            this.onPoint("library_entrypoint.error", Collections.singletonList("error_type:" + reasonCode));
            this.setResultMeta("error", this.mapResultClass(reasonCode), reasonCode);
        }

        private int maxTags() {
            String maxTags = EnvironmentVariables.get("DD_TELEMETRY_FORWARDER_MAX_TAGS");
            if (maxTags != null) {
                try {
                    return Integer.parseInt(maxTags);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return 5;
        }

        @Override
        public void onFatalError(Throwable t) {
            this.onError(t);
            this.markIncomplete();
        }

        private void setResultMeta(String result, String resultClass, String resultReason) {
            this.initMetaInfo("result", result);
            this.initMetaInfo("result_class", resultClass);
            this.initMetaInfo("result_reason", resultReason);
        }

        private String mapResultClass(String reasonCode) {
            if (reasonCode == null) {
                return "success";
            }
            switch (reasonCode) {
                case "already_initialized": {
                    return "already_instrumented";
                }
                case "other-java-agents": {
                    return "incompatible_library";
                }
                case "jdk_tool": {
                    return "unsupported_binary";
                }
            }
            return "unknown";
        }

        private void onPoint(String name, List<String> tags) {
            this.telemetry.addPoint(name, tags);
        }

        @Override
        public void markIncomplete() {
            this.incomplete = true;
        }

        @Override
        public void finish() {
            if (!this.incomplete) {
                this.onPoint("library_entrypoint.complete", Collections.emptyList());
            }
            this.sender.send(this.telemetry);
        }
    }

    public static final class ForwarderJsonSender
    implements JsonSender {
        private final String forwarderPath;

        ForwarderJsonSender(String forwarderPath) {
            this.forwarderPath = forwarderPath;
        }

        @Override
        public void send(Object telemetry) {
            ForwarderJsonSenderThread t = new ForwarderJsonSenderThread(this.forwarderPath, telemetry);
            t.setDaemon(true);
            t.start();
        }
    }

    public static interface JsonSender {
        public void send(Object var1);
    }

    public static final class ForwarderJsonSenderThread
    extends Thread {
        private final String forwarderPath;
        private final Object telemetry;

        public ForwarderJsonSenderThread(String forwarderPath, Object telemetry) {
            super("dd-forwarder-json-sender");
            this.forwarderPath = forwarderPath;
            this.telemetry = telemetry;
        }

        @Override
        @SuppressForbidden
        public void run() {
            ProcessBuilder builder = new ProcessBuilder(this.forwarderPath, "library_entrypoint");
            try (Closeable ignored = this.muteTracing();){
                byte[] payload = this.telemetry.toString().getBytes();
                Process process = builder.start();
                try (OutputStream out = process.getOutputStream();){
                    out.write(payload);
                }
            }
            catch (Throwable e) {
                System.err.println("Failed to send telemetry: " + e.getMessage());
            }
        }

        @SuppressForbidden
        private Closeable muteTracing() {
            try {
                Class<?> agentTracerClass = Class.forName("datadog.trace.bootstrap.instrumentation.api.AgentTracer");
                Object tracerAPI = agentTracerClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
                Object scope = tracerAPI.getClass().getMethod("muteTracing", new Class[0]).invoke(tracerAPI, new Object[0]);
                return (Closeable)scope;
            }
            catch (Throwable e) {
                return () -> {};
            }
        }
    }

    public static class Telemetry {
        private final Map<String, String> metadata = new LinkedHashMap<String, String>();
        private final Map<String, List<String>> points = new LinkedHashMap<String, List<String>>();

        public Telemetry() {
            this.setResults("success", "success", "Successfully configured ddtrace package");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMetadata(String name, String value) {
            Map<String, String> map = this.metadata;
            synchronized (map) {
                this.metadata.put(name, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setResults(String result, String resultClass, String resultReason) {
            Map<String, String> map = this.metadata;
            synchronized (map) {
                this.metadata.put("result", result);
                this.metadata.put("result_class", resultClass);
                this.metadata.put("result_reason", resultReason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPoint(String name, List<String> tags) {
            Map<String, List<String>> map = this.points;
            synchronized (map) {
                this.points.put(name, tags);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            try (JsonWriter writer = new JsonWriter();){
                writer.beginObject();
                writer.name("metadata").beginObject();
                Object object = this.metadata;
                synchronized (object) {
                    for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                        writer.name(entry.getKey());
                        writer.value(entry.getValue());
                    }
                    this.metadata.clear();
                }
                writer.endObject();
                writer.name("points").beginArray();
                object = this.points;
                synchronized (object) {
                    for (Map.Entry<String, Object> entry : this.points.entrySet()) {
                        writer.beginObject();
                        writer.name("name").value(entry.getKey());
                        if (!((List)entry.getValue()).isEmpty()) {
                            writer.name("tags").beginArray();
                            for (String tag : (List)entry.getValue()) {
                                writer.value(tag);
                            }
                            writer.endArray();
                        }
                        writer.endObject();
                    }
                    this.points.clear();
                }
                writer.endArray();
                writer.endObject();
                object = writer.toString();
                return object;
            }
        }
    }
}

