/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.logging.ddlogger;

import datadog.slf4j.Marker;
import datadog.slf4j.helpers.MessageFormatter;
import datadog.trace.api.telemetry.LogCollector;
import datadog.trace.logging.LogLevel;
import datadog.trace.logging.LoggerHelper;
import datadog.trace.logging.ddlogger.DDLogger;

public class DDTelemetryLogger
extends DDLogger {
    public DDTelemetryLogger(LoggerHelper helper, String name) {
        super(helper, name);
    }

    @Override
    public void formatLog(LogLevel level, Marker marker, String format, Object arg) {
        this.telemetryLog(level, marker, format, this.getIfThrowable(arg));
        super.formatLog(level, marker, format, arg);
    }

    @Override
    public void formatLog(LogLevel level, Marker marker, String format, Object arg1, Object arg2) {
        this.telemetryLog(level, marker, format, this.getIfThrowable(arg2));
        super.formatLog(level, marker, format, arg1, arg2);
    }

    @Override
    public void formatLog(LogLevel level, Marker marker, String format, Object ... arguments) {
        this.telemetryLog(level, marker, format, MessageFormatter.getThrowableCandidate(arguments));
        super.formatLog(level, marker, format, arguments);
    }

    @Override
    protected void log(LogLevel level, Marker marker, String msg, Throwable t) {
        this.telemetryLog(level, marker, msg, t);
        super.log(level, marker, msg, t);
    }

    private void telemetryLog(LogLevel level, Marker marker, String msgOrgFormat, Throwable t) {
        if (marker == LogCollector.EXCLUDE_TELEMETRY) {
            return;
        }
        if (t == null && marker != LogCollector.SEND_TELEMETRY) {
            return;
        }
        LogCollector.get().addLogMessage(level.name(), msgOrgFormat, t);
    }

    private Throwable getIfThrowable(Object obj) {
        return obj instanceof Throwable ? (Throwable)obj : null;
    }
}

