/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.rmi;

import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.AgentSpanContext;
import datadog.trace.bootstrap.instrumentation.api.ContextVisitors;
import datadog.trace.bootstrap.instrumentation.rmi.ContextPayload;
import datadog.trace.bootstrap.instrumentation.rmi.ContextPropagator;
import datadog.trace.bootstrap.instrumentation.rmi.ThreadLocalContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.rmi.Remote;
import java.rmi.server.RemoteCall;
import sun.rmi.server.Dispatcher;
import sun.rmi.transport.Target;

public class ContextDispatcher
implements Dispatcher {
    private static final ContextDispatcher CONTEXT_DISPATCHER = new ContextDispatcher();
    private static final NoopRemote NOOP_REMOTE = new NoopRemote();

    public static Target newDispatcherTarget() {
        return new Target(NOOP_REMOTE, CONTEXT_DISPATCHER, NOOP_REMOTE, ContextPropagator.DD_CONTEXT_CALL_ID, false);
    }

    @Override
    public void dispatch(Remote obj, RemoteCall call) throws IOException {
        ContextPayload payload;
        ObjectInput in = call.getInputStream();
        int operationId = in.readInt();
        in.readLong();
        if (ContextPropagator.PROPAGATOR.isOperationWithPayload(operationId) && (payload = ContextPayload.read(in)) != null) {
            AgentSpanContext.Extracted context = AgentPropagation.extractContextAndGetSpanContext(payload.getContext(), ContextVisitors.stringValuesMap());
            ThreadLocalContext.THREAD_LOCAL_CONTEXT.set(context);
        }
        call.getResultStream(true);
        call.releaseInputStream();
        call.releaseOutputStream();
        call.done();
    }

    public static class NoopRemote
    implements Remote {
    }
}

