/*
 * Decompiled with CFR 0.152.
 */
package datadog.context;

import datadog.context.Context;
import datadog.context.ContextKey;
import datadog.context.SingletonContext;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class EmptyContext
implements Context {
    static final Context INSTANCE = new EmptyContext();

    EmptyContext() {
    }

    @Override
    @Nullable
    public <T> T get(ContextKey<T> key) {
        return null;
    }

    @Override
    public <T> Context with(ContextKey<T> key, @Nullable T value) {
        Objects.requireNonNull(key, "Context key cannot be null");
        if (value == null) {
            return this;
        }
        return new SingletonContext(key.index, value);
    }

    public String toString() {
        return "EmptyContext{}";
    }
}

