/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.api;

import datadog.trace.bootstrap.otel.api.OpenTelemetry;
import datadog.trace.bootstrap.otel.api.metrics.MeterProvider;
import datadog.trace.bootstrap.otel.api.trace.TracerProvider;
import datadog.trace.bootstrap.otel.context.propagation.ContextPropagators;
import datadog.trace.bootstrap.otel.shim.context.propagation.OtelContextPropagators;
import datadog.trace.bootstrap.otel.shim.trace.OtelTracerProvider;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class DefaultOpenTelemetry
implements OpenTelemetry {
    private static final OpenTelemetry NO_OP = new DefaultOpenTelemetry(ContextPropagators.noop());
    private final ContextPropagators propagators;

    static OpenTelemetry getNoop() {
        return NO_OP;
    }

    static OpenTelemetry getPropagating(ContextPropagators propagators) {
        return new DefaultOpenTelemetry(propagators);
    }

    DefaultOpenTelemetry(ContextPropagators propagators) {
        this.propagators = propagators;
    }

    @Override
    public TracerProvider getTracerProvider() {
        return OtelTracerProvider.INSTANCE;
    }

    @Override
    public MeterProvider getMeterProvider() {
        return MeterProvider.noop();
    }

    @Override
    public ContextPropagators getPropagators() {
        return OtelContextPropagators.INSTANCE;
    }

    public String toString() {
        return "DefaultOpenTelemetry{propagators=" + this.propagators + "}";
    }
}

