/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.civisibility.coverage;

import datadog.trace.api.civisibility.InstrumentationTestBridge;
import datadog.trace.api.civisibility.coverage.CoverageProbes;
import datadog.trace.api.civisibility.coverage.CoverageStore;
import datadog.trace.api.civisibility.coverage.NoOpProbes;
import datadog.trace.api.civisibility.domain.TestContext;

public abstract class CoveragePerTestBridge {
    private static final ThreadLocal<CoverageProbes> COVERAGE_PROBES = new ThreadLocal();
    private static volatile CoverageStore.Registry COVERAGE_STORE_REGISTRY;

    public static void registerCoverageStoreRegistry(CoverageStore.Registry coverageStoreRegistry) {
        COVERAGE_STORE_REGISTRY = coverageStoreRegistry;
    }

    public static CoverageStore.Registry getCoverageStoreRegistry() {
        return COVERAGE_STORE_REGISTRY;
    }

    public static void recordCoverage(Class<?> clazz, long classId, int probeId) {
        CoveragePerTestBridge.getCurrentCoverageProbes().record(clazz, classId, probeId);
    }

    public static void recordCoverage(Class<?> clazz) {
        CoveragePerTestBridge.getCurrentCoverageProbes().record(clazz);
    }

    public static void recordCoverage(String absolutePath) {
        CoveragePerTestBridge.getCurrentCoverageProbes().recordNonCodeResource(absolutePath);
    }

    private static CoverageProbes getCurrentCoverageProbes() {
        CoverageProbes probes = COVERAGE_PROBES.get();
        if (probes != null) {
            return probes;
        }
        TestContext currentTest = InstrumentationTestBridge.getCurrentTestContext();
        if (currentTest != null) {
            return currentTest.getCoverageStore().getProbes();
        }
        return NoOpProbes.INSTANCE;
    }

    public static void setThreadLocalCoverageProbes(CoverageProbes probes) {
        COVERAGE_PROBES.set(probes);
    }

    public static void removeThreadLocalCoverageProbes() {
        COVERAGE_PROBES.remove();
    }
}

