/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.ConfigOrigin;
import datadog.trace.api.ConfigSetting;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ConfigCollector {
    private static final ConfigCollector INSTANCE = new ConfigCollector();
    private static final AtomicReferenceFieldUpdater<ConfigCollector, Map> COLLECTED_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ConfigCollector.class, Map.class, "collected");
    private volatile Map<String, ConfigSetting> collected = new ConcurrentHashMap<String, ConfigSetting>();

    public static ConfigCollector get() {
        return INSTANCE;
    }

    public void put(String key, Object value, ConfigOrigin origin) {
        ConfigSetting setting = ConfigSetting.of(key, value, origin);
        this.collected.put(key, setting);
    }

    public void put(String key, Object value, ConfigOrigin origin, String configId) {
        ConfigSetting setting = ConfigSetting.of(key, value, origin, configId);
        this.collected.put(key, setting);
    }

    public void putAll(Map<String, Object> keysAndValues, ConfigOrigin origin) {
        ConcurrentHashMap<String, ConfigSetting> merged = new ConcurrentHashMap<String, ConfigSetting>(keysAndValues.size() + this.collected.size());
        for (Map.Entry<String, Object> entry : keysAndValues.entrySet()) {
            ConfigSetting setting = ConfigSetting.of(entry.getKey(), entry.getValue(), origin);
            merged.put(entry.getKey(), setting);
        }
        while (true) {
            Map<String, ConfigSetting> current = this.collected;
            current.forEach(merged::putIfAbsent);
            if (COLLECTED_UPDATER.compareAndSet(this, current, merged)) break;
            merged.keySet().retainAll(keysAndValues.keySet());
        }
    }

    public Map<String, ConfigSetting> collect() {
        if (!this.collected.isEmpty()) {
            return COLLECTED_UPDATER.getAndSet(this, new ConcurrentHashMap());
        }
        return Collections.emptyMap();
    }
}

