/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util;

import datadog.environment.JavaVirtualMachine;
import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public abstract class ProcessUtils {
    private static final Logger log = LoggerFactory.getLogger(ProcessUtils.class);

    @Nullable
    @SuppressForbidden
    public static String getCurrentJvmPath() {
        if (JavaVirtualMachine.isJavaVersionAtLeast(9)) {
            try {
                Supplier jdk9Supplier = (Supplier)Class.forName("datadog.trace.util.JDK9ExecutableSupplier").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return (String)jdk9Supplier.get();
            }
            catch (Throwable e) {
                log.debug("Could not get process executable path using JDK9ExecutableSupplier", e);
            }
        }
        return System.getProperty("java.home");
    }

    private ProcessUtils() {
    }
}

