/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.trace.api.Platform;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.java.concurrent.AsyncResultExtension;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;

public final class AsyncResultExtensions {
    private static final List<AsyncResultExtension> EXTENSIONS = new CopyOnWriteArrayList<CompletableAsyncResultExtension>(Collections.singletonList(new CompletableAsyncResultExtension()));

    public static void register(AsyncResultExtension extension) {
        if (extension != null) {
            if (Platform.isNativeImageBuilder() && extension.getClass().getClassLoader().getClass().getName().endsWith("ThrowawayClassLoader")) {
                return;
            }
            EXTENSIONS.add(extension);
        }
    }

    public static List<AsyncResultExtension> registered() {
        return EXTENSIONS;
    }

    public static <T> BiConsumer<T, Throwable> finishSpan(AgentSpan span) {
        return (o, throwable) -> {
            if (throwable != null) {
                span.addThrowable(throwable instanceof ExecutionException || throwable instanceof CompletionException ? throwable.getCause() : throwable);
            }
            span.finish();
        };
    }

    static final class CompletableAsyncResultExtension
    implements AsyncResultExtension {
        CompletableAsyncResultExtension() {
        }

        @Override
        public boolean supports(Class<?> result) {
            return CompletableFuture.class.isAssignableFrom(result) || CompletionStage.class.isAssignableFrom(result);
        }

        @Override
        public Object apply(Object result, AgentSpan span) {
            if (result instanceof CompletableFuture) {
                CompletableFuture completableFuture = (CompletableFuture)result;
                if (!completableFuture.isDone() && !completableFuture.isCancelled()) {
                    return completableFuture.whenComplete(AsyncResultExtensions.finishSpan(span));
                }
            } else if (result instanceof CompletionStage) {
                CompletionStage completionStage = (CompletionStage)result;
                return completionStage.whenComplete(AsyncResultExtensions.finishSpan(span));
            }
            return null;
        }
    }
}

