/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.naming.v1;

import datadog.trace.api.naming.NamingSchema;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PeerServiceNamingV1
implements NamingSchema.ForPeerService {
    private static final Map<Object, String[]> SPECIFIC_PRECURSORS_BY_COMPONENT = PeerServiceNamingV1.initPrecursorsByComponent();
    private static final String[] DEFAULT_PRECURSORS = new String[]{"db.instance", "peer.hostname"};
    private final Map<String, String> overridesByComponent;

    private static Map<Object, String[]> initPrecursorsByComponent() {
        HashMap<Object, String[]> ret = new HashMap<Object, String[]>(7);
        ret.put("java-kafka", new String[]{"messaging.kafka.bootstrap.servers"});
        ret.put("hazelcast-sdk", new String[]{"hazelcast.instance", "peer.hostname"});
        ret.put("couchbase-client", new String[]{"db.couchbase.seed.nodes", "net.peer.name", "peer.hostname"});
        ret.put("java-cassandra", new String[]{"db.cassandra.contact.points", "peer.hostname"});
        String[] rpcPrecursors = new String[]{"rpc.service", "peer.hostname"};
        ret.put("grpc-client", rpcPrecursors);
        ret.put("armeria-grpc-client", rpcPrecursors);
        ret.put("rmi-client", rpcPrecursors);
        ret.put("java-aws-sdk", new String[0]);
        return ret;
    }

    public PeerServiceNamingV1(@Nonnull Map<String, String> overridesByComponent) {
        this.overridesByComponent = overridesByComponent;
    }

    @Override
    public boolean supports() {
        return true;
    }

    private void resolve(@Nonnull Map<String, Object> unsafeTags) {
        Object component = unsafeTags.get("component");
        String componentString = component == null ? null : component.toString();
        String override = this.overridesByComponent.get(componentString);
        if (override != null) {
            this.set(unsafeTags, override, "_component_override");
            return;
        }
        if (this.resolveBy(unsafeTags, SPECIFIC_PRECURSORS_BY_COMPONENT.get(componentString))) {
            return;
        }
        this.resolveBy(unsafeTags, DEFAULT_PRECURSORS);
    }

    private boolean resolveBy(@Nonnull Map<String, Object> unsafeTags, @Nullable String[] precursors) {
        if (precursors == null) {
            return false;
        }
        Object value = null;
        String source = null;
        for (String precursor : precursors) {
            value = unsafeTags.get(precursor);
            if (value == null) continue;
            source = precursor;
            break;
        }
        this.set(unsafeTags, value, source);
        return true;
    }

    private void set(@Nonnull Map<String, Object> unsafeTags, Object value, String source) {
        if (value != null) {
            unsafeTags.put("peer.service", value);
            unsafeTags.put("_dd.peer.service.source", source);
        }
    }

    @Override
    @Nonnull
    public Map<String, Object> tags(@Nonnull Map<String, Object> unsafeTags) {
        Object kind = unsafeTags.get("span.kind");
        if ("client".equals(kind) || "producer".equals(kind)) {
            this.resolve(unsafeTags);
        }
        return unsafeTags;
    }
}

