/*
 * Decompiled with CFR 0.152.
 */
package datadog.snakeyaml.representer;

import datadog.snakeyaml.DumperOptions;
import datadog.snakeyaml.nodes.Node;
import datadog.snakeyaml.nodes.Tag;
import datadog.snakeyaml.representer.Represent;
import datadog.snakeyaml.representer.Representer;
import datadog.snakeyaml.representer.SafeRepresenter;
import java.util.Base64;
import java.util.Date;

public class JsonRepresenter
extends Representer {
    public JsonRepresenter(DumperOptions options) {
        super(options);
        this.representers.put(byte[].class, new RepresentByteArray());
        this.multiRepresenters.put(Date.class, new RepresentDate());
        if (options.getDefaultScalarStyle() != DumperOptions.ScalarStyle.JSON_SCALAR_STYLE) {
            throw new IllegalStateException("JSON requires ScalarStyle.JSON_SCALAR_STYLE");
        }
        if (options.getNonPrintableStyle() != DumperOptions.NonPrintableStyle.ESCAPE) {
            throw new IllegalStateException("JSON requires NonPrintableStyle.ESCAPE");
        }
    }

    protected class RepresentByteArray
    implements Represent {
        protected RepresentByteArray() {
        }

        @Override
        public Node representData(Object data) {
            String binary = Base64.getEncoder().encodeToString((byte[])data);
            return JsonRepresenter.this.representScalar(Tag.STR, binary);
        }
    }

    protected class RepresentDate
    extends SafeRepresenter.RepresentDate {
        protected RepresentDate() {
            super(JsonRepresenter.this);
        }

        @Override
        public Tag getDefaultTag() {
            return Tag.STR;
        }
    }
}

