/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.ServiceDefinitionCreateResponse;
import com.datadog.api.client.v2.model.ServiceDefinitionGetResponse;
import com.datadog.api.client.v2.model.ServiceDefinitionsCreateRequest;
import com.datadog.api.client.v2.model.ServiceDefinitionsListResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class ServiceDefinitionApi {
    private ApiClient apiClient;

    public ServiceDefinitionApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ServiceDefinitionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ServiceDefinitionCreateResponse createOrUpdateServiceDefinitions(ServiceDefinitionsCreateRequest body) throws ApiException {
        return this.createOrUpdateServiceDefinitionsWithHttpInfo(body).getData();
    }

    public CompletableFuture<ServiceDefinitionCreateResponse> createOrUpdateServiceDefinitionsAsync(ServiceDefinitionsCreateRequest body) {
        return this.createOrUpdateServiceDefinitionsWithHttpInfoAsync(body).thenApply(response -> (ServiceDefinitionCreateResponse)response.getData());
    }

    public ApiResponse<ServiceDefinitionCreateResponse> createOrUpdateServiceDefinitionsWithHttpInfo(ServiceDefinitionsCreateRequest body) throws ApiException {
        ServiceDefinitionsCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createOrUpdateServiceDefinitions");
        }
        String localVarPath = "/api/v2/services/definitions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceDefinitionApi.createOrUpdateServiceDefinitions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ServiceDefinitionCreateResponse>(){});
    }

    public CompletableFuture<ApiResponse<ServiceDefinitionCreateResponse>> createOrUpdateServiceDefinitionsWithHttpInfoAsync(ServiceDefinitionsCreateRequest body) {
        Invocation.Builder builder;
        ServiceDefinitionsCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<ServiceDefinitionCreateResponse>> result = new CompletableFuture<ApiResponse<ServiceDefinitionCreateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createOrUpdateServiceDefinitions"));
            return result;
        }
        String localVarPath = "/api/v2/services/definitions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("ServiceDefinitionApi.createOrUpdateServiceDefinitions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ServiceDefinitionCreateResponse>> result = new CompletableFuture<ApiResponse<ServiceDefinitionCreateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ServiceDefinitionCreateResponse>(){});
    }

    public void deleteServiceDefinition(String serviceName) throws ApiException {
        this.deleteServiceDefinitionWithHttpInfo(serviceName);
    }

    public CompletableFuture<Void> deleteServiceDefinitionAsync(String serviceName) {
        return this.deleteServiceDefinitionWithHttpInfoAsync(serviceName).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteServiceDefinitionWithHttpInfo(String serviceName) throws ApiException {
        Object localVarPostBody = null;
        if (serviceName == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceName' when calling deleteServiceDefinition");
        }
        String localVarPath = "/api/v2/services/definitions/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceDefinitionApi.deleteServiceDefinition", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteServiceDefinitionWithHttpInfoAsync(String serviceName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (serviceName == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceName' when calling deleteServiceDefinition"));
            return result;
        }
        String localVarPath = "/api/v2/services/definitions/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("ServiceDefinitionApi.deleteServiceDefinition", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public ServiceDefinitionGetResponse getServiceDefinition(String serviceName) throws ApiException {
        return this.getServiceDefinitionWithHttpInfo(serviceName).getData();
    }

    public CompletableFuture<ServiceDefinitionGetResponse> getServiceDefinitionAsync(String serviceName) {
        return this.getServiceDefinitionWithHttpInfoAsync(serviceName).thenApply(response -> (ServiceDefinitionGetResponse)response.getData());
    }

    public ApiResponse<ServiceDefinitionGetResponse> getServiceDefinitionWithHttpInfo(String serviceName) throws ApiException {
        Object localVarPostBody = null;
        if (serviceName == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceName' when calling getServiceDefinition");
        }
        String localVarPath = "/api/v2/services/definitions/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceDefinitionApi.getServiceDefinition", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ServiceDefinitionGetResponse>(){});
    }

    public CompletableFuture<ApiResponse<ServiceDefinitionGetResponse>> getServiceDefinitionWithHttpInfoAsync(String serviceName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (serviceName == null) {
            CompletableFuture<ApiResponse<ServiceDefinitionGetResponse>> result = new CompletableFuture<ApiResponse<ServiceDefinitionGetResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceName' when calling getServiceDefinition"));
            return result;
        }
        String localVarPath = "/api/v2/services/definitions/{service_name}".replaceAll("\\{service_name\\}", this.apiClient.escapeString(serviceName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("ServiceDefinitionApi.getServiceDefinition", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ServiceDefinitionGetResponse>> result = new CompletableFuture<ApiResponse<ServiceDefinitionGetResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ServiceDefinitionGetResponse>(){});
    }

    public ServiceDefinitionsListResponse listServiceDefinitions() throws ApiException {
        return this.listServiceDefinitionsWithHttpInfo().getData();
    }

    public CompletableFuture<ServiceDefinitionsListResponse> listServiceDefinitionsAsync() {
        return this.listServiceDefinitionsWithHttpInfoAsync().thenApply(response -> (ServiceDefinitionsListResponse)response.getData());
    }

    public ApiResponse<ServiceDefinitionsListResponse> listServiceDefinitionsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/services/definitions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ServiceDefinitionApi.listServiceDefinitions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ServiceDefinitionsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<ServiceDefinitionsListResponse>> listServiceDefinitionsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/services/definitions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("ServiceDefinitionApi.listServiceDefinitions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ServiceDefinitionsListResponse>> result = new CompletableFuture<ApiResponse<ServiceDefinitionsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ServiceDefinitionsListResponse>(){});
    }
}

