/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.AzureScanOptionsDataAttributes;
import com.datadog.api.client.v2.model.AzureScanOptionsDataType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"attributes", "id", "type"})
public class AzureScanOptionsData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private AzureScanOptionsDataAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private AzureScanOptionsDataType type = AzureScanOptionsDataType.AZURE_SCAN_OPTIONS;
    private Map<String, Object> additionalProperties;

    public AzureScanOptionsData() {
    }

    @JsonCreator
    public AzureScanOptionsData(@JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="type") AzureScanOptionsDataType type) {
        this.id = id;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public AzureScanOptionsData attributes(AzureScanOptionsDataAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AzureScanOptionsDataAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AzureScanOptionsDataAttributes attributes) {
        this.attributes = attributes;
    }

    public AzureScanOptionsData id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AzureScanOptionsData type(AzureScanOptionsDataType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AzureScanOptionsDataType getType() {
        return this.type;
    }

    public void setType(AzureScanOptionsDataType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public AzureScanOptionsData putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureScanOptionsData azureScanOptionsData = (AzureScanOptionsData)o;
        return Objects.equals(this.attributes, azureScanOptionsData.attributes) && Objects.equals(this.id, azureScanOptionsData.id) && Objects.equals(this.type, azureScanOptionsData.type) && Objects.equals(this.additionalProperties, azureScanOptionsData.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.id, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AzureScanOptionsData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

