/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.FleetAgentInfoResponse;
import com.datadog.api.client.v2.model.FleetAgentVersionsResponse;
import com.datadog.api.client.v2.model.FleetAgentsResponse;
import com.datadog.api.client.v2.model.FleetDeploymentConfigureCreateRequest;
import com.datadog.api.client.v2.model.FleetDeploymentPackageUpgradeCreateRequest;
import com.datadog.api.client.v2.model.FleetDeploymentResponse;
import com.datadog.api.client.v2.model.FleetDeploymentsResponse;
import com.datadog.api.client.v2.model.FleetScheduleCreateRequest;
import com.datadog.api.client.v2.model.FleetSchedulePatchRequest;
import com.datadog.api.client.v2.model.FleetScheduleResponse;
import com.datadog.api.client.v2.model.FleetSchedulesResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class FleetAutomationApi {
    private ApiClient apiClient;

    public FleetAutomationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public FleetAutomationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void cancelFleetDeployment(String deploymentId) throws ApiException {
        this.cancelFleetDeploymentWithHttpInfo(deploymentId);
    }

    public CompletableFuture<Void> cancelFleetDeploymentAsync(String deploymentId) {
        return this.cancelFleetDeploymentWithHttpInfoAsync(deploymentId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> cancelFleetDeploymentWithHttpInfo(String deploymentId) throws ApiException {
        String operationId = "cancelFleetDeployment";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (deploymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'deploymentId' when calling cancelFleetDeployment");
        }
        String localVarPath = "/api/unstable/fleet/deployments/{deployment_id}/cancel".replaceAll("\\{deployment_id\\}", this.apiClient.escapeString(deploymentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.cancelFleetDeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> cancelFleetDeploymentWithHttpInfoAsync(String deploymentId) {
        Invocation.Builder builder;
        String operationId = "cancelFleetDeployment";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (deploymentId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'deploymentId' when calling cancelFleetDeployment"));
            return result;
        }
        String localVarPath = "/api/unstable/fleet/deployments/{deployment_id}/cancel".replaceAll("\\{deployment_id\\}", this.apiClient.escapeString(deploymentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.cancelFleetDeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public FleetDeploymentResponse createFleetDeploymentConfigure(FleetDeploymentConfigureCreateRequest body) throws ApiException {
        return this.createFleetDeploymentConfigureWithHttpInfo(body).getData();
    }

    public CompletableFuture<FleetDeploymentResponse> createFleetDeploymentConfigureAsync(FleetDeploymentConfigureCreateRequest body) {
        return this.createFleetDeploymentConfigureWithHttpInfoAsync(body).thenApply(response -> (FleetDeploymentResponse)response.getData());
    }

    public ApiResponse<FleetDeploymentResponse> createFleetDeploymentConfigureWithHttpInfo(FleetDeploymentConfigureCreateRequest body) throws ApiException {
        String operationId = "createFleetDeploymentConfigure";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FleetDeploymentConfigureCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createFleetDeploymentConfigure");
        }
        String localVarPath = "/api/unstable/fleet/deployments/configure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.createFleetDeploymentConfigure", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentResponse>(){});
    }

    public CompletableFuture<ApiResponse<FleetDeploymentResponse>> createFleetDeploymentConfigureWithHttpInfoAsync(FleetDeploymentConfigureCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createFleetDeploymentConfigure";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FleetDeploymentConfigureCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createFleetDeploymentConfigure"));
            return result;
        }
        String localVarPath = "/api/unstable/fleet/deployments/configure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.createFleetDeploymentConfigure", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentResponse>(){});
    }

    public FleetDeploymentResponse createFleetDeploymentUpgrade(FleetDeploymentPackageUpgradeCreateRequest body) throws ApiException {
        return this.createFleetDeploymentUpgradeWithHttpInfo(body).getData();
    }

    public CompletableFuture<FleetDeploymentResponse> createFleetDeploymentUpgradeAsync(FleetDeploymentPackageUpgradeCreateRequest body) {
        return this.createFleetDeploymentUpgradeWithHttpInfoAsync(body).thenApply(response -> (FleetDeploymentResponse)response.getData());
    }

    public ApiResponse<FleetDeploymentResponse> createFleetDeploymentUpgradeWithHttpInfo(FleetDeploymentPackageUpgradeCreateRequest body) throws ApiException {
        String operationId = "createFleetDeploymentUpgrade";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FleetDeploymentPackageUpgradeCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createFleetDeploymentUpgrade");
        }
        String localVarPath = "/api/unstable/fleet/deployments/upgrade";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.createFleetDeploymentUpgrade", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentResponse>(){});
    }

    public CompletableFuture<ApiResponse<FleetDeploymentResponse>> createFleetDeploymentUpgradeWithHttpInfoAsync(FleetDeploymentPackageUpgradeCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createFleetDeploymentUpgrade";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FleetDeploymentPackageUpgradeCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createFleetDeploymentUpgrade"));
            return result;
        }
        String localVarPath = "/api/unstable/fleet/deployments/upgrade";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.createFleetDeploymentUpgrade", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentResponse>(){});
    }

    public FleetScheduleResponse createFleetSchedule(FleetScheduleCreateRequest body) throws ApiException {
        return this.createFleetScheduleWithHttpInfo(body).getData();
    }

    public CompletableFuture<FleetScheduleResponse> createFleetScheduleAsync(FleetScheduleCreateRequest body) {
        return this.createFleetScheduleWithHttpInfoAsync(body).thenApply(response -> (FleetScheduleResponse)response.getData());
    }

    public ApiResponse<FleetScheduleResponse> createFleetScheduleWithHttpInfo(FleetScheduleCreateRequest body) throws ApiException {
        String operationId = "createFleetSchedule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FleetScheduleCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createFleetSchedule");
        }
        String localVarPath = "/api/unstable/fleet/schedules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.createFleetSchedule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetScheduleResponse>(){});
    }

    public CompletableFuture<ApiResponse<FleetScheduleResponse>> createFleetScheduleWithHttpInfoAsync(FleetScheduleCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createFleetSchedule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FleetScheduleResponse>> result = new CompletableFuture<ApiResponse<FleetScheduleResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FleetScheduleCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<FleetScheduleResponse>> result = new CompletableFuture<ApiResponse<FleetScheduleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createFleetSchedule"));
            return result;
        }
        String localVarPath = "/api/unstable/fleet/schedules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.createFleetSchedule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FleetScheduleResponse>> result = new CompletableFuture<ApiResponse<FleetScheduleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetScheduleResponse>(){});
    }

    public void deleteFleetSchedule(String id) throws ApiException {
        this.deleteFleetScheduleWithHttpInfo(id);
    }

    public CompletableFuture<Void> deleteFleetScheduleAsync(String id) {
        return this.deleteFleetScheduleWithHttpInfoAsync(id).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteFleetScheduleWithHttpInfo(String id) throws ApiException {
        String operationId = "deleteFleetSchedule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteFleetSchedule");
        }
        String localVarPath = "/api/unstable/fleet/schedules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.deleteFleetSchedule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteFleetScheduleWithHttpInfoAsync(String id) {
        Invocation.Builder builder;
        String operationId = "deleteFleetSchedule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling deleteFleetSchedule"));
            return result;
        }
        String localVarPath = "/api/unstable/fleet/schedules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.deleteFleetSchedule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public FleetAgentInfoResponse getFleetAgentInfo(String agentKey) throws ApiException {
        return this.getFleetAgentInfoWithHttpInfo(agentKey).getData();
    }

    public CompletableFuture<FleetAgentInfoResponse> getFleetAgentInfoAsync(String agentKey) {
        return this.getFleetAgentInfoWithHttpInfoAsync(agentKey).thenApply(response -> (FleetAgentInfoResponse)response.getData());
    }

    public ApiResponse<FleetAgentInfoResponse> getFleetAgentInfoWithHttpInfo(String agentKey) throws ApiException {
        String operationId = "getFleetAgentInfo";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (agentKey == null) {
            throw new ApiException(400, "Missing the required parameter 'agentKey' when calling getFleetAgentInfo");
        }
        String localVarPath = "/api/unstable/fleet/agents/{agent_key}".replaceAll("\\{agent_key\\}", this.apiClient.escapeString(agentKey.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.getFleetAgentInfo", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetAgentInfoResponse>(){});
    }

    public CompletableFuture<ApiResponse<FleetAgentInfoResponse>> getFleetAgentInfoWithHttpInfoAsync(String agentKey) {
        Invocation.Builder builder;
        String operationId = "getFleetAgentInfo";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FleetAgentInfoResponse>> result = new CompletableFuture<ApiResponse<FleetAgentInfoResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (agentKey == null) {
            CompletableFuture<ApiResponse<FleetAgentInfoResponse>> result = new CompletableFuture<ApiResponse<FleetAgentInfoResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'agentKey' when calling getFleetAgentInfo"));
            return result;
        }
        String localVarPath = "/api/unstable/fleet/agents/{agent_key}".replaceAll("\\{agent_key\\}", this.apiClient.escapeString(agentKey.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.getFleetAgentInfo", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FleetAgentInfoResponse>> result = new CompletableFuture<ApiResponse<FleetAgentInfoResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetAgentInfoResponse>(){});
    }

    public FleetDeploymentResponse getFleetDeployment(String deploymentId) throws ApiException {
        return this.getFleetDeploymentWithHttpInfo(deploymentId, new GetFleetDeploymentOptionalParameters()).getData();
    }

    public CompletableFuture<FleetDeploymentResponse> getFleetDeploymentAsync(String deploymentId) {
        return this.getFleetDeploymentWithHttpInfoAsync(deploymentId, new GetFleetDeploymentOptionalParameters()).thenApply(response -> (FleetDeploymentResponse)response.getData());
    }

    public FleetDeploymentResponse getFleetDeployment(String deploymentId, GetFleetDeploymentOptionalParameters parameters) throws ApiException {
        return this.getFleetDeploymentWithHttpInfo(deploymentId, parameters).getData();
    }

    public CompletableFuture<FleetDeploymentResponse> getFleetDeploymentAsync(String deploymentId, GetFleetDeploymentOptionalParameters parameters) {
        return this.getFleetDeploymentWithHttpInfoAsync(deploymentId, parameters).thenApply(response -> (FleetDeploymentResponse)response.getData());
    }

    public ApiResponse<FleetDeploymentResponse> getFleetDeploymentWithHttpInfo(String deploymentId, GetFleetDeploymentOptionalParameters parameters) throws ApiException {
        String operationId = "getFleetDeployment";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (deploymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'deploymentId' when calling getFleetDeployment");
        }
        Long limit = parameters.limit;
        Long page = parameters.page;
        String localVarPath = "/api/unstable/fleet/deployments/{deployment_id}".replaceAll("\\{deployment_id\\}", this.apiClient.escapeString(deploymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.getFleetDeployment", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentResponse>(){});
    }

    public CompletableFuture<ApiResponse<FleetDeploymentResponse>> getFleetDeploymentWithHttpInfoAsync(String deploymentId, GetFleetDeploymentOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getFleetDeployment";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (deploymentId == null) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'deploymentId' when calling getFleetDeployment"));
            return result;
        }
        Long limit = parameters.limit;
        Long page = parameters.page;
        String localVarPath = "/api/unstable/fleet/deployments/{deployment_id}".replaceAll("\\{deployment_id\\}", this.apiClient.escapeString(deploymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.getFleetDeployment", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentResponse>(){});
    }

    public FleetScheduleResponse getFleetSchedule(String id) throws ApiException {
        return this.getFleetScheduleWithHttpInfo(id).getData();
    }

    public CompletableFuture<FleetScheduleResponse> getFleetScheduleAsync(String id) {
        return this.getFleetScheduleWithHttpInfoAsync(id).thenApply(response -> (FleetScheduleResponse)response.getData());
    }

    public ApiResponse<FleetScheduleResponse> getFleetScheduleWithHttpInfo(String id) throws ApiException {
        String operationId = "getFleetSchedule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getFleetSchedule");
        }
        String localVarPath = "/api/unstable/fleet/schedules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.getFleetSchedule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetScheduleResponse>(){});
    }

    public CompletableFuture<ApiResponse<FleetScheduleResponse>> getFleetScheduleWithHttpInfoAsync(String id) {
        Invocation.Builder builder;
        String operationId = "getFleetSchedule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FleetScheduleResponse>> result = new CompletableFuture<ApiResponse<FleetScheduleResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<FleetScheduleResponse>> result = new CompletableFuture<ApiResponse<FleetScheduleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling getFleetSchedule"));
            return result;
        }
        String localVarPath = "/api/unstable/fleet/schedules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.getFleetSchedule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FleetScheduleResponse>> result = new CompletableFuture<ApiResponse<FleetScheduleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetScheduleResponse>(){});
    }

    public FleetAgentsResponse listFleetAgents() throws ApiException {
        return this.listFleetAgentsWithHttpInfo(new ListFleetAgentsOptionalParameters()).getData();
    }

    public CompletableFuture<FleetAgentsResponse> listFleetAgentsAsync() {
        return this.listFleetAgentsWithHttpInfoAsync(new ListFleetAgentsOptionalParameters()).thenApply(response -> (FleetAgentsResponse)response.getData());
    }

    public FleetAgentsResponse listFleetAgents(ListFleetAgentsOptionalParameters parameters) throws ApiException {
        return this.listFleetAgentsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<FleetAgentsResponse> listFleetAgentsAsync(ListFleetAgentsOptionalParameters parameters) {
        return this.listFleetAgentsWithHttpInfoAsync(parameters).thenApply(response -> (FleetAgentsResponse)response.getData());
    }

    public ApiResponse<FleetAgentsResponse> listFleetAgentsWithHttpInfo(ListFleetAgentsOptionalParameters parameters) throws ApiException {
        String operationId = "listFleetAgents";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageNumber = parameters.pageNumber;
        Long pageSize = parameters.pageSize;
        String sortAttribute = parameters.sortAttribute;
        Boolean sortDescending = parameters.sortDescending;
        String tags = parameters.tags;
        String filter = parameters.filter;
        String localVarPath = "/api/unstable/fleet/agents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_number", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_attribute", sortAttribute));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_descending", sortDescending));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.listFleetAgents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetAgentsResponse>(){});
    }

    public CompletableFuture<ApiResponse<FleetAgentsResponse>> listFleetAgentsWithHttpInfoAsync(ListFleetAgentsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listFleetAgents";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FleetAgentsResponse>> result = new CompletableFuture<ApiResponse<FleetAgentsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageNumber = parameters.pageNumber;
        Long pageSize = parameters.pageSize;
        String sortAttribute = parameters.sortAttribute;
        Boolean sortDescending = parameters.sortDescending;
        String tags = parameters.tags;
        String filter = parameters.filter;
        String localVarPath = "/api/unstable/fleet/agents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_number", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_attribute", sortAttribute));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_descending", sortDescending));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.listFleetAgents", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FleetAgentsResponse>> result = new CompletableFuture<ApiResponse<FleetAgentsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetAgentsResponse>(){});
    }

    public FleetAgentVersionsResponse listFleetAgentVersions() throws ApiException {
        return this.listFleetAgentVersionsWithHttpInfo().getData();
    }

    public CompletableFuture<FleetAgentVersionsResponse> listFleetAgentVersionsAsync() {
        return this.listFleetAgentVersionsWithHttpInfoAsync().thenApply(response -> (FleetAgentVersionsResponse)response.getData());
    }

    public ApiResponse<FleetAgentVersionsResponse> listFleetAgentVersionsWithHttpInfo() throws ApiException {
        String operationId = "listFleetAgentVersions";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String localVarPath = "/api/unstable/fleet/agent_versions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.listFleetAgentVersions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetAgentVersionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<FleetAgentVersionsResponse>> listFleetAgentVersionsWithHttpInfoAsync() {
        Invocation.Builder builder;
        String operationId = "listFleetAgentVersions";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FleetAgentVersionsResponse>> result = new CompletableFuture<ApiResponse<FleetAgentVersionsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String localVarPath = "/api/unstable/fleet/agent_versions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.listFleetAgentVersions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FleetAgentVersionsResponse>> result = new CompletableFuture<ApiResponse<FleetAgentVersionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetAgentVersionsResponse>(){});
    }

    public FleetDeploymentsResponse listFleetDeployments() throws ApiException {
        return this.listFleetDeploymentsWithHttpInfo(new ListFleetDeploymentsOptionalParameters()).getData();
    }

    public CompletableFuture<FleetDeploymentsResponse> listFleetDeploymentsAsync() {
        return this.listFleetDeploymentsWithHttpInfoAsync(new ListFleetDeploymentsOptionalParameters()).thenApply(response -> (FleetDeploymentsResponse)response.getData());
    }

    public FleetDeploymentsResponse listFleetDeployments(ListFleetDeploymentsOptionalParameters parameters) throws ApiException {
        return this.listFleetDeploymentsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<FleetDeploymentsResponse> listFleetDeploymentsAsync(ListFleetDeploymentsOptionalParameters parameters) {
        return this.listFleetDeploymentsWithHttpInfoAsync(parameters).thenApply(response -> (FleetDeploymentsResponse)response.getData());
    }

    public ApiResponse<FleetDeploymentsResponse> listFleetDeploymentsWithHttpInfo(ListFleetDeploymentsOptionalParameters parameters) throws ApiException {
        String operationId = "listFleetDeployments";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/unstable/fleet/deployments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_offset", pageOffset));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.listFleetDeployments", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentsResponse>(){});
    }

    public CompletableFuture<ApiResponse<FleetDeploymentsResponse>> listFleetDeploymentsWithHttpInfoAsync(ListFleetDeploymentsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listFleetDeployments";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FleetDeploymentsResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/unstable/fleet/deployments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_offset", pageOffset));
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.listFleetDeployments", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FleetDeploymentsResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentsResponse>(){});
    }

    public FleetSchedulesResponse listFleetSchedules() throws ApiException {
        return this.listFleetSchedulesWithHttpInfo().getData();
    }

    public CompletableFuture<FleetSchedulesResponse> listFleetSchedulesAsync() {
        return this.listFleetSchedulesWithHttpInfoAsync().thenApply(response -> (FleetSchedulesResponse)response.getData());
    }

    public ApiResponse<FleetSchedulesResponse> listFleetSchedulesWithHttpInfo() throws ApiException {
        String operationId = "listFleetSchedules";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String localVarPath = "/api/unstable/fleet/schedules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.listFleetSchedules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetSchedulesResponse>(){});
    }

    public CompletableFuture<ApiResponse<FleetSchedulesResponse>> listFleetSchedulesWithHttpInfoAsync() {
        Invocation.Builder builder;
        String operationId = "listFleetSchedules";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FleetSchedulesResponse>> result = new CompletableFuture<ApiResponse<FleetSchedulesResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String localVarPath = "/api/unstable/fleet/schedules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.listFleetSchedules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FleetSchedulesResponse>> result = new CompletableFuture<ApiResponse<FleetSchedulesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetSchedulesResponse>(){});
    }

    public FleetDeploymentResponse triggerFleetSchedule(String id) throws ApiException {
        return this.triggerFleetScheduleWithHttpInfo(id).getData();
    }

    public CompletableFuture<FleetDeploymentResponse> triggerFleetScheduleAsync(String id) {
        return this.triggerFleetScheduleWithHttpInfoAsync(id).thenApply(response -> (FleetDeploymentResponse)response.getData());
    }

    public ApiResponse<FleetDeploymentResponse> triggerFleetScheduleWithHttpInfo(String id) throws ApiException {
        String operationId = "triggerFleetSchedule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling triggerFleetSchedule");
        }
        String localVarPath = "/api/unstable/fleet/schedules/{id}/trigger".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.triggerFleetSchedule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentResponse>(){});
    }

    public CompletableFuture<ApiResponse<FleetDeploymentResponse>> triggerFleetScheduleWithHttpInfoAsync(String id) {
        Invocation.Builder builder;
        String operationId = "triggerFleetSchedule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling triggerFleetSchedule"));
            return result;
        }
        String localVarPath = "/api/unstable/fleet/schedules/{id}/trigger".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.triggerFleetSchedule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FleetDeploymentResponse>> result = new CompletableFuture<ApiResponse<FleetDeploymentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetDeploymentResponse>(){});
    }

    public FleetScheduleResponse updateFleetSchedule(String id, FleetSchedulePatchRequest body) throws ApiException {
        return this.updateFleetScheduleWithHttpInfo(id, body).getData();
    }

    public CompletableFuture<FleetScheduleResponse> updateFleetScheduleAsync(String id, FleetSchedulePatchRequest body) {
        return this.updateFleetScheduleWithHttpInfoAsync(id, body).thenApply(response -> (FleetScheduleResponse)response.getData());
    }

    public ApiResponse<FleetScheduleResponse> updateFleetScheduleWithHttpInfo(String id, FleetSchedulePatchRequest body) throws ApiException {
        String operationId = "updateFleetSchedule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FleetSchedulePatchRequest localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateFleetSchedule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateFleetSchedule");
        }
        String localVarPath = "/api/unstable/fleet/schedules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FleetAutomationApi.updateFleetSchedule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetScheduleResponse>(){});
    }

    public CompletableFuture<ApiResponse<FleetScheduleResponse>> updateFleetScheduleWithHttpInfoAsync(String id, FleetSchedulePatchRequest body) {
        Invocation.Builder builder;
        String operationId = "updateFleetSchedule";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<FleetScheduleResponse>> result = new CompletableFuture<ApiResponse<FleetScheduleResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        FleetSchedulePatchRequest localVarPostBody = body;
        if (id == null) {
            CompletableFuture<ApiResponse<FleetScheduleResponse>> result = new CompletableFuture<ApiResponse<FleetScheduleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling updateFleetSchedule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<FleetScheduleResponse>> result = new CompletableFuture<ApiResponse<FleetScheduleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateFleetSchedule"));
            return result;
        }
        String localVarPath = "/api/unstable/fleet/schedules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FleetAutomationApi.updateFleetSchedule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FleetScheduleResponse>> result = new CompletableFuture<ApiResponse<FleetScheduleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FleetScheduleResponse>(){});
    }

    public static class ListFleetDeploymentsOptionalParameters {
        private Long pageSize;
        private Long pageOffset;

        public ListFleetDeploymentsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListFleetDeploymentsOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }
    }

    public static class ListFleetAgentsOptionalParameters {
        private Long pageNumber;
        private Long pageSize;
        private String sortAttribute;
        private Boolean sortDescending;
        private String tags;
        private String filter;

        public ListFleetAgentsOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListFleetAgentsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListFleetAgentsOptionalParameters sortAttribute(String sortAttribute) {
            this.sortAttribute = sortAttribute;
            return this;
        }

        public ListFleetAgentsOptionalParameters sortDescending(Boolean sortDescending) {
            this.sortDescending = sortDescending;
            return this;
        }

        public ListFleetAgentsOptionalParameters tags(String tags) {
            this.tags = tags;
            return this;
        }

        public ListFleetAgentsOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }
    }

    public static class GetFleetDeploymentOptionalParameters {
        private Long limit;
        private Long page;

        public GetFleetDeploymentOptionalParameters limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public GetFleetDeploymentOptionalParameters page(Long page) {
            this.page = page;
            return this;
        }
    }
}

