/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.AbstractOpenApiSchema;
import com.datadog.api.client.JSON;
import com.datadog.api.client.UnparsedObject;
import com.datadog.api.client.v2.model.ActionQuery;
import com.datadog.api.client.v2.model.DataTransform;
import com.datadog.api.client.v2.model.StateVariable;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.core.JsonGenerator;
import com.datadoghq.com.fasterxml.jackson.core.JsonParser;
import com.datadoghq.com.fasterxml.jackson.core.JsonProcessingException;
import com.datadoghq.com.fasterxml.jackson.core.JsonToken;
import com.datadoghq.com.fasterxml.jackson.core.type.TypeReference;
import com.datadoghq.com.fasterxml.jackson.databind.DeserializationContext;
import com.datadoghq.com.fasterxml.jackson.databind.JsonMappingException;
import com.datadoghq.com.fasterxml.jackson.databind.JsonNode;
import com.datadoghq.com.fasterxml.jackson.databind.MapperFeature;
import com.datadoghq.com.fasterxml.jackson.databind.ObjectMapper;
import com.datadoghq.com.fasterxml.jackson.databind.SerializerProvider;
import com.datadoghq.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.datadoghq.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.datadoghq.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.datadoghq.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonDeserialize(using=QueryDeserializer.class)
@JsonSerialize(using=QuerySerializer.class)
public class Query
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(Query.class.getName());
    @JsonIgnore
    public boolean unparsed = false;
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public Query() {
        super("oneOf", Boolean.FALSE);
    }

    public Query(ActionQuery o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public Query(DataTransform o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public Query(StateVariable o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(ActionQuery.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(DataTransform.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(StateVariable.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(UnparsedObject.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be ActionQuery, DataTransform, StateVariable");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public ActionQuery getActionQuery() throws ClassCastException {
        return (ActionQuery)super.getActualInstance();
    }

    public DataTransform getDataTransform() throws ClassCastException {
        return (DataTransform)super.getActualInstance();
    }

    public StateVariable getStateVariable() throws ClassCastException {
        return (StateVariable)super.getActualInstance();
    }

    static {
        schemas.put("ActionQuery", new GenericType<ActionQuery>(){});
        schemas.put("DataTransform", new GenericType<DataTransform>(){});
        schemas.put("StateVariable", new GenericType<StateVariable>(){});
        JSON.registerDescendants(Query.class, Collections.unmodifiableMap(schemas));
    }

    public static class QueryDeserializer
    extends StdDeserializer<Query> {
        public QueryDeserializer() {
            this(Query.class);
        }

        public QueryDeserializer(Class<?> vc) {
            super(vc);
        }

        @Override
        public Query deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            Object deserialized = null;
            Object tmp = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            try {
                boolean attemptParsing = true;
                if ((ActionQuery.class.equals(Integer.class) || ActionQuery.class.equals(Long.class) || ActionQuery.class.equals(Float.class) || ActionQuery.class.equals(Double.class) || ActionQuery.class.equals(Boolean.class) || ActionQuery.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (ActionQuery.class.equals(Integer.class) || ActionQuery.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= !(!ActionQuery.class.equals(Float.class) && !ActionQuery.class.equals(Double.class) || token != JsonToken.VALUE_NUMBER_FLOAT && token != JsonToken.VALUE_NUMBER_INT);
                    attemptParsing |= ActionQuery.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= ActionQuery.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    tmp = tree.traverse(jp.getCodec()).readValueAs(ActionQuery.class);
                    if (!((ActionQuery)tmp).unparsed) {
                        deserialized = tmp;
                        ++match;
                    }
                    log.log(Level.FINER, "Input data matches schema 'ActionQuery'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'ActionQuery'", e);
            }
            try {
                boolean attemptParsing = true;
                if ((DataTransform.class.equals(Integer.class) || DataTransform.class.equals(Long.class) || DataTransform.class.equals(Float.class) || DataTransform.class.equals(Double.class) || DataTransform.class.equals(Boolean.class) || DataTransform.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (DataTransform.class.equals(Integer.class) || DataTransform.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= !(!DataTransform.class.equals(Float.class) && !DataTransform.class.equals(Double.class) || token != JsonToken.VALUE_NUMBER_FLOAT && token != JsonToken.VALUE_NUMBER_INT);
                    attemptParsing |= DataTransform.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= DataTransform.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    tmp = tree.traverse(jp.getCodec()).readValueAs(DataTransform.class);
                    if (!((DataTransform)tmp).unparsed) {
                        deserialized = tmp;
                        ++match;
                    }
                    log.log(Level.FINER, "Input data matches schema 'DataTransform'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'DataTransform'", e);
            }
            try {
                boolean attemptParsing = true;
                if ((StateVariable.class.equals(Integer.class) || StateVariable.class.equals(Long.class) || StateVariable.class.equals(Float.class) || StateVariable.class.equals(Double.class) || StateVariable.class.equals(Boolean.class) || StateVariable.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (StateVariable.class.equals(Integer.class) || StateVariable.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= !(!StateVariable.class.equals(Float.class) && !StateVariable.class.equals(Double.class) || token != JsonToken.VALUE_NUMBER_FLOAT && token != JsonToken.VALUE_NUMBER_INT);
                    attemptParsing |= StateVariable.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= StateVariable.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    tmp = tree.traverse(jp.getCodec()).readValueAs(StateVariable.class);
                    if (!((StateVariable)tmp).unparsed) {
                        deserialized = tmp;
                        ++match;
                    }
                    log.log(Level.FINER, "Input data matches schema 'StateVariable'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'StateVariable'", e);
            }
            Query ret = new Query();
            if (match == 1) {
                ret.setActualInstance(deserialized);
            } else {
                Map<String, Object> res = new ObjectMapper().readValue(tree.traverse(jp.getCodec()).readValueAsTree().toString(), new TypeReference<Map<String, Object>>(){});
                ret.setActualInstance(new UnparsedObject(res));
            }
            return ret;
        }

        @Override
        public Query getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException(ctxt.getParser(), "Query cannot be null");
        }
    }

    public static class QuerySerializer
    extends StdSerializer<Query> {
        public QuerySerializer(Class<Query> t) {
            super(t);
        }

        public QuerySerializer() {
            this((Class<Query>)null);
        }

        @Override
        public void serialize(Query value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }
}

