/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.MonitorUserTemplateTemplateVariablesItems;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"description", "monitor_definition", "tags", "template_variables", "title"})
public class MonitorUserTemplateRequestAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private JsonNullable<String> description = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MONITOR_DEFINITION = "monitor_definition";
    private Map<String, Object> monitorDefinition = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = new ArrayList<String>();
    public static final String JSON_PROPERTY_TEMPLATE_VARIABLES = "template_variables";
    private List<MonitorUserTemplateTemplateVariablesItems> templateVariables = null;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public MonitorUserTemplateRequestAttributes() {
    }

    @JsonCreator
    public MonitorUserTemplateRequestAttributes(@JsonProperty(required=true, value="monitor_definition") Map<String, Object> monitorDefinition, @JsonProperty(required=true, value="tags") List<String> tags, @JsonProperty(required=true, value="title") String title) {
        this.monitorDefinition = monitorDefinition;
        this.tags = tags;
        this.title = title;
    }

    public MonitorUserTemplateRequestAttributes description(String description) {
        this.description = JsonNullable.of(description);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getDescription() {
        return this.description.orElse(null);
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDescription_JsonNullable() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription_JsonNullable(JsonNullable<String> description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = JsonNullable.of(description);
    }

    public MonitorUserTemplateRequestAttributes monitorDefinition(Map<String, Object> monitorDefinition) {
        this.monitorDefinition = monitorDefinition;
        return this;
    }

    public MonitorUserTemplateRequestAttributes putMonitorDefinitionItem(String key, Object monitorDefinitionItem) {
        this.monitorDefinition.put(key, monitorDefinitionItem);
        return this;
    }

    @JsonProperty(value="monitor_definition")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Map<String, Object> getMonitorDefinition() {
        return this.monitorDefinition;
    }

    public void setMonitorDefinition(Map<String, Object> monitorDefinition) {
        this.monitorDefinition = monitorDefinition;
    }

    public MonitorUserTemplateRequestAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MonitorUserTemplateRequestAttributes addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public MonitorUserTemplateRequestAttributes templateVariables(List<MonitorUserTemplateTemplateVariablesItems> templateVariables) {
        this.templateVariables = templateVariables;
        for (MonitorUserTemplateTemplateVariablesItems item : templateVariables) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public MonitorUserTemplateRequestAttributes addTemplateVariablesItem(MonitorUserTemplateTemplateVariablesItems templateVariablesItem) {
        if (this.templateVariables == null) {
            this.templateVariables = new ArrayList<MonitorUserTemplateTemplateVariablesItems>();
        }
        this.templateVariables.add(templateVariablesItem);
        this.unparsed |= templateVariablesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="template_variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MonitorUserTemplateTemplateVariablesItems> getTemplateVariables() {
        return this.templateVariables;
    }

    public void setTemplateVariables(List<MonitorUserTemplateTemplateVariablesItems> templateVariables) {
        this.templateVariables = templateVariables;
    }

    public MonitorUserTemplateRequestAttributes title(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitorUserTemplateRequestAttributes monitorUserTemplateRequestAttributes = (MonitorUserTemplateRequestAttributes)o;
        return Objects.equals(this.description, monitorUserTemplateRequestAttributes.description) && Objects.equals(this.monitorDefinition, monitorUserTemplateRequestAttributes.monitorDefinition) && Objects.equals(this.tags, monitorUserTemplateRequestAttributes.tags) && Objects.equals(this.templateVariables, monitorUserTemplateRequestAttributes.templateVariables) && Objects.equals(this.title, monitorUserTemplateRequestAttributes.title);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.monitorDefinition, this.tags, this.templateVariables, this.title);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonitorUserTemplateRequestAttributes {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    monitorDefinition: ").append(this.toIndentedString(this.monitorDefinition)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    templateVariables: ").append(this.toIndentedString(this.templateVariables)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

