/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CasePriority;
import com.datadog.api.client.v2.model.CaseStatus;
import com.datadog.api.client.v2.model.IssueCaseInsight;
import com.datadog.api.client.v2.model.IssueCaseJiraIssue;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"archived_at", "closed_at", "created_at", "creation_source", "description", "due_date", "insights", "jira_issue", "key", "modified_at", "priority", "status", "title", "type"})
public class IssueCaseAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ARCHIVED_AT = "archived_at";
    private OffsetDateTime archivedAt;
    public static final String JSON_PROPERTY_CLOSED_AT = "closed_at";
    private OffsetDateTime closedAt;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_CREATION_SOURCE = "creation_source";
    private String creationSource;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DUE_DATE = "due_date";
    private String dueDate;
    public static final String JSON_PROPERTY_INSIGHTS = "insights";
    private List<IssueCaseInsight> insights = null;
    public static final String JSON_PROPERTY_JIRA_ISSUE = "jira_issue";
    private IssueCaseJiraIssue jiraIssue;
    public static final String JSON_PROPERTY_KEY = "key";
    private String key;
    public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
    private OffsetDateTime modifiedAt;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private CasePriority priority = CasePriority.NOT_DEFINED;
    public static final String JSON_PROPERTY_STATUS = "status";
    private CaseStatus status;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    private Map<String, Object> additionalProperties;

    public IssueCaseAttributes archivedAt(OffsetDateTime archivedAt) {
        this.archivedAt = archivedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="archived_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getArchivedAt() {
        return this.archivedAt;
    }

    public void setArchivedAt(OffsetDateTime archivedAt) {
        this.archivedAt = archivedAt;
    }

    public IssueCaseAttributes closedAt(OffsetDateTime closedAt) {
        this.closedAt = closedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="closed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(OffsetDateTime closedAt) {
        this.closedAt = closedAt;
    }

    public IssueCaseAttributes createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public IssueCaseAttributes creationSource(String creationSource) {
        this.creationSource = creationSource;
        return this;
    }

    @Nullable
    @JsonProperty(value="creation_source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreationSource() {
        return this.creationSource;
    }

    public void setCreationSource(String creationSource) {
        this.creationSource = creationSource;
    }

    public IssueCaseAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IssueCaseAttributes dueDate(String dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="due_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public IssueCaseAttributes insights(List<IssueCaseInsight> insights) {
        this.insights = insights;
        for (IssueCaseInsight item : insights) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public IssueCaseAttributes addInsightsItem(IssueCaseInsight insightsItem) {
        if (this.insights == null) {
            this.insights = new ArrayList<IssueCaseInsight>();
        }
        this.insights.add(insightsItem);
        this.unparsed |= insightsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="insights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IssueCaseInsight> getInsights() {
        return this.insights;
    }

    public void setInsights(List<IssueCaseInsight> insights) {
        this.insights = insights;
    }

    public IssueCaseAttributes jiraIssue(IssueCaseJiraIssue jiraIssue) {
        this.jiraIssue = jiraIssue;
        this.unparsed |= jiraIssue.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="jira_issue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IssueCaseJiraIssue getJiraIssue() {
        return this.jiraIssue;
    }

    public void setJiraIssue(IssueCaseJiraIssue jiraIssue) {
        this.jiraIssue = jiraIssue;
    }

    public IssueCaseAttributes key(String key) {
        this.key = key;
        return this;
    }

    @Nullable
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public IssueCaseAttributes modifiedAt(OffsetDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="modified_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(OffsetDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public IssueCaseAttributes priority(CasePriority priority) {
        this.priority = priority;
        this.unparsed |= !priority.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CasePriority getPriority() {
        return this.priority;
    }

    public void setPriority(CasePriority priority) {
        if (!priority.isValid()) {
            this.unparsed = true;
        }
        this.priority = priority;
    }

    public IssueCaseAttributes status(CaseStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(CaseStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public IssueCaseAttributes title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public IssueCaseAttributes type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonAnySetter
    public IssueCaseAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueCaseAttributes issueCaseAttributes = (IssueCaseAttributes)o;
        return Objects.equals(this.archivedAt, issueCaseAttributes.archivedAt) && Objects.equals(this.closedAt, issueCaseAttributes.closedAt) && Objects.equals(this.createdAt, issueCaseAttributes.createdAt) && Objects.equals(this.creationSource, issueCaseAttributes.creationSource) && Objects.equals(this.description, issueCaseAttributes.description) && Objects.equals(this.dueDate, issueCaseAttributes.dueDate) && Objects.equals(this.insights, issueCaseAttributes.insights) && Objects.equals(this.jiraIssue, issueCaseAttributes.jiraIssue) && Objects.equals(this.key, issueCaseAttributes.key) && Objects.equals(this.modifiedAt, issueCaseAttributes.modifiedAt) && Objects.equals(this.priority, issueCaseAttributes.priority) && Objects.equals(this.status, issueCaseAttributes.status) && Objects.equals(this.title, issueCaseAttributes.title) && Objects.equals(this.type, issueCaseAttributes.type) && Objects.equals(this.additionalProperties, issueCaseAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.archivedAt, this.closedAt, this.createdAt, this.creationSource, this.description, this.dueDate, this.insights, this.jiraIssue, this.key, this.modifiedAt, this.priority, this.status, this.title, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueCaseAttributes {\n");
        sb.append("    archivedAt: ").append(this.toIndentedString(this.archivedAt)).append("\n");
        sb.append("    closedAt: ").append(this.toIndentedString(this.closedAt)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    creationSource: ").append(this.toIndentedString(this.creationSource)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    insights: ").append(this.toIndentedString(this.insights)).append("\n");
        sb.append("    jiraIssue: ").append(this.toIndentedString(this.jiraIssue)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

