/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.DatadogAPIKeyType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"api_key", "app_key", "datacenter", "subdomain", "type"})
public class DatadogAPIKey {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_API_KEY = "api_key";
    private String apiKey;
    public static final String JSON_PROPERTY_APP_KEY = "app_key";
    private String appKey;
    public static final String JSON_PROPERTY_DATACENTER = "datacenter";
    private String datacenter;
    public static final String JSON_PROPERTY_SUBDOMAIN = "subdomain";
    private String subdomain;
    public static final String JSON_PROPERTY_TYPE = "type";
    private DatadogAPIKeyType type;
    private Map<String, Object> additionalProperties;

    public DatadogAPIKey() {
    }

    @JsonCreator
    public DatadogAPIKey(@JsonProperty(required=true, value="api_key") String apiKey, @JsonProperty(required=true, value="app_key") String appKey, @JsonProperty(required=true, value="datacenter") String datacenter, @JsonProperty(required=true, value="type") DatadogAPIKeyType type) {
        this.apiKey = apiKey;
        this.appKey = appKey;
        this.datacenter = datacenter;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public DatadogAPIKey apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @JsonProperty(value="api_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public DatadogAPIKey appKey(String appKey) {
        this.appKey = appKey;
        return this;
    }

    @JsonProperty(value="app_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public DatadogAPIKey datacenter(String datacenter) {
        this.datacenter = datacenter;
        return this;
    }

    @JsonProperty(value="datacenter")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDatacenter() {
        return this.datacenter;
    }

    public void setDatacenter(String datacenter) {
        this.datacenter = datacenter;
    }

    public DatadogAPIKey subdomain(String subdomain) {
        this.subdomain = subdomain;
        return this;
    }

    @Nullable
    @JsonProperty(value="subdomain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubdomain() {
        return this.subdomain;
    }

    public void setSubdomain(String subdomain) {
        this.subdomain = subdomain;
    }

    public DatadogAPIKey type(DatadogAPIKeyType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DatadogAPIKeyType getType() {
        return this.type;
    }

    public void setType(DatadogAPIKeyType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public DatadogAPIKey putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatadogAPIKey datadogApiKey = (DatadogAPIKey)o;
        return Objects.equals(this.apiKey, datadogApiKey.apiKey) && Objects.equals(this.appKey, datadogApiKey.appKey) && Objects.equals(this.datacenter, datadogApiKey.datacenter) && Objects.equals(this.subdomain, datadogApiKey.subdomain) && Objects.equals(this.type, datadogApiKey.type) && Objects.equals(this.additionalProperties, datadogApiKey.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.appKey, this.datacenter, this.subdomain, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatadogAPIKey {\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    appKey: ").append(this.toIndentedString(this.appKey)).append("\n");
        sb.append("    datacenter: ").append(this.toIndentedString(this.datacenter)).append("\n");
        sb.append("    subdomain: ").append(this.toIndentedString(this.subdomain)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

