/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

@JsonPropertyOrder(value={"container_id", "created_at", "host", "image_digest", "image_name", "image_tags", "name", "started_at", "state", "tags"})
public class ContainerAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CONTAINER_ID = "container_id";
    private String containerId;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private String createdAt;
    public static final String JSON_PROPERTY_HOST = "host";
    private String host;
    public static final String JSON_PROPERTY_IMAGE_DIGEST = "image_digest";
    private JsonNullable<String> imageDigest = JsonNullable.undefined();
    public static final String JSON_PROPERTY_IMAGE_NAME = "image_name";
    private String imageName;
    public static final String JSON_PROPERTY_IMAGE_TAGS = "image_tags";
    private JsonNullable<List<String>> imageTags = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STARTED_AT = "started_at";
    private String startedAt;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    private Map<String, Object> additionalProperties;

    public ContainerAttributes containerId(String containerId) {
        this.containerId = containerId;
        return this;
    }

    @Nullable
    @JsonProperty(value="container_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public ContainerAttributes createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public ContainerAttributes host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public ContainerAttributes imageDigest(String imageDigest) {
        this.imageDigest = JsonNullable.of(imageDigest);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getImageDigest() {
        return this.imageDigest.orElse(null);
    }

    @JsonProperty(value="image_digest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getImageDigest_JsonNullable() {
        return this.imageDigest;
    }

    @JsonProperty(value="image_digest")
    public void setImageDigest_JsonNullable(JsonNullable<String> imageDigest) {
        this.imageDigest = imageDigest;
    }

    public void setImageDigest(String imageDigest) {
        this.imageDigest = JsonNullable.of(imageDigest);
    }

    public ContainerAttributes imageName(String imageName) {
        this.imageName = imageName;
        return this;
    }

    @Nullable
    @JsonProperty(value="image_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public ContainerAttributes imageTags(List<String> imageTags) {
        this.imageTags = JsonNullable.of(imageTags);
        return this;
    }

    public ContainerAttributes addImageTagsItem(String imageTagsItem) {
        if (this.imageTags == null || !this.imageTags.isPresent()) {
            this.imageTags = JsonNullable.of(new ArrayList());
        }
        try {
            this.imageTags.get().add(imageTagsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getImageTags() {
        return this.imageTags.orElse(null);
    }

    @JsonProperty(value="image_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getImageTags_JsonNullable() {
        return this.imageTags;
    }

    @JsonProperty(value="image_tags")
    public void setImageTags_JsonNullable(JsonNullable<List<String>> imageTags) {
        this.imageTags = imageTags;
    }

    public void setImageTags(List<String> imageTags) {
        this.imageTags = JsonNullable.of(imageTags);
    }

    public ContainerAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContainerAttributes startedAt(String startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="started_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(String startedAt) {
        this.startedAt = startedAt;
    }

    public ContainerAttributes state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ContainerAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ContainerAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonAnySetter
    public ContainerAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerAttributes containerAttributes = (ContainerAttributes)o;
        return Objects.equals(this.containerId, containerAttributes.containerId) && Objects.equals(this.createdAt, containerAttributes.createdAt) && Objects.equals(this.host, containerAttributes.host) && Objects.equals(this.imageDigest, containerAttributes.imageDigest) && Objects.equals(this.imageName, containerAttributes.imageName) && Objects.equals(this.imageTags, containerAttributes.imageTags) && Objects.equals(this.name, containerAttributes.name) && Objects.equals(this.startedAt, containerAttributes.startedAt) && Objects.equals(this.state, containerAttributes.state) && Objects.equals(this.tags, containerAttributes.tags) && Objects.equals(this.additionalProperties, containerAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.containerId, this.createdAt, this.host, this.imageDigest, this.imageName, this.imageTags, this.name, this.startedAt, this.state, this.tags, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerAttributes {\n");
        sb.append("    containerId: ").append(this.toIndentedString(this.containerId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    imageDigest: ").append(this.toIndentedString(this.imageDigest)).append("\n");
        sb.append("    imageName: ").append(this.toIndentedString(this.imageName)).append("\n");
        sb.append("    imageTags: ").append(this.toIndentedString(this.imageTags)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

