/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.FindingMuteReason;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"description", "expiration_date", "muted", "reason"})
public class BulkMuteFindingsRequestProperties {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_EXPIRATION_DATE = "expiration_date";
    private Long expirationDate;
    public static final String JSON_PROPERTY_MUTED = "muted";
    private Boolean muted;
    public static final String JSON_PROPERTY_REASON = "reason";
    private FindingMuteReason reason;

    public BulkMuteFindingsRequestProperties() {
    }

    @JsonCreator
    public BulkMuteFindingsRequestProperties(@JsonProperty(required=true, value="muted") Boolean muted, @JsonProperty(required=true, value="reason") FindingMuteReason reason) {
        this.muted = muted;
        this.reason = reason;
        this.unparsed |= !reason.isValid();
    }

    public BulkMuteFindingsRequestProperties description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BulkMuteFindingsRequestProperties expirationDate(Long expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="expiration_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Long expirationDate) {
        this.expirationDate = expirationDate;
    }

    public BulkMuteFindingsRequestProperties muted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    @JsonProperty(value="muted")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getMuted() {
        return this.muted;
    }

    public void setMuted(Boolean muted) {
        this.muted = muted;
    }

    public BulkMuteFindingsRequestProperties reason(FindingMuteReason reason) {
        this.reason = reason;
        this.unparsed |= !reason.isValid();
        return this;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FindingMuteReason getReason() {
        return this.reason;
    }

    public void setReason(FindingMuteReason reason) {
        if (!reason.isValid()) {
            this.unparsed = true;
        }
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkMuteFindingsRequestProperties bulkMuteFindingsRequestProperties = (BulkMuteFindingsRequestProperties)o;
        return Objects.equals(this.description, bulkMuteFindingsRequestProperties.description) && Objects.equals(this.expirationDate, bulkMuteFindingsRequestProperties.expirationDate) && Objects.equals(this.muted, bulkMuteFindingsRequestProperties.muted) && Objects.equals(this.reason, bulkMuteFindingsRequestProperties.reason);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.expirationDate, this.muted, this.reason);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkMuteFindingsRequestProperties {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    muted: ").append(this.toIndentedString(this.muted)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

