/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.ConfluentAccountCreateRequest;
import com.datadog.api.client.v2.model.ConfluentAccountResponse;
import com.datadog.api.client.v2.model.ConfluentAccountUpdateRequest;
import com.datadog.api.client.v2.model.ConfluentAccountsResponse;
import com.datadog.api.client.v2.model.ConfluentResourceRequest;
import com.datadog.api.client.v2.model.ConfluentResourceResponse;
import com.datadog.api.client.v2.model.ConfluentResourcesResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class ConfluentCloudApi {
    private ApiClient apiClient;

    public ConfluentCloudApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ConfluentCloudApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ConfluentAccountResponse createConfluentAccount(ConfluentAccountCreateRequest body) throws ApiException {
        return this.createConfluentAccountWithHttpInfo(body).getData();
    }

    public CompletableFuture<ConfluentAccountResponse> createConfluentAccountAsync(ConfluentAccountCreateRequest body) {
        return this.createConfluentAccountWithHttpInfoAsync(body).thenApply(response -> (ConfluentAccountResponse)response.getData());
    }

    public ApiResponse<ConfluentAccountResponse> createConfluentAccountWithHttpInfo(ConfluentAccountCreateRequest body) throws ApiException {
        ConfluentAccountCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createConfluentAccount");
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.createConfluentAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<ConfluentAccountResponse>> createConfluentAccountWithHttpInfoAsync(ConfluentAccountCreateRequest body) {
        Invocation.Builder builder;
        ConfluentAccountCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<ConfluentAccountResponse>> result = new CompletableFuture<ApiResponse<ConfluentAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createConfluentAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.createConfluentAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ConfluentAccountResponse>> result = new CompletableFuture<ApiResponse<ConfluentAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentAccountResponse>(){});
    }

    public ConfluentResourceResponse createConfluentResource(String accountId, ConfluentResourceRequest body) throws ApiException {
        return this.createConfluentResourceWithHttpInfo(accountId, body).getData();
    }

    public CompletableFuture<ConfluentResourceResponse> createConfluentResourceAsync(String accountId, ConfluentResourceRequest body) {
        return this.createConfluentResourceWithHttpInfoAsync(accountId, body).thenApply(response -> (ConfluentResourceResponse)response.getData());
    }

    public ApiResponse<ConfluentResourceResponse> createConfluentResourceWithHttpInfo(String accountId, ConfluentResourceRequest body) throws ApiException {
        ConfluentResourceRequest localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createConfluentResource");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createConfluentResource");
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}/resources".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.createConfluentResource", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentResourceResponse>(){});
    }

    public CompletableFuture<ApiResponse<ConfluentResourceResponse>> createConfluentResourceWithHttpInfoAsync(String accountId, ConfluentResourceRequest body) {
        Invocation.Builder builder;
        ConfluentResourceRequest localVarPostBody = body;
        if (accountId == null) {
            CompletableFuture<ApiResponse<ConfluentResourceResponse>> result = new CompletableFuture<ApiResponse<ConfluentResourceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling createConfluentResource"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<ConfluentResourceResponse>> result = new CompletableFuture<ApiResponse<ConfluentResourceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createConfluentResource"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}/resources".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.createConfluentResource", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ConfluentResourceResponse>> result = new CompletableFuture<ApiResponse<ConfluentResourceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentResourceResponse>(){});
    }

    public void deleteConfluentAccount(String accountId) throws ApiException {
        this.deleteConfluentAccountWithHttpInfo(accountId);
    }

    public CompletableFuture<Void> deleteConfluentAccountAsync(String accountId) {
        return this.deleteConfluentAccountWithHttpInfoAsync(accountId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteConfluentAccountWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteConfluentAccount");
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.deleteConfluentAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteConfluentAccountWithHttpInfoAsync(String accountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling deleteConfluentAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.deleteConfluentAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteConfluentResource(String accountId, String resourceId) throws ApiException {
        this.deleteConfluentResourceWithHttpInfo(accountId, resourceId);
    }

    public CompletableFuture<Void> deleteConfluentResourceAsync(String accountId, String resourceId) {
        return this.deleteConfluentResourceWithHttpInfoAsync(accountId, resourceId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteConfluentResourceWithHttpInfo(String accountId, String resourceId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteConfluentResource");
        }
        if (resourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceId' when calling deleteConfluentResource");
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}/resources/{resource_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{resource_id\\}", this.apiClient.escapeString(resourceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.deleteConfluentResource", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteConfluentResourceWithHttpInfoAsync(String accountId, String resourceId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling deleteConfluentResource"));
            return result;
        }
        if (resourceId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'resourceId' when calling deleteConfluentResource"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}/resources/{resource_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{resource_id\\}", this.apiClient.escapeString(resourceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.deleteConfluentResource", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public ConfluentAccountResponse getConfluentAccount(String accountId) throws ApiException {
        return this.getConfluentAccountWithHttpInfo(accountId).getData();
    }

    public CompletableFuture<ConfluentAccountResponse> getConfluentAccountAsync(String accountId) {
        return this.getConfluentAccountWithHttpInfoAsync(accountId).thenApply(response -> (ConfluentAccountResponse)response.getData());
    }

    public ApiResponse<ConfluentAccountResponse> getConfluentAccountWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getConfluentAccount");
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.getConfluentAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<ConfluentAccountResponse>> getConfluentAccountWithHttpInfoAsync(String accountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<ConfluentAccountResponse>> result = new CompletableFuture<ApiResponse<ConfluentAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling getConfluentAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.getConfluentAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ConfluentAccountResponse>> result = new CompletableFuture<ApiResponse<ConfluentAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentAccountResponse>(){});
    }

    public ConfluentResourceResponse getConfluentResource(String accountId, String resourceId) throws ApiException {
        return this.getConfluentResourceWithHttpInfo(accountId, resourceId).getData();
    }

    public CompletableFuture<ConfluentResourceResponse> getConfluentResourceAsync(String accountId, String resourceId) {
        return this.getConfluentResourceWithHttpInfoAsync(accountId, resourceId).thenApply(response -> (ConfluentResourceResponse)response.getData());
    }

    public ApiResponse<ConfluentResourceResponse> getConfluentResourceWithHttpInfo(String accountId, String resourceId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getConfluentResource");
        }
        if (resourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceId' when calling getConfluentResource");
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}/resources/{resource_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{resource_id\\}", this.apiClient.escapeString(resourceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.getConfluentResource", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentResourceResponse>(){});
    }

    public CompletableFuture<ApiResponse<ConfluentResourceResponse>> getConfluentResourceWithHttpInfoAsync(String accountId, String resourceId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<ConfluentResourceResponse>> result = new CompletableFuture<ApiResponse<ConfluentResourceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling getConfluentResource"));
            return result;
        }
        if (resourceId == null) {
            CompletableFuture<ApiResponse<ConfluentResourceResponse>> result = new CompletableFuture<ApiResponse<ConfluentResourceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'resourceId' when calling getConfluentResource"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}/resources/{resource_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{resource_id\\}", this.apiClient.escapeString(resourceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.getConfluentResource", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ConfluentResourceResponse>> result = new CompletableFuture<ApiResponse<ConfluentResourceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentResourceResponse>(){});
    }

    public ConfluentAccountsResponse listConfluentAccount() throws ApiException {
        return this.listConfluentAccountWithHttpInfo().getData();
    }

    public CompletableFuture<ConfluentAccountsResponse> listConfluentAccountAsync() {
        return this.listConfluentAccountWithHttpInfoAsync().thenApply(response -> (ConfluentAccountsResponse)response.getData());
    }

    public ApiResponse<ConfluentAccountsResponse> listConfluentAccountWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.listConfluentAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentAccountsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ConfluentAccountsResponse>> listConfluentAccountWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.listConfluentAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ConfluentAccountsResponse>> result = new CompletableFuture<ApiResponse<ConfluentAccountsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentAccountsResponse>(){});
    }

    public ConfluentResourcesResponse listConfluentResource(String accountId) throws ApiException {
        return this.listConfluentResourceWithHttpInfo(accountId).getData();
    }

    public CompletableFuture<ConfluentResourcesResponse> listConfluentResourceAsync(String accountId) {
        return this.listConfluentResourceWithHttpInfoAsync(accountId).thenApply(response -> (ConfluentResourcesResponse)response.getData());
    }

    public ApiResponse<ConfluentResourcesResponse> listConfluentResourceWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listConfluentResource");
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}/resources".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.listConfluentResource", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentResourcesResponse>(){});
    }

    public CompletableFuture<ApiResponse<ConfluentResourcesResponse>> listConfluentResourceWithHttpInfoAsync(String accountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<ConfluentResourcesResponse>> result = new CompletableFuture<ApiResponse<ConfluentResourcesResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling listConfluentResource"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}/resources".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.listConfluentResource", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ConfluentResourcesResponse>> result = new CompletableFuture<ApiResponse<ConfluentResourcesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentResourcesResponse>(){});
    }

    public ConfluentAccountResponse updateConfluentAccount(String accountId, ConfluentAccountUpdateRequest body) throws ApiException {
        return this.updateConfluentAccountWithHttpInfo(accountId, body).getData();
    }

    public CompletableFuture<ConfluentAccountResponse> updateConfluentAccountAsync(String accountId, ConfluentAccountUpdateRequest body) {
        return this.updateConfluentAccountWithHttpInfoAsync(accountId, body).thenApply(response -> (ConfluentAccountResponse)response.getData());
    }

    public ApiResponse<ConfluentAccountResponse> updateConfluentAccountWithHttpInfo(String accountId, ConfluentAccountUpdateRequest body) throws ApiException {
        ConfluentAccountUpdateRequest localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateConfluentAccount");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateConfluentAccount");
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.updateConfluentAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<ConfluentAccountResponse>> updateConfluentAccountWithHttpInfoAsync(String accountId, ConfluentAccountUpdateRequest body) {
        Invocation.Builder builder;
        ConfluentAccountUpdateRequest localVarPostBody = body;
        if (accountId == null) {
            CompletableFuture<ApiResponse<ConfluentAccountResponse>> result = new CompletableFuture<ApiResponse<ConfluentAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling updateConfluentAccount"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<ConfluentAccountResponse>> result = new CompletableFuture<ApiResponse<ConfluentAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateConfluentAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.updateConfluentAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ConfluentAccountResponse>> result = new CompletableFuture<ApiResponse<ConfluentAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentAccountResponse>(){});
    }

    public ConfluentResourceResponse updateConfluentResource(String accountId, String resourceId, ConfluentResourceRequest body) throws ApiException {
        return this.updateConfluentResourceWithHttpInfo(accountId, resourceId, body).getData();
    }

    public CompletableFuture<ConfluentResourceResponse> updateConfluentResourceAsync(String accountId, String resourceId, ConfluentResourceRequest body) {
        return this.updateConfluentResourceWithHttpInfoAsync(accountId, resourceId, body).thenApply(response -> (ConfluentResourceResponse)response.getData());
    }

    public ApiResponse<ConfluentResourceResponse> updateConfluentResourceWithHttpInfo(String accountId, String resourceId, ConfluentResourceRequest body) throws ApiException {
        ConfluentResourceRequest localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateConfluentResource");
        }
        if (resourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceId' when calling updateConfluentResource");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateConfluentResource");
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}/resources/{resource_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{resource_id\\}", this.apiClient.escapeString(resourceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.updateConfluentResource", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentResourceResponse>(){});
    }

    public CompletableFuture<ApiResponse<ConfluentResourceResponse>> updateConfluentResourceWithHttpInfoAsync(String accountId, String resourceId, ConfluentResourceRequest body) {
        Invocation.Builder builder;
        ConfluentResourceRequest localVarPostBody = body;
        if (accountId == null) {
            CompletableFuture<ApiResponse<ConfluentResourceResponse>> result = new CompletableFuture<ApiResponse<ConfluentResourceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling updateConfluentResource"));
            return result;
        }
        if (resourceId == null) {
            CompletableFuture<ApiResponse<ConfluentResourceResponse>> result = new CompletableFuture<ApiResponse<ConfluentResourceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'resourceId' when calling updateConfluentResource"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<ConfluentResourceResponse>> result = new CompletableFuture<ApiResponse<ConfluentResourceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateConfluentResource"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/confluent-cloud/accounts/{account_id}/resources/{resource_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{resource_id\\}", this.apiClient.escapeString(resourceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ConfluentCloudApi.updateConfluentResource", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ConfluentResourceResponse>> result = new CompletableFuture<ApiResponse<ConfluentResourceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ConfluentResourceResponse>(){});
    }
}

