/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.SingleAggregatedConnectionResponseArray;
import com.datadog.api.client.v2.model.SingleAggregatedDnsResponseArray;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class CloudNetworkMonitoringApi {
    private ApiClient apiClient;

    public CloudNetworkMonitoringApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public CloudNetworkMonitoringApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SingleAggregatedConnectionResponseArray getAggregatedConnections() throws ApiException {
        return this.getAggregatedConnectionsWithHttpInfo(new GetAggregatedConnectionsOptionalParameters()).getData();
    }

    public CompletableFuture<SingleAggregatedConnectionResponseArray> getAggregatedConnectionsAsync() {
        return this.getAggregatedConnectionsWithHttpInfoAsync(new GetAggregatedConnectionsOptionalParameters()).thenApply(response -> (SingleAggregatedConnectionResponseArray)response.getData());
    }

    public SingleAggregatedConnectionResponseArray getAggregatedConnections(GetAggregatedConnectionsOptionalParameters parameters) throws ApiException {
        return this.getAggregatedConnectionsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SingleAggregatedConnectionResponseArray> getAggregatedConnectionsAsync(GetAggregatedConnectionsOptionalParameters parameters) {
        return this.getAggregatedConnectionsWithHttpInfoAsync(parameters).thenApply(response -> (SingleAggregatedConnectionResponseArray)response.getData());
    }

    public ApiResponse<SingleAggregatedConnectionResponseArray> getAggregatedConnectionsWithHttpInfo(GetAggregatedConnectionsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long from = parameters.from;
        Long to = parameters.to;
        String groupBy = parameters.groupBy;
        String tags = parameters.tags;
        Integer limit = parameters.limit;
        String localVarPath = "/api/v2/network/connections/aggregate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to", to));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_by", groupBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudNetworkMonitoringApi.getAggregatedConnections", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SingleAggregatedConnectionResponseArray>(){});
    }

    public CompletableFuture<ApiResponse<SingleAggregatedConnectionResponseArray>> getAggregatedConnectionsWithHttpInfoAsync(GetAggregatedConnectionsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long from = parameters.from;
        Long to = parameters.to;
        String groupBy = parameters.groupBy;
        String tags = parameters.tags;
        Integer limit = parameters.limit;
        String localVarPath = "/api/v2/network/connections/aggregate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to", to));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_by", groupBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        try {
            builder = this.apiClient.createBuilder("v2.CloudNetworkMonitoringApi.getAggregatedConnections", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SingleAggregatedConnectionResponseArray>> result = new CompletableFuture<ApiResponse<SingleAggregatedConnectionResponseArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SingleAggregatedConnectionResponseArray>(){});
    }

    public SingleAggregatedDnsResponseArray getAggregatedDns() throws ApiException {
        return this.getAggregatedDnsWithHttpInfo(new GetAggregatedDnsOptionalParameters()).getData();
    }

    public CompletableFuture<SingleAggregatedDnsResponseArray> getAggregatedDnsAsync() {
        return this.getAggregatedDnsWithHttpInfoAsync(new GetAggregatedDnsOptionalParameters()).thenApply(response -> (SingleAggregatedDnsResponseArray)response.getData());
    }

    public SingleAggregatedDnsResponseArray getAggregatedDns(GetAggregatedDnsOptionalParameters parameters) throws ApiException {
        return this.getAggregatedDnsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SingleAggregatedDnsResponseArray> getAggregatedDnsAsync(GetAggregatedDnsOptionalParameters parameters) {
        return this.getAggregatedDnsWithHttpInfoAsync(parameters).thenApply(response -> (SingleAggregatedDnsResponseArray)response.getData());
    }

    public ApiResponse<SingleAggregatedDnsResponseArray> getAggregatedDnsWithHttpInfo(GetAggregatedDnsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long from = parameters.from;
        Long to = parameters.to;
        String groupBy = parameters.groupBy;
        String tags = parameters.tags;
        Integer limit = parameters.limit;
        String localVarPath = "/api/v2/network/dns/aggregate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to", to));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_by", groupBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CloudNetworkMonitoringApi.getAggregatedDns", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SingleAggregatedDnsResponseArray>(){});
    }

    public CompletableFuture<ApiResponse<SingleAggregatedDnsResponseArray>> getAggregatedDnsWithHttpInfoAsync(GetAggregatedDnsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long from = parameters.from;
        Long to = parameters.to;
        String groupBy = parameters.groupBy;
        String tags = parameters.tags;
        Integer limit = parameters.limit;
        String localVarPath = "/api/v2/network/dns/aggregate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to", to));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_by", groupBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        try {
            builder = this.apiClient.createBuilder("v2.CloudNetworkMonitoringApi.getAggregatedDns", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SingleAggregatedDnsResponseArray>> result = new CompletableFuture<ApiResponse<SingleAggregatedDnsResponseArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SingleAggregatedDnsResponseArray>(){});
    }

    public static class GetAggregatedDnsOptionalParameters {
        private Long from;
        private Long to;
        private String groupBy;
        private String tags;
        private Integer limit;

        public GetAggregatedDnsOptionalParameters from(Long from) {
            this.from = from;
            return this;
        }

        public GetAggregatedDnsOptionalParameters to(Long to) {
            this.to = to;
            return this;
        }

        public GetAggregatedDnsOptionalParameters groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public GetAggregatedDnsOptionalParameters tags(String tags) {
            this.tags = tags;
            return this;
        }

        public GetAggregatedDnsOptionalParameters limit(Integer limit) {
            this.limit = limit;
            return this;
        }
    }

    public static class GetAggregatedConnectionsOptionalParameters {
        private Long from;
        private Long to;
        private String groupBy;
        private String tags;
        private Integer limit;

        public GetAggregatedConnectionsOptionalParameters from(Long from) {
            this.from = from;
            return this;
        }

        public GetAggregatedConnectionsOptionalParameters to(Long to) {
            this.to = to;
            return this;
        }

        public GetAggregatedConnectionsOptionalParameters groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public GetAggregatedConnectionsOptionalParameters tags(String tags) {
            this.tags = tags;
            return this;
        }

        public GetAggregatedConnectionsOptionalParameters limit(Integer limit) {
            this.limit = limit;
            return this;
        }
    }
}

