/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.BulkPutAppsDatastoreItemsRequest;
import com.datadog.api.client.v2.model.CreateAppsDatastoreRequest;
import com.datadog.api.client.v2.model.CreateAppsDatastoreResponse;
import com.datadog.api.client.v2.model.Datastore;
import com.datadog.api.client.v2.model.DatastoreArray;
import com.datadog.api.client.v2.model.DeleteAppsDatastoreItemRequest;
import com.datadog.api.client.v2.model.DeleteAppsDatastoreItemResponse;
import com.datadog.api.client.v2.model.ItemApiPayload;
import com.datadog.api.client.v2.model.ItemApiPayloadArray;
import com.datadog.api.client.v2.model.PutAppsDatastoreItemResponseArray;
import com.datadog.api.client.v2.model.UpdateAppsDatastoreItemRequest;
import com.datadog.api.client.v2.model.UpdateAppsDatastoreRequest;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class ActionsDatastoresApi {
    private ApiClient apiClient;

    public ActionsDatastoresApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ActionsDatastoresApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public PutAppsDatastoreItemResponseArray bulkWriteDatastoreItems(String datastoreId, BulkPutAppsDatastoreItemsRequest body) throws ApiException {
        return this.bulkWriteDatastoreItemsWithHttpInfo(datastoreId, body).getData();
    }

    public CompletableFuture<PutAppsDatastoreItemResponseArray> bulkWriteDatastoreItemsAsync(String datastoreId, BulkPutAppsDatastoreItemsRequest body) {
        return this.bulkWriteDatastoreItemsWithHttpInfoAsync(datastoreId, body).thenApply(response -> (PutAppsDatastoreItemResponseArray)response.getData());
    }

    public ApiResponse<PutAppsDatastoreItemResponseArray> bulkWriteDatastoreItemsWithHttpInfo(String datastoreId, BulkPutAppsDatastoreItemsRequest body) throws ApiException {
        BulkPutAppsDatastoreItemsRequest localVarPostBody = body;
        if (datastoreId == null) {
            throw new ApiException(400, "Missing the required parameter 'datastoreId' when calling bulkWriteDatastoreItems");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling bulkWriteDatastoreItems");
        }
        String localVarPath = "/api/v2/actions-datastores/{datastore_id}/items/bulk".replaceAll("\\{datastore_id\\}", this.apiClient.escapeString(datastoreId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.bulkWriteDatastoreItems", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PutAppsDatastoreItemResponseArray>(){});
    }

    public CompletableFuture<ApiResponse<PutAppsDatastoreItemResponseArray>> bulkWriteDatastoreItemsWithHttpInfoAsync(String datastoreId, BulkPutAppsDatastoreItemsRequest body) {
        Invocation.Builder builder;
        BulkPutAppsDatastoreItemsRequest localVarPostBody = body;
        if (datastoreId == null) {
            CompletableFuture<ApiResponse<PutAppsDatastoreItemResponseArray>> result = new CompletableFuture<ApiResponse<PutAppsDatastoreItemResponseArray>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'datastoreId' when calling bulkWriteDatastoreItems"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<PutAppsDatastoreItemResponseArray>> result = new CompletableFuture<ApiResponse<PutAppsDatastoreItemResponseArray>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling bulkWriteDatastoreItems"));
            return result;
        }
        String localVarPath = "/api/v2/actions-datastores/{datastore_id}/items/bulk".replaceAll("\\{datastore_id\\}", this.apiClient.escapeString(datastoreId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.bulkWriteDatastoreItems", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<PutAppsDatastoreItemResponseArray>> result = new CompletableFuture<ApiResponse<PutAppsDatastoreItemResponseArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PutAppsDatastoreItemResponseArray>(){});
    }

    public CreateAppsDatastoreResponse createDatastore(CreateAppsDatastoreRequest body) throws ApiException {
        return this.createDatastoreWithHttpInfo(body).getData();
    }

    public CompletableFuture<CreateAppsDatastoreResponse> createDatastoreAsync(CreateAppsDatastoreRequest body) {
        return this.createDatastoreWithHttpInfoAsync(body).thenApply(response -> (CreateAppsDatastoreResponse)response.getData());
    }

    public ApiResponse<CreateAppsDatastoreResponse> createDatastoreWithHttpInfo(CreateAppsDatastoreRequest body) throws ApiException {
        CreateAppsDatastoreRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDatastore");
        }
        String localVarPath = "/api/v2/actions-datastores";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.createDatastore", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateAppsDatastoreResponse>(){});
    }

    public CompletableFuture<ApiResponse<CreateAppsDatastoreResponse>> createDatastoreWithHttpInfoAsync(CreateAppsDatastoreRequest body) {
        Invocation.Builder builder;
        CreateAppsDatastoreRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CreateAppsDatastoreResponse>> result = new CompletableFuture<ApiResponse<CreateAppsDatastoreResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDatastore"));
            return result;
        }
        String localVarPath = "/api/v2/actions-datastores";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.createDatastore", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CreateAppsDatastoreResponse>> result = new CompletableFuture<ApiResponse<CreateAppsDatastoreResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateAppsDatastoreResponse>(){});
    }

    public void deleteDatastore(String datastoreId) throws ApiException {
        this.deleteDatastoreWithHttpInfo(datastoreId);
    }

    public CompletableFuture<Void> deleteDatastoreAsync(String datastoreId) {
        return this.deleteDatastoreWithHttpInfoAsync(datastoreId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteDatastoreWithHttpInfo(String datastoreId) throws ApiException {
        Object localVarPostBody = null;
        if (datastoreId == null) {
            throw new ApiException(400, "Missing the required parameter 'datastoreId' when calling deleteDatastore");
        }
        String localVarPath = "/api/v2/actions-datastores/{datastore_id}".replaceAll("\\{datastore_id\\}", this.apiClient.escapeString(datastoreId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.deleteDatastore", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteDatastoreWithHttpInfoAsync(String datastoreId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (datastoreId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'datastoreId' when calling deleteDatastore"));
            return result;
        }
        String localVarPath = "/api/v2/actions-datastores/{datastore_id}".replaceAll("\\{datastore_id\\}", this.apiClient.escapeString(datastoreId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.deleteDatastore", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public DeleteAppsDatastoreItemResponse deleteDatastoreItem(String datastoreId, DeleteAppsDatastoreItemRequest body) throws ApiException {
        return this.deleteDatastoreItemWithHttpInfo(datastoreId, body).getData();
    }

    public CompletableFuture<DeleteAppsDatastoreItemResponse> deleteDatastoreItemAsync(String datastoreId, DeleteAppsDatastoreItemRequest body) {
        return this.deleteDatastoreItemWithHttpInfoAsync(datastoreId, body).thenApply(response -> (DeleteAppsDatastoreItemResponse)response.getData());
    }

    public ApiResponse<DeleteAppsDatastoreItemResponse> deleteDatastoreItemWithHttpInfo(String datastoreId, DeleteAppsDatastoreItemRequest body) throws ApiException {
        DeleteAppsDatastoreItemRequest localVarPostBody = body;
        if (datastoreId == null) {
            throw new ApiException(400, "Missing the required parameter 'datastoreId' when calling deleteDatastoreItem");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteDatastoreItem");
        }
        String localVarPath = "/api/v2/actions-datastores/{datastore_id}/items".replaceAll("\\{datastore_id\\}", this.apiClient.escapeString(datastoreId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.deleteDatastoreItem", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeleteAppsDatastoreItemResponse>(){});
    }

    public CompletableFuture<ApiResponse<DeleteAppsDatastoreItemResponse>> deleteDatastoreItemWithHttpInfoAsync(String datastoreId, DeleteAppsDatastoreItemRequest body) {
        Invocation.Builder builder;
        DeleteAppsDatastoreItemRequest localVarPostBody = body;
        if (datastoreId == null) {
            CompletableFuture<ApiResponse<DeleteAppsDatastoreItemResponse>> result = new CompletableFuture<ApiResponse<DeleteAppsDatastoreItemResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'datastoreId' when calling deleteDatastoreItem"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<DeleteAppsDatastoreItemResponse>> result = new CompletableFuture<ApiResponse<DeleteAppsDatastoreItemResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deleteDatastoreItem"));
            return result;
        }
        String localVarPath = "/api/v2/actions-datastores/{datastore_id}/items".replaceAll("\\{datastore_id\\}", this.apiClient.escapeString(datastoreId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.deleteDatastoreItem", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DeleteAppsDatastoreItemResponse>> result = new CompletableFuture<ApiResponse<DeleteAppsDatastoreItemResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeleteAppsDatastoreItemResponse>(){});
    }

    public Datastore getDatastore(String datastoreId) throws ApiException {
        return this.getDatastoreWithHttpInfo(datastoreId).getData();
    }

    public CompletableFuture<Datastore> getDatastoreAsync(String datastoreId) {
        return this.getDatastoreWithHttpInfoAsync(datastoreId).thenApply(response -> (Datastore)response.getData());
    }

    public ApiResponse<Datastore> getDatastoreWithHttpInfo(String datastoreId) throws ApiException {
        Object localVarPostBody = null;
        if (datastoreId == null) {
            throw new ApiException(400, "Missing the required parameter 'datastoreId' when calling getDatastore");
        }
        String localVarPath = "/api/v2/actions-datastores/{datastore_id}".replaceAll("\\{datastore_id\\}", this.apiClient.escapeString(datastoreId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.getDatastore", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Datastore>(){});
    }

    public CompletableFuture<ApiResponse<Datastore>> getDatastoreWithHttpInfoAsync(String datastoreId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (datastoreId == null) {
            CompletableFuture<ApiResponse<Datastore>> result = new CompletableFuture<ApiResponse<Datastore>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'datastoreId' when calling getDatastore"));
            return result;
        }
        String localVarPath = "/api/v2/actions-datastores/{datastore_id}".replaceAll("\\{datastore_id\\}", this.apiClient.escapeString(datastoreId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.getDatastore", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Datastore>> result = new CompletableFuture<ApiResponse<Datastore>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Datastore>(){});
    }

    public ItemApiPayloadArray listDatastoreItems(String datastoreId) throws ApiException {
        return this.listDatastoreItemsWithHttpInfo(datastoreId, new ListDatastoreItemsOptionalParameters()).getData();
    }

    public CompletableFuture<ItemApiPayloadArray> listDatastoreItemsAsync(String datastoreId) {
        return this.listDatastoreItemsWithHttpInfoAsync(datastoreId, new ListDatastoreItemsOptionalParameters()).thenApply(response -> (ItemApiPayloadArray)response.getData());
    }

    public ItemApiPayloadArray listDatastoreItems(String datastoreId, ListDatastoreItemsOptionalParameters parameters) throws ApiException {
        return this.listDatastoreItemsWithHttpInfo(datastoreId, parameters).getData();
    }

    public CompletableFuture<ItemApiPayloadArray> listDatastoreItemsAsync(String datastoreId, ListDatastoreItemsOptionalParameters parameters) {
        return this.listDatastoreItemsWithHttpInfoAsync(datastoreId, parameters).thenApply(response -> (ItemApiPayloadArray)response.getData());
    }

    public ApiResponse<ItemApiPayloadArray> listDatastoreItemsWithHttpInfo(String datastoreId, ListDatastoreItemsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (datastoreId == null) {
            throw new ApiException(400, "Missing the required parameter 'datastoreId' when calling listDatastoreItems");
        }
        String filter = parameters.filter;
        String itemKey = parameters.itemKey;
        Long pageLimit = parameters.pageLimit;
        Long pageOffset = parameters.pageOffset;
        String sort = parameters.sort;
        String localVarPath = "/api/v2/actions-datastores/{datastore_id}/items".replaceAll("\\{datastore_id\\}", this.apiClient.escapeString(datastoreId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "item_key", itemKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.listDatastoreItems", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ItemApiPayloadArray>(){});
    }

    public CompletableFuture<ApiResponse<ItemApiPayloadArray>> listDatastoreItemsWithHttpInfoAsync(String datastoreId, ListDatastoreItemsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (datastoreId == null) {
            CompletableFuture<ApiResponse<ItemApiPayloadArray>> result = new CompletableFuture<ApiResponse<ItemApiPayloadArray>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'datastoreId' when calling listDatastoreItems"));
            return result;
        }
        String filter = parameters.filter;
        String itemKey = parameters.itemKey;
        Long pageLimit = parameters.pageLimit;
        Long pageOffset = parameters.pageOffset;
        String sort = parameters.sort;
        String localVarPath = "/api/v2/actions-datastores/{datastore_id}/items".replaceAll("\\{datastore_id\\}", this.apiClient.escapeString(datastoreId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "item_key", itemKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        try {
            builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.listDatastoreItems", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ItemApiPayloadArray>> result = new CompletableFuture<ApiResponse<ItemApiPayloadArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ItemApiPayloadArray>(){});
    }

    public DatastoreArray listDatastores() throws ApiException {
        return this.listDatastoresWithHttpInfo().getData();
    }

    public CompletableFuture<DatastoreArray> listDatastoresAsync() {
        return this.listDatastoresWithHttpInfoAsync().thenApply(response -> (DatastoreArray)response.getData());
    }

    public ApiResponse<DatastoreArray> listDatastoresWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/actions-datastores";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.listDatastores", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DatastoreArray>(){});
    }

    public CompletableFuture<ApiResponse<DatastoreArray>> listDatastoresWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/actions-datastores";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.listDatastores", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DatastoreArray>> result = new CompletableFuture<ApiResponse<DatastoreArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DatastoreArray>(){});
    }

    public Datastore updateDatastore(String datastoreId, UpdateAppsDatastoreRequest body) throws ApiException {
        return this.updateDatastoreWithHttpInfo(datastoreId, body).getData();
    }

    public CompletableFuture<Datastore> updateDatastoreAsync(String datastoreId, UpdateAppsDatastoreRequest body) {
        return this.updateDatastoreWithHttpInfoAsync(datastoreId, body).thenApply(response -> (Datastore)response.getData());
    }

    public ApiResponse<Datastore> updateDatastoreWithHttpInfo(String datastoreId, UpdateAppsDatastoreRequest body) throws ApiException {
        UpdateAppsDatastoreRequest localVarPostBody = body;
        if (datastoreId == null) {
            throw new ApiException(400, "Missing the required parameter 'datastoreId' when calling updateDatastore");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDatastore");
        }
        String localVarPath = "/api/v2/actions-datastores/{datastore_id}".replaceAll("\\{datastore_id\\}", this.apiClient.escapeString(datastoreId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.updateDatastore", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Datastore>(){});
    }

    public CompletableFuture<ApiResponse<Datastore>> updateDatastoreWithHttpInfoAsync(String datastoreId, UpdateAppsDatastoreRequest body) {
        Invocation.Builder builder;
        UpdateAppsDatastoreRequest localVarPostBody = body;
        if (datastoreId == null) {
            CompletableFuture<ApiResponse<Datastore>> result = new CompletableFuture<ApiResponse<Datastore>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'datastoreId' when calling updateDatastore"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Datastore>> result = new CompletableFuture<ApiResponse<Datastore>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateDatastore"));
            return result;
        }
        String localVarPath = "/api/v2/actions-datastores/{datastore_id}".replaceAll("\\{datastore_id\\}", this.apiClient.escapeString(datastoreId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.updateDatastore", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Datastore>> result = new CompletableFuture<ApiResponse<Datastore>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Datastore>(){});
    }

    public ItemApiPayload updateDatastoreItem(String datastoreId, UpdateAppsDatastoreItemRequest body) throws ApiException {
        return this.updateDatastoreItemWithHttpInfo(datastoreId, body).getData();
    }

    public CompletableFuture<ItemApiPayload> updateDatastoreItemAsync(String datastoreId, UpdateAppsDatastoreItemRequest body) {
        return this.updateDatastoreItemWithHttpInfoAsync(datastoreId, body).thenApply(response -> (ItemApiPayload)response.getData());
    }

    public ApiResponse<ItemApiPayload> updateDatastoreItemWithHttpInfo(String datastoreId, UpdateAppsDatastoreItemRequest body) throws ApiException {
        UpdateAppsDatastoreItemRequest localVarPostBody = body;
        if (datastoreId == null) {
            throw new ApiException(400, "Missing the required parameter 'datastoreId' when calling updateDatastoreItem");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDatastoreItem");
        }
        String localVarPath = "/api/v2/actions-datastores/{datastore_id}/items".replaceAll("\\{datastore_id\\}", this.apiClient.escapeString(datastoreId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.updateDatastoreItem", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ItemApiPayload>(){});
    }

    public CompletableFuture<ApiResponse<ItemApiPayload>> updateDatastoreItemWithHttpInfoAsync(String datastoreId, UpdateAppsDatastoreItemRequest body) {
        Invocation.Builder builder;
        UpdateAppsDatastoreItemRequest localVarPostBody = body;
        if (datastoreId == null) {
            CompletableFuture<ApiResponse<ItemApiPayload>> result = new CompletableFuture<ApiResponse<ItemApiPayload>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'datastoreId' when calling updateDatastoreItem"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<ItemApiPayload>> result = new CompletableFuture<ApiResponse<ItemApiPayload>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateDatastoreItem"));
            return result;
        }
        String localVarPath = "/api/v2/actions-datastores/{datastore_id}/items".replaceAll("\\{datastore_id\\}", this.apiClient.escapeString(datastoreId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ActionsDatastoresApi.updateDatastoreItem", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ItemApiPayload>> result = new CompletableFuture<ApiResponse<ItemApiPayload>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ItemApiPayload>(){});
    }

    public static class ListDatastoreItemsOptionalParameters {
        private String filter;
        private String itemKey;
        private Long pageLimit;
        private Long pageOffset;
        private String sort;

        public ListDatastoreItemsOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }

        public ListDatastoreItemsOptionalParameters itemKey(String itemKey) {
            this.itemKey = itemKey;
            return this;
        }

        public ListDatastoreItemsOptionalParameters pageLimit(Long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public ListDatastoreItemsOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public ListDatastoreItemsOptionalParameters sort(String sort) {
            this.sort = sort;
            return this;
        }
    }
}

