/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.DistributionWidgetDefinition;
import com.datadog.api.client.v1.model.NotebookCellTime;
import com.datadog.api.client.v1.model.NotebookGraphSize;
import com.datadog.api.client.v1.model.NotebookSplitBy;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"definition", "graph_size", "split_by", "time"})
public class NotebookDistributionCellAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DEFINITION = "definition";
    private DistributionWidgetDefinition definition;
    public static final String JSON_PROPERTY_GRAPH_SIZE = "graph_size";
    private NotebookGraphSize graphSize;
    public static final String JSON_PROPERTY_SPLIT_BY = "split_by";
    private NotebookSplitBy splitBy;
    public static final String JSON_PROPERTY_TIME = "time";
    private JsonNullable<NotebookCellTime> time = JsonNullable.undefined();
    private Map<String, Object> additionalProperties;

    public NotebookDistributionCellAttributes() {
    }

    @JsonCreator
    public NotebookDistributionCellAttributes(@JsonProperty(required=true, value="definition") DistributionWidgetDefinition definition) {
        this.definition = definition;
        this.unparsed |= definition.unparsed;
    }

    public NotebookDistributionCellAttributes definition(DistributionWidgetDefinition definition) {
        this.definition = definition;
        this.unparsed |= definition.unparsed;
        return this;
    }

    @JsonProperty(value="definition")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DistributionWidgetDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(DistributionWidgetDefinition definition) {
        this.definition = definition;
    }

    public NotebookDistributionCellAttributes graphSize(NotebookGraphSize graphSize) {
        this.graphSize = graphSize;
        this.unparsed |= !graphSize.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="graph_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotebookGraphSize getGraphSize() {
        return this.graphSize;
    }

    public void setGraphSize(NotebookGraphSize graphSize) {
        if (!graphSize.isValid()) {
            this.unparsed = true;
        }
        this.graphSize = graphSize;
    }

    public NotebookDistributionCellAttributes splitBy(NotebookSplitBy splitBy) {
        this.splitBy = splitBy;
        this.unparsed |= splitBy.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="split_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotebookSplitBy getSplitBy() {
        return this.splitBy;
    }

    public void setSplitBy(NotebookSplitBy splitBy) {
        this.splitBy = splitBy;
    }

    public NotebookDistributionCellAttributes time(NotebookCellTime time) {
        this.time = JsonNullable.of(time);
        return this;
    }

    @Nullable
    @JsonIgnore
    public NotebookCellTime getTime() {
        return this.time.orElse(null);
    }

    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<NotebookCellTime> getTime_JsonNullable() {
        return this.time;
    }

    @JsonProperty(value="time")
    public void setTime_JsonNullable(JsonNullable<NotebookCellTime> time) {
        this.time = time;
    }

    public void setTime(NotebookCellTime time) {
        this.time = JsonNullable.of(time);
    }

    @JsonAnySetter
    public NotebookDistributionCellAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotebookDistributionCellAttributes notebookDistributionCellAttributes = (NotebookDistributionCellAttributes)o;
        return Objects.equals(this.definition, notebookDistributionCellAttributes.definition) && Objects.equals(this.graphSize, notebookDistributionCellAttributes.graphSize) && Objects.equals(this.splitBy, notebookDistributionCellAttributes.splitBy) && Objects.equals(this.time, notebookDistributionCellAttributes.time) && Objects.equals(this.additionalProperties, notebookDistributionCellAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.definition, this.graphSize, this.splitBy, this.time, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotebookDistributionCellAttributes {\n");
        sb.append("    definition: ").append(this.toIndentedString(this.definition)).append("\n");
        sb.append("    graphSize: ").append(this.toIndentedString(this.graphSize)).append("\n");
        sb.append("    splitBy: ").append(this.toIndentedString(this.splitBy)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

