/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.TopologyQueryDataSource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"data_source", "filters", "service"})
public class TopologyQuery {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA_SOURCE = "data_source";
    private TopologyQueryDataSource dataSource;
    public static final String JSON_PROPERTY_FILTERS = "filters";
    private List<String> filters = null;
    public static final String JSON_PROPERTY_SERVICE = "service";
    private String service;

    public TopologyQuery dataSource(TopologyQueryDataSource dataSource) {
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="data_source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TopologyQueryDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(TopologyQueryDataSource dataSource) {
        if (!dataSource.isValid()) {
            this.unparsed = true;
        }
        this.dataSource = dataSource;
    }

    public TopologyQuery filters(List<String> filters) {
        this.filters = filters;
        return this;
    }

    public TopologyQuery addFiltersItem(String filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<String>();
        }
        this.filters.add(filtersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFilters() {
        return this.filters;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public TopologyQuery service(String service) {
        this.service = service;
        return this;
    }

    @Nullable
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyQuery topologyQuery = (TopologyQuery)o;
        return Objects.equals(this.dataSource, topologyQuery.dataSource) && Objects.equals(this.filters, topologyQuery.filters) && Objects.equals(this.service, topologyQuery.service);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.filters, this.service);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TopologyQuery {\n");
        sb.append("    dataSource: ").append(this.toIndentedString(this.dataSource)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

