/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.ListStreamColumn;
import com.datadog.api.client.v1.model.ListStreamQuery;
import com.datadog.api.client.v1.model.ListStreamResponseFormat;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"columns", "query", "response_format"})
public class ListStreamWidgetRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_COLUMNS = "columns";
    private List<ListStreamColumn> columns = new ArrayList<ListStreamColumn>();
    public static final String JSON_PROPERTY_QUERY = "query";
    private ListStreamQuery query;
    public static final String JSON_PROPERTY_RESPONSE_FORMAT = "response_format";
    private ListStreamResponseFormat responseFormat;

    public ListStreamWidgetRequest() {
    }

    @JsonCreator
    public ListStreamWidgetRequest(@JsonProperty(required=true, value="columns") List<ListStreamColumn> columns, @JsonProperty(required=true, value="query") ListStreamQuery query, @JsonProperty(required=true, value="response_format") ListStreamResponseFormat responseFormat) {
        this.columns = columns;
        this.query = query;
        this.unparsed |= query.unparsed;
        this.responseFormat = responseFormat;
        this.unparsed |= !responseFormat.isValid();
    }

    public ListStreamWidgetRequest columns(List<ListStreamColumn> columns) {
        this.columns = columns;
        for (ListStreamColumn item : columns) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ListStreamWidgetRequest addColumnsItem(ListStreamColumn columnsItem) {
        this.columns.add(columnsItem);
        this.unparsed |= columnsItem.unparsed;
        return this;
    }

    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<ListStreamColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ListStreamColumn> columns) {
        this.columns = columns;
    }

    public ListStreamWidgetRequest query(ListStreamQuery query) {
        this.query = query;
        this.unparsed |= query.unparsed;
        return this;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ListStreamQuery getQuery() {
        return this.query;
    }

    public void setQuery(ListStreamQuery query) {
        this.query = query;
    }

    public ListStreamWidgetRequest responseFormat(ListStreamResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        this.unparsed |= !responseFormat.isValid();
        return this;
    }

    @JsonProperty(value="response_format")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ListStreamResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(ListStreamResponseFormat responseFormat) {
        if (!responseFormat.isValid()) {
            this.unparsed = true;
        }
        this.responseFormat = responseFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListStreamWidgetRequest listStreamWidgetRequest = (ListStreamWidgetRequest)o;
        return Objects.equals(this.columns, listStreamWidgetRequest.columns) && Objects.equals(this.query, listStreamWidgetRequest.query) && Objects.equals(this.responseFormat, listStreamWidgetRequest.responseFormat);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.query, this.responseFormat);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListStreamWidgetRequest {\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    responseFormat: ").append(this.toIndentedString(this.responseFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

