/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.TagFilter;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "month", "tag_filters"})
public class BudgetEntry {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Double amount;
    public static final String JSON_PROPERTY_MONTH = "month";
    private Long month;
    public static final String JSON_PROPERTY_TAG_FILTERS = "tag_filters";
    private List<TagFilter> tagFilters = null;
    private Map<String, Object> additionalProperties;

    public BudgetEntry amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public BudgetEntry month(Long month) {
        this.month = month;
        return this;
    }

    @Nullable
    @JsonProperty(value="month")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMonth() {
        return this.month;
    }

    public void setMonth(Long month) {
        this.month = month;
    }

    public BudgetEntry tagFilters(List<TagFilter> tagFilters) {
        this.tagFilters = tagFilters;
        for (TagFilter item : tagFilters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public BudgetEntry addTagFiltersItem(TagFilter tagFiltersItem) {
        if (this.tagFilters == null) {
            this.tagFilters = new ArrayList<TagFilter>();
        }
        this.tagFilters.add(tagFiltersItem);
        this.unparsed |= tagFiltersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="tag_filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagFilter> getTagFilters() {
        return this.tagFilters;
    }

    public void setTagFilters(List<TagFilter> tagFilters) {
        this.tagFilters = tagFilters;
    }

    @JsonAnySetter
    public BudgetEntry putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BudgetEntry budgetEntry = (BudgetEntry)o;
        return Objects.equals(this.amount, budgetEntry.amount) && Objects.equals(this.month, budgetEntry.month) && Objects.equals(this.tagFilters, budgetEntry.tagFilters) && Objects.equals(this.additionalProperties, budgetEntry.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.month, this.tagFilters, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BudgetEntry {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    month: ").append(this.toIndentedString(this.month)).append("\n");
        sb.append("    tagFilters: ").append(this.toIndentedString(this.tagFilters)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

