/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.DORADeploymentRequest;
import com.datadog.api.client.v2.model.DORADeploymentResponse;
import com.datadog.api.client.v2.model.DORAFetchResponse;
import com.datadog.api.client.v2.model.DORAIncidentRequest;
import com.datadog.api.client.v2.model.DORAIncidentResponse;
import com.datadog.api.client.v2.model.DORAListDeploymentsRequest;
import com.datadog.api.client.v2.model.DORAListFailuresRequest;
import com.datadog.api.client.v2.model.DORAListResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class DoraMetricsApi {
    private ApiClient apiClient;

    public DoraMetricsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public DoraMetricsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DORADeploymentResponse createDORADeployment(DORADeploymentRequest body) throws ApiException {
        return this.createDORADeploymentWithHttpInfo(body).getData();
    }

    public CompletableFuture<DORADeploymentResponse> createDORADeploymentAsync(DORADeploymentRequest body) {
        return this.createDORADeploymentWithHttpInfoAsync(body).thenApply(response -> (DORADeploymentResponse)response.getData());
    }

    public ApiResponse<DORADeploymentResponse> createDORADeploymentWithHttpInfo(DORADeploymentRequest body) throws ApiException {
        String operationId = "createDORADeployment";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        DORADeploymentRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDORADeployment");
        }
        String localVarPath = "/api/v2/dora/deployment";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.createDORADeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORADeploymentResponse>(){});
    }

    public CompletableFuture<ApiResponse<DORADeploymentResponse>> createDORADeploymentWithHttpInfoAsync(DORADeploymentRequest body) {
        Invocation.Builder builder;
        String operationId = "createDORADeployment";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DORADeploymentResponse>> result = new CompletableFuture<ApiResponse<DORADeploymentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        DORADeploymentRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DORADeploymentResponse>> result = new CompletableFuture<ApiResponse<DORADeploymentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDORADeployment"));
            return result;
        }
        String localVarPath = "/api/v2/dora/deployment";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.createDORADeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DORADeploymentResponse>> result = new CompletableFuture<ApiResponse<DORADeploymentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORADeploymentResponse>(){});
    }

    public DORAIncidentResponse createDORAIncident(DORAIncidentRequest body) throws ApiException {
        return this.createDORAIncidentWithHttpInfo(body).getData();
    }

    public CompletableFuture<DORAIncidentResponse> createDORAIncidentAsync(DORAIncidentRequest body) {
        return this.createDORAIncidentWithHttpInfoAsync(body).thenApply(response -> (DORAIncidentResponse)response.getData());
    }

    public ApiResponse<DORAIncidentResponse> createDORAIncidentWithHttpInfo(DORAIncidentRequest body) throws ApiException {
        String operationId = "createDORAIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        DORAIncidentRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDORAIncident");
        }
        String localVarPath = "/api/v2/dora/incident";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.createDORAIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAIncidentResponse>(){});
    }

    public CompletableFuture<ApiResponse<DORAIncidentResponse>> createDORAIncidentWithHttpInfoAsync(DORAIncidentRequest body) {
        Invocation.Builder builder;
        String operationId = "createDORAIncident";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DORAIncidentResponse>> result = new CompletableFuture<ApiResponse<DORAIncidentResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        DORAIncidentRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DORAIncidentResponse>> result = new CompletableFuture<ApiResponse<DORAIncidentResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDORAIncident"));
            return result;
        }
        String localVarPath = "/api/v2/dora/incident";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.createDORAIncident", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DORAIncidentResponse>> result = new CompletableFuture<ApiResponse<DORAIncidentResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAIncidentResponse>(){});
    }

    public DORAFetchResponse getDORADeployment(String deploymentId) throws ApiException {
        return this.getDORADeploymentWithHttpInfo(deploymentId).getData();
    }

    public CompletableFuture<DORAFetchResponse> getDORADeploymentAsync(String deploymentId) {
        return this.getDORADeploymentWithHttpInfoAsync(deploymentId).thenApply(response -> (DORAFetchResponse)response.getData());
    }

    public ApiResponse<DORAFetchResponse> getDORADeploymentWithHttpInfo(String deploymentId) throws ApiException {
        Object localVarPostBody = null;
        if (deploymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'deploymentId' when calling getDORADeployment");
        }
        String localVarPath = "/api/v2/dora/deployments/{deployment_id}".replaceAll("\\{deployment_id\\}", this.apiClient.escapeString(deploymentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.getDORADeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"appKeyAuth", "apiKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAFetchResponse>(){});
    }

    public CompletableFuture<ApiResponse<DORAFetchResponse>> getDORADeploymentWithHttpInfoAsync(String deploymentId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (deploymentId == null) {
            CompletableFuture<ApiResponse<DORAFetchResponse>> result = new CompletableFuture<ApiResponse<DORAFetchResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'deploymentId' when calling getDORADeployment"));
            return result;
        }
        String localVarPath = "/api/v2/dora/deployments/{deployment_id}".replaceAll("\\{deployment_id\\}", this.apiClient.escapeString(deploymentId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.getDORADeployment", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"appKeyAuth", "apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DORAFetchResponse>> result = new CompletableFuture<ApiResponse<DORAFetchResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAFetchResponse>(){});
    }

    public DORAFetchResponse getDORAFailure(String failureId) throws ApiException {
        return this.getDORAFailureWithHttpInfo(failureId).getData();
    }

    public CompletableFuture<DORAFetchResponse> getDORAFailureAsync(String failureId) {
        return this.getDORAFailureWithHttpInfoAsync(failureId).thenApply(response -> (DORAFetchResponse)response.getData());
    }

    public ApiResponse<DORAFetchResponse> getDORAFailureWithHttpInfo(String failureId) throws ApiException {
        Object localVarPostBody = null;
        if (failureId == null) {
            throw new ApiException(400, "Missing the required parameter 'failureId' when calling getDORAFailure");
        }
        String localVarPath = "/api/v2/dora/failures/{failure_id}".replaceAll("\\{failure_id\\}", this.apiClient.escapeString(failureId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.getDORAFailure", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"appKeyAuth", "apiKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAFetchResponse>(){});
    }

    public CompletableFuture<ApiResponse<DORAFetchResponse>> getDORAFailureWithHttpInfoAsync(String failureId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (failureId == null) {
            CompletableFuture<ApiResponse<DORAFetchResponse>> result = new CompletableFuture<ApiResponse<DORAFetchResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'failureId' when calling getDORAFailure"));
            return result;
        }
        String localVarPath = "/api/v2/dora/failures/{failure_id}".replaceAll("\\{failure_id\\}", this.apiClient.escapeString(failureId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.getDORAFailure", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"appKeyAuth", "apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DORAFetchResponse>> result = new CompletableFuture<ApiResponse<DORAFetchResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAFetchResponse>(){});
    }

    public DORAListResponse listDORADeployments(DORAListDeploymentsRequest body) throws ApiException {
        return this.listDORADeploymentsWithHttpInfo(body).getData();
    }

    public CompletableFuture<DORAListResponse> listDORADeploymentsAsync(DORAListDeploymentsRequest body) {
        return this.listDORADeploymentsWithHttpInfoAsync(body).thenApply(response -> (DORAListResponse)response.getData());
    }

    public ApiResponse<DORAListResponse> listDORADeploymentsWithHttpInfo(DORAListDeploymentsRequest body) throws ApiException {
        DORAListDeploymentsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling listDORADeployments");
        }
        String localVarPath = "/api/v2/dora/deployments";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.listDORADeployments", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAListResponse>(){});
    }

    public CompletableFuture<ApiResponse<DORAListResponse>> listDORADeploymentsWithHttpInfoAsync(DORAListDeploymentsRequest body) {
        Invocation.Builder builder;
        DORAListDeploymentsRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DORAListResponse>> result = new CompletableFuture<ApiResponse<DORAListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling listDORADeployments"));
            return result;
        }
        String localVarPath = "/api/v2/dora/deployments";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.listDORADeployments", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DORAListResponse>> result = new CompletableFuture<ApiResponse<DORAListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAListResponse>(){});
    }

    public DORAListResponse listDORAFailures(DORAListFailuresRequest body) throws ApiException {
        return this.listDORAFailuresWithHttpInfo(body).getData();
    }

    public CompletableFuture<DORAListResponse> listDORAFailuresAsync(DORAListFailuresRequest body) {
        return this.listDORAFailuresWithHttpInfoAsync(body).thenApply(response -> (DORAListResponse)response.getData());
    }

    public ApiResponse<DORAListResponse> listDORAFailuresWithHttpInfo(DORAListFailuresRequest body) throws ApiException {
        DORAListFailuresRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling listDORAFailures");
        }
        String localVarPath = "/api/v2/dora/failures";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.DoraMetricsApi.listDORAFailures", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAListResponse>(){});
    }

    public CompletableFuture<ApiResponse<DORAListResponse>> listDORAFailuresWithHttpInfoAsync(DORAListFailuresRequest body) {
        Invocation.Builder builder;
        DORAListFailuresRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DORAListResponse>> result = new CompletableFuture<ApiResponse<DORAListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling listDORAFailures"));
            return result;
        }
        String localVarPath = "/api/v2/dora/failures";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.DoraMetricsApi.listDORAFailures", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DORAListResponse>> result = new CompletableFuture<ApiResponse<DORAListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DORAListResponse>(){});
    }
}

