/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.CheckCanDeleteMonitorResponse;
import com.datadog.api.client.v1.model.DeletedMonitor;
import com.datadog.api.client.v1.model.Monitor;
import com.datadog.api.client.v1.model.MonitorGroupSearchResponse;
import com.datadog.api.client.v1.model.MonitorSearchResponse;
import com.datadog.api.client.v1.model.MonitorUpdateRequest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class MonitorsApi {
    private ApiClient apiClient;

    public MonitorsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public MonitorsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CheckCanDeleteMonitorResponse checkCanDeleteMonitor(List<Long> monitorIds) throws ApiException {
        return this.checkCanDeleteMonitorWithHttpInfo(monitorIds).getData();
    }

    public CompletableFuture<CheckCanDeleteMonitorResponse> checkCanDeleteMonitorAsync(List<Long> monitorIds) {
        return this.checkCanDeleteMonitorWithHttpInfoAsync(monitorIds).thenApply(response -> (CheckCanDeleteMonitorResponse)response.getData());
    }

    public ApiResponse<CheckCanDeleteMonitorResponse> checkCanDeleteMonitorWithHttpInfo(List<Long> monitorIds) throws ApiException {
        Object localVarPostBody = null;
        if (monitorIds == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorIds' when calling checkCanDeleteMonitor");
        }
        String localVarPath = "/api/v1/monitor/can_delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "monitor_ids", monitorIds));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MonitorsApi.checkCanDeleteMonitor", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CheckCanDeleteMonitorResponse>(){});
    }

    public CompletableFuture<ApiResponse<CheckCanDeleteMonitorResponse>> checkCanDeleteMonitorWithHttpInfoAsync(List<Long> monitorIds) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (monitorIds == null) {
            CompletableFuture<ApiResponse<CheckCanDeleteMonitorResponse>> result = new CompletableFuture<ApiResponse<CheckCanDeleteMonitorResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'monitorIds' when calling checkCanDeleteMonitor"));
            return result;
        }
        String localVarPath = "/api/v1/monitor/can_delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "monitor_ids", monitorIds));
        try {
            builder = this.apiClient.createBuilder("v1.MonitorsApi.checkCanDeleteMonitor", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CheckCanDeleteMonitorResponse>> result = new CompletableFuture<ApiResponse<CheckCanDeleteMonitorResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CheckCanDeleteMonitorResponse>(){});
    }

    public Monitor createMonitor(Monitor body) throws ApiException {
        return this.createMonitorWithHttpInfo(body).getData();
    }

    public CompletableFuture<Monitor> createMonitorAsync(Monitor body) {
        return this.createMonitorWithHttpInfoAsync(body).thenApply(response -> (Monitor)response.getData());
    }

    public ApiResponse<Monitor> createMonitorWithHttpInfo(Monitor body) throws ApiException {
        Monitor localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createMonitor");
        }
        String localVarPath = "/api/v1/monitor";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MonitorsApi.createMonitor", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Monitor>(){});
    }

    public CompletableFuture<ApiResponse<Monitor>> createMonitorWithHttpInfoAsync(Monitor body) {
        Invocation.Builder builder;
        Monitor localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Monitor>> result = new CompletableFuture<ApiResponse<Monitor>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createMonitor"));
            return result;
        }
        String localVarPath = "/api/v1/monitor";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.MonitorsApi.createMonitor", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Monitor>> result = new CompletableFuture<ApiResponse<Monitor>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Monitor>(){});
    }

    public DeletedMonitor deleteMonitor(Long monitorId) throws ApiException {
        return this.deleteMonitorWithHttpInfo(monitorId, new DeleteMonitorOptionalParameters()).getData();
    }

    public CompletableFuture<DeletedMonitor> deleteMonitorAsync(Long monitorId) {
        return this.deleteMonitorWithHttpInfoAsync(monitorId, new DeleteMonitorOptionalParameters()).thenApply(response -> (DeletedMonitor)response.getData());
    }

    public DeletedMonitor deleteMonitor(Long monitorId, DeleteMonitorOptionalParameters parameters) throws ApiException {
        return this.deleteMonitorWithHttpInfo(monitorId, parameters).getData();
    }

    public CompletableFuture<DeletedMonitor> deleteMonitorAsync(Long monitorId, DeleteMonitorOptionalParameters parameters) {
        return this.deleteMonitorWithHttpInfoAsync(monitorId, parameters).thenApply(response -> (DeletedMonitor)response.getData());
    }

    public ApiResponse<DeletedMonitor> deleteMonitorWithHttpInfo(Long monitorId, DeleteMonitorOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (monitorId == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorId' when calling deleteMonitor");
        }
        String force = parameters.force;
        String localVarPath = "/api/v1/monitor/{monitor_id}".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "force", force));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MonitorsApi.deleteMonitor", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeletedMonitor>(){});
    }

    public CompletableFuture<ApiResponse<DeletedMonitor>> deleteMonitorWithHttpInfoAsync(Long monitorId, DeleteMonitorOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (monitorId == null) {
            CompletableFuture<ApiResponse<DeletedMonitor>> result = new CompletableFuture<ApiResponse<DeletedMonitor>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'monitorId' when calling deleteMonitor"));
            return result;
        }
        String force = parameters.force;
        String localVarPath = "/api/v1/monitor/{monitor_id}".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "force", force));
        try {
            builder = this.apiClient.createBuilder("v1.MonitorsApi.deleteMonitor", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DeletedMonitor>> result = new CompletableFuture<ApiResponse<DeletedMonitor>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeletedMonitor>(){});
    }

    public Monitor getMonitor(Long monitorId) throws ApiException {
        return this.getMonitorWithHttpInfo(monitorId, new GetMonitorOptionalParameters()).getData();
    }

    public CompletableFuture<Monitor> getMonitorAsync(Long monitorId) {
        return this.getMonitorWithHttpInfoAsync(monitorId, new GetMonitorOptionalParameters()).thenApply(response -> (Monitor)response.getData());
    }

    public Monitor getMonitor(Long monitorId, GetMonitorOptionalParameters parameters) throws ApiException {
        return this.getMonitorWithHttpInfo(monitorId, parameters).getData();
    }

    public CompletableFuture<Monitor> getMonitorAsync(Long monitorId, GetMonitorOptionalParameters parameters) {
        return this.getMonitorWithHttpInfoAsync(monitorId, parameters).thenApply(response -> (Monitor)response.getData());
    }

    public ApiResponse<Monitor> getMonitorWithHttpInfo(Long monitorId, GetMonitorOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (monitorId == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorId' when calling getMonitor");
        }
        String groupStates = parameters.groupStates;
        Boolean withDowntimes = parameters.withDowntimes;
        String localVarPath = "/api/v1/monitor/{monitor_id}".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_states", groupStates));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "with_downtimes", withDowntimes));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MonitorsApi.getMonitor", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Monitor>(){});
    }

    public CompletableFuture<ApiResponse<Monitor>> getMonitorWithHttpInfoAsync(Long monitorId, GetMonitorOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (monitorId == null) {
            CompletableFuture<ApiResponse<Monitor>> result = new CompletableFuture<ApiResponse<Monitor>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'monitorId' when calling getMonitor"));
            return result;
        }
        String groupStates = parameters.groupStates;
        Boolean withDowntimes = parameters.withDowntimes;
        String localVarPath = "/api/v1/monitor/{monitor_id}".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_states", groupStates));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "with_downtimes", withDowntimes));
        try {
            builder = this.apiClient.createBuilder("v1.MonitorsApi.getMonitor", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Monitor>> result = new CompletableFuture<ApiResponse<Monitor>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Monitor>(){});
    }

    public List<Monitor> listMonitors() throws ApiException {
        return this.listMonitorsWithHttpInfo(new ListMonitorsOptionalParameters()).getData();
    }

    public CompletableFuture<List<Monitor>> listMonitorsAsync() {
        return this.listMonitorsWithHttpInfoAsync(new ListMonitorsOptionalParameters()).thenApply(response -> (List)response.getData());
    }

    public List<Monitor> listMonitors(ListMonitorsOptionalParameters parameters) throws ApiException {
        return this.listMonitorsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<List<Monitor>> listMonitorsAsync(ListMonitorsOptionalParameters parameters) {
        return this.listMonitorsWithHttpInfoAsync(parameters).thenApply(response -> (List)response.getData());
    }

    public PaginationIterable<Monitor> listMonitorsWithPagination() {
        ListMonitorsOptionalParameters parameters = new ListMonitorsOptionalParameters();
        return this.listMonitorsWithPagination(parameters);
    }

    public PaginationIterable<Monitor> listMonitorsWithPagination(ListMonitorsOptionalParameters parameters) {
        Integer limit;
        String resultsPath = "";
        String valueGetterPath = "";
        String valueSetterPath = "page";
        Boolean valueSetterParamOptional = true;
        parameters.page(0L);
        if (parameters.pageSize == null) {
            limit = 100;
            parameters.pageSize(limit);
        } else {
            limit = parameters.pageSize;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<Monitor> iterator = new PaginationIterable<Monitor>(this, "listMonitors", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, false, limit, args);
        return iterator;
    }

    public ApiResponse<List<Monitor>> listMonitorsWithHttpInfo(ListMonitorsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String groupStates = parameters.groupStates;
        String name = parameters.name;
        String tags = parameters.tags;
        String monitorTags = parameters.monitorTags;
        Boolean withDowntimes = parameters.withDowntimes;
        Long idOffset = parameters.idOffset;
        Long page = parameters.page;
        Integer pageSize = parameters.pageSize;
        String localVarPath = "/api/v1/monitor";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_states", groupStates));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "monitor_tags", monitorTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "with_downtimes", withDowntimes));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id_offset", idOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MonitorsApi.listMonitors", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<Monitor>>(){});
    }

    public CompletableFuture<ApiResponse<List<Monitor>>> listMonitorsWithHttpInfoAsync(ListMonitorsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String groupStates = parameters.groupStates;
        String name = parameters.name;
        String tags = parameters.tags;
        String monitorTags = parameters.monitorTags;
        Boolean withDowntimes = parameters.withDowntimes;
        Long idOffset = parameters.idOffset;
        Long page = parameters.page;
        Integer pageSize = parameters.pageSize;
        String localVarPath = "/api/v1/monitor";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_states", groupStates));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "monitor_tags", monitorTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "with_downtimes", withDowntimes));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id_offset", idOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        try {
            builder = this.apiClient.createBuilder("v1.MonitorsApi.listMonitors", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<List<Monitor>>> result = new CompletableFuture<ApiResponse<List<Monitor>>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<Monitor>>(){});
    }

    public MonitorGroupSearchResponse searchMonitorGroups() throws ApiException {
        return this.searchMonitorGroupsWithHttpInfo(new SearchMonitorGroupsOptionalParameters()).getData();
    }

    public CompletableFuture<MonitorGroupSearchResponse> searchMonitorGroupsAsync() {
        return this.searchMonitorGroupsWithHttpInfoAsync(new SearchMonitorGroupsOptionalParameters()).thenApply(response -> (MonitorGroupSearchResponse)response.getData());
    }

    public MonitorGroupSearchResponse searchMonitorGroups(SearchMonitorGroupsOptionalParameters parameters) throws ApiException {
        return this.searchMonitorGroupsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<MonitorGroupSearchResponse> searchMonitorGroupsAsync(SearchMonitorGroupsOptionalParameters parameters) {
        return this.searchMonitorGroupsWithHttpInfoAsync(parameters).thenApply(response -> (MonitorGroupSearchResponse)response.getData());
    }

    public ApiResponse<MonitorGroupSearchResponse> searchMonitorGroupsWithHttpInfo(SearchMonitorGroupsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String query = parameters.query;
        Long page = parameters.page;
        Long perPage = parameters.perPage;
        String sort = parameters.sort;
        String localVarPath = "/api/v1/monitor/groups/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "per_page", perPage));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MonitorsApi.searchMonitorGroups", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorGroupSearchResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorGroupSearchResponse>> searchMonitorGroupsWithHttpInfoAsync(SearchMonitorGroupsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String query = parameters.query;
        Long page = parameters.page;
        Long perPage = parameters.perPage;
        String sort = parameters.sort;
        String localVarPath = "/api/v1/monitor/groups/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "per_page", perPage));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        try {
            builder = this.apiClient.createBuilder("v1.MonitorsApi.searchMonitorGroups", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorGroupSearchResponse>> result = new CompletableFuture<ApiResponse<MonitorGroupSearchResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorGroupSearchResponse>(){});
    }

    public MonitorSearchResponse searchMonitors() throws ApiException {
        return this.searchMonitorsWithHttpInfo(new SearchMonitorsOptionalParameters()).getData();
    }

    public CompletableFuture<MonitorSearchResponse> searchMonitorsAsync() {
        return this.searchMonitorsWithHttpInfoAsync(new SearchMonitorsOptionalParameters()).thenApply(response -> (MonitorSearchResponse)response.getData());
    }

    public MonitorSearchResponse searchMonitors(SearchMonitorsOptionalParameters parameters) throws ApiException {
        return this.searchMonitorsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<MonitorSearchResponse> searchMonitorsAsync(SearchMonitorsOptionalParameters parameters) {
        return this.searchMonitorsWithHttpInfoAsync(parameters).thenApply(response -> (MonitorSearchResponse)response.getData());
    }

    public ApiResponse<MonitorSearchResponse> searchMonitorsWithHttpInfo(SearchMonitorsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String query = parameters.query;
        Long page = parameters.page;
        Long perPage = parameters.perPage;
        String sort = parameters.sort;
        String localVarPath = "/api/v1/monitor/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "per_page", perPage));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MonitorsApi.searchMonitors", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorSearchResponse>(){});
    }

    public CompletableFuture<ApiResponse<MonitorSearchResponse>> searchMonitorsWithHttpInfoAsync(SearchMonitorsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String query = parameters.query;
        Long page = parameters.page;
        Long perPage = parameters.perPage;
        String sort = parameters.sort;
        String localVarPath = "/api/v1/monitor/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "per_page", perPage));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        try {
            builder = this.apiClient.createBuilder("v1.MonitorsApi.searchMonitors", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<MonitorSearchResponse>> result = new CompletableFuture<ApiResponse<MonitorSearchResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<MonitorSearchResponse>(){});
    }

    public Monitor updateMonitor(Long monitorId, MonitorUpdateRequest body) throws ApiException {
        return this.updateMonitorWithHttpInfo(monitorId, body).getData();
    }

    public CompletableFuture<Monitor> updateMonitorAsync(Long monitorId, MonitorUpdateRequest body) {
        return this.updateMonitorWithHttpInfoAsync(monitorId, body).thenApply(response -> (Monitor)response.getData());
    }

    public ApiResponse<Monitor> updateMonitorWithHttpInfo(Long monitorId, MonitorUpdateRequest body) throws ApiException {
        MonitorUpdateRequest localVarPostBody = body;
        if (monitorId == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorId' when calling updateMonitor");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateMonitor");
        }
        String localVarPath = "/api/v1/monitor/{monitor_id}".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MonitorsApi.updateMonitor", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Monitor>(){});
    }

    public CompletableFuture<ApiResponse<Monitor>> updateMonitorWithHttpInfoAsync(Long monitorId, MonitorUpdateRequest body) {
        Invocation.Builder builder;
        MonitorUpdateRequest localVarPostBody = body;
        if (monitorId == null) {
            CompletableFuture<ApiResponse<Monitor>> result = new CompletableFuture<ApiResponse<Monitor>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'monitorId' when calling updateMonitor"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Monitor>> result = new CompletableFuture<ApiResponse<Monitor>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateMonitor"));
            return result;
        }
        String localVarPath = "/api/v1/monitor/{monitor_id}".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.MonitorsApi.updateMonitor", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Monitor>> result = new CompletableFuture<ApiResponse<Monitor>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Monitor>(){});
    }

    public Object validateExistingMonitor(Long monitorId, Monitor body) throws ApiException {
        return this.validateExistingMonitorWithHttpInfo(monitorId, body).getData();
    }

    public CompletableFuture<Object> validateExistingMonitorAsync(Long monitorId, Monitor body) {
        return this.validateExistingMonitorWithHttpInfoAsync(monitorId, body).thenApply(response -> response.getData());
    }

    public ApiResponse<Object> validateExistingMonitorWithHttpInfo(Long monitorId, Monitor body) throws ApiException {
        Monitor localVarPostBody = body;
        if (monitorId == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorId' when calling validateExistingMonitor");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling validateExistingMonitor");
        }
        String localVarPath = "/api/v1/monitor/{monitor_id}/validate".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MonitorsApi.validateExistingMonitor", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> validateExistingMonitorWithHttpInfoAsync(Long monitorId, Monitor body) {
        Invocation.Builder builder;
        Monitor localVarPostBody = body;
        if (monitorId == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'monitorId' when calling validateExistingMonitor"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling validateExistingMonitor"));
            return result;
        }
        String localVarPath = "/api/v1/monitor/{monitor_id}/validate".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.MonitorsApi.validateExistingMonitor", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public Object validateMonitor(Monitor body) throws ApiException {
        return this.validateMonitorWithHttpInfo(body).getData();
    }

    public CompletableFuture<Object> validateMonitorAsync(Monitor body) {
        return this.validateMonitorWithHttpInfoAsync(body).thenApply(response -> response.getData());
    }

    public ApiResponse<Object> validateMonitorWithHttpInfo(Monitor body) throws ApiException {
        Monitor localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling validateMonitor");
        }
        String localVarPath = "/api/v1/monitor/validate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.MonitorsApi.validateMonitor", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> validateMonitorWithHttpInfoAsync(Monitor body) {
        Invocation.Builder builder;
        Monitor localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling validateMonitor"));
            return result;
        }
        String localVarPath = "/api/v1/monitor/validate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.MonitorsApi.validateMonitor", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public static class SearchMonitorsOptionalParameters {
        private String query;
        private Long page;
        private Long perPage;
        private String sort;

        public SearchMonitorsOptionalParameters query(String query) {
            this.query = query;
            return this;
        }

        public SearchMonitorsOptionalParameters page(Long page) {
            this.page = page;
            return this;
        }

        public SearchMonitorsOptionalParameters perPage(Long perPage) {
            this.perPage = perPage;
            return this;
        }

        public SearchMonitorsOptionalParameters sort(String sort) {
            this.sort = sort;
            return this;
        }
    }

    public static class SearchMonitorGroupsOptionalParameters {
        private String query;
        private Long page;
        private Long perPage;
        private String sort;

        public SearchMonitorGroupsOptionalParameters query(String query) {
            this.query = query;
            return this;
        }

        public SearchMonitorGroupsOptionalParameters page(Long page) {
            this.page = page;
            return this;
        }

        public SearchMonitorGroupsOptionalParameters perPage(Long perPage) {
            this.perPage = perPage;
            return this;
        }

        public SearchMonitorGroupsOptionalParameters sort(String sort) {
            this.sort = sort;
            return this;
        }
    }

    public static class ListMonitorsOptionalParameters {
        private String groupStates;
        private String name;
        private String tags;
        private String monitorTags;
        private Boolean withDowntimes;
        private Long idOffset;
        private Long page;
        private Integer pageSize;

        public ListMonitorsOptionalParameters groupStates(String groupStates) {
            this.groupStates = groupStates;
            return this;
        }

        public ListMonitorsOptionalParameters name(String name) {
            this.name = name;
            return this;
        }

        public ListMonitorsOptionalParameters tags(String tags) {
            this.tags = tags;
            return this;
        }

        public ListMonitorsOptionalParameters monitorTags(String monitorTags) {
            this.monitorTags = monitorTags;
            return this;
        }

        public ListMonitorsOptionalParameters withDowntimes(Boolean withDowntimes) {
            this.withDowntimes = withDowntimes;
            return this;
        }

        public ListMonitorsOptionalParameters idOffset(Long idOffset) {
            this.idOffset = idOffset;
            return this;
        }

        public ListMonitorsOptionalParameters page(Long page) {
            this.page = page;
            return this;
        }

        public ListMonitorsOptionalParameters pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetMonitorOptionalParameters {
        private String groupStates;
        private Boolean withDowntimes;

        public GetMonitorOptionalParameters groupStates(String groupStates) {
            this.groupStates = groupStates;
            return this;
        }

        public GetMonitorOptionalParameters withDowntimes(Boolean withDowntimes) {
            this.withDowntimes = withDowntimes;
            return this;
        }
    }

    public static class DeleteMonitorOptionalParameters {
        private String force;

        public DeleteMonitorOptionalParameters force(String force) {
            this.force = force;
            return this;
        }
    }
}

