/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SyntheticsBrowserTestConfig;
import com.datadog.api.client.v1.model.SyntheticsBrowserTestType;
import com.datadog.api.client.v1.model.SyntheticsStep;
import com.datadog.api.client.v1.model.SyntheticsTestOptions;
import com.datadog.api.client.v1.model.SyntheticsTestPauseStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"config", "locations", "message", "monitor_id", "name", "options", "public_id", "status", "steps", "tags", "type"})
public class SyntheticsBrowserTest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CONFIG = "config";
    private SyntheticsBrowserTestConfig config;
    public static final String JSON_PROPERTY_LOCATIONS = "locations";
    private List<String> locations = new ArrayList<String>();
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_MONITOR_ID = "monitor_id";
    private Long monitorId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private SyntheticsTestOptions options;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private SyntheticsTestPauseStatus status;
    public static final String JSON_PROPERTY_STEPS = "steps";
    private List<SyntheticsStep> steps = null;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SyntheticsBrowserTestType type = SyntheticsBrowserTestType.BROWSER;
    private Map<String, Object> additionalProperties;

    public SyntheticsBrowserTest() {
    }

    @JsonCreator
    public SyntheticsBrowserTest(@JsonProperty(required=true, value="config") SyntheticsBrowserTestConfig config, @JsonProperty(required=true, value="locations") List<String> locations, @JsonProperty(required=true, value="message") String message, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="options") SyntheticsTestOptions options, @JsonProperty(required=true, value="type") SyntheticsBrowserTestType type) {
        this.config = config;
        this.unparsed |= config.unparsed;
        this.locations = locations;
        this.message = message;
        this.name = name;
        this.options = options;
        this.unparsed |= options.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public SyntheticsBrowserTest config(SyntheticsBrowserTestConfig config) {
        this.config = config;
        this.unparsed |= config.unparsed;
        return this;
    }

    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsBrowserTestConfig getConfig() {
        return this.config;
    }

    public void setConfig(SyntheticsBrowserTestConfig config) {
        this.config = config;
    }

    public SyntheticsBrowserTest locations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public SyntheticsBrowserTest addLocationsItem(String locationsItem) {
        this.locations.add(locationsItem);
        return this;
    }

    @JsonProperty(value="locations")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public SyntheticsBrowserTest message(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Nullable
    @JsonProperty(value="monitor_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMonitorId() {
        return this.monitorId;
    }

    public SyntheticsBrowserTest name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SyntheticsBrowserTest options(SyntheticsTestOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsTestOptions getOptions() {
        return this.options;
    }

    public void setOptions(SyntheticsTestOptions options) {
        this.options = options;
    }

    @Nullable
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public SyntheticsBrowserTest status(SyntheticsTestPauseStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestPauseStatus getStatus() {
        return this.status;
    }

    public void setStatus(SyntheticsTestPauseStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public SyntheticsBrowserTest steps(List<SyntheticsStep> steps) {
        this.steps = steps;
        for (SyntheticsStep item : steps) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsBrowserTest addStepsItem(SyntheticsStep stepsItem) {
        if (this.steps == null) {
            this.steps = new ArrayList<SyntheticsStep>();
        }
        this.steps.add(stepsItem);
        this.unparsed |= stepsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="steps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<SyntheticsStep> steps) {
        this.steps = steps;
    }

    public SyntheticsBrowserTest tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SyntheticsBrowserTest addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public SyntheticsBrowserTest type(SyntheticsBrowserTestType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsBrowserTestType getType() {
        return this.type;
    }

    public void setType(SyntheticsBrowserTestType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public SyntheticsBrowserTest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsBrowserTest syntheticsBrowserTest = (SyntheticsBrowserTest)o;
        return Objects.equals(this.config, syntheticsBrowserTest.config) && Objects.equals(this.locations, syntheticsBrowserTest.locations) && Objects.equals(this.message, syntheticsBrowserTest.message) && Objects.equals(this.monitorId, syntheticsBrowserTest.monitorId) && Objects.equals(this.name, syntheticsBrowserTest.name) && Objects.equals(this.options, syntheticsBrowserTest.options) && Objects.equals(this.publicId, syntheticsBrowserTest.publicId) && Objects.equals(this.status, syntheticsBrowserTest.status) && Objects.equals(this.steps, syntheticsBrowserTest.steps) && Objects.equals(this.tags, syntheticsBrowserTest.tags) && Objects.equals(this.type, syntheticsBrowserTest.type) && Objects.equals(this.additionalProperties, syntheticsBrowserTest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.locations, this.message, this.monitorId, this.name, this.options, this.publicId, this.status, this.steps, this.tags, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsBrowserTest {\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    locations: ").append(this.toIndentedString(this.locations)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    monitorId: ").append(this.toIndentedString(this.monitorId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    steps: ").append(this.toIndentedString(this.steps)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

