/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CIAppTestLevel;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"attributes", "tags", "test_level"})
public class CIAppEventAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, Object> attributes = null;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TEST_LEVEL = "test_level";
    private CIAppTestLevel testLevel;
    private Map<String, Object> additionalProperties;

    public CIAppEventAttributes attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public CIAppEventAttributes putAttributesItem(String key, Object attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public CIAppEventAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public CIAppEventAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public CIAppEventAttributes testLevel(CIAppTestLevel testLevel) {
        this.testLevel = testLevel;
        this.unparsed |= !testLevel.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="test_level")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CIAppTestLevel getTestLevel() {
        return this.testLevel;
    }

    public void setTestLevel(CIAppTestLevel testLevel) {
        if (!testLevel.isValid()) {
            this.unparsed = true;
        }
        this.testLevel = testLevel;
    }

    @JsonAnySetter
    public CIAppEventAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CIAppEventAttributes ciAppEventAttributes = (CIAppEventAttributes)o;
        return Objects.equals(this.attributes, ciAppEventAttributes.attributes) && Objects.equals(this.tags, ciAppEventAttributes.tags) && Objects.equals(this.testLevel, ciAppEventAttributes.testLevel) && Objects.equals(this.additionalProperties, ciAppEventAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.tags, this.testLevel, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CIAppEventAttributes {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    testLevel: ").append(this.toIndentedString(this.testLevel)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

