/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.BulkMuteFindingsRequest;
import com.datadog.api.client.v2.model.BulkMuteFindingsResponse;
import com.datadog.api.client.v2.model.Finding;
import com.datadog.api.client.v2.model.FindingEvaluation;
import com.datadog.api.client.v2.model.FindingStatus;
import com.datadog.api.client.v2.model.GetFindingResponse;
import com.datadog.api.client.v2.model.ListFindingsResponse;
import com.datadog.api.client.v2.model.SecurityFilterCreateRequest;
import com.datadog.api.client.v2.model.SecurityFilterResponse;
import com.datadog.api.client.v2.model.SecurityFilterUpdateRequest;
import com.datadog.api.client.v2.model.SecurityFiltersResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringListRulesResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleCreatePayload;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleUpdatePayload;
import com.datadog.api.client.v2.model.SecurityMonitoringSignal;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalAssigneeUpdateRequest;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalIncidentsUpdateRequest;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalListRequest;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalListRequestPage;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalStateUpdateRequest;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalTriageUpdateResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalsListResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalsSort;
import com.datadog.api.client.v2.model.SecurityMonitoringSuppressionCreateRequest;
import com.datadog.api.client.v2.model.SecurityMonitoringSuppressionResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringSuppressionUpdateRequest;
import com.datadog.api.client.v2.model.SecurityMonitoringSuppressionsResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class SecurityMonitoringApi {
    private ApiClient apiClient;

    public SecurityMonitoringApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public SecurityMonitoringApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SecurityFilterResponse createSecurityFilter(SecurityFilterCreateRequest body) throws ApiException {
        return this.createSecurityFilterWithHttpInfo(body).getData();
    }

    public CompletableFuture<SecurityFilterResponse> createSecurityFilterAsync(SecurityFilterCreateRequest body) {
        return this.createSecurityFilterWithHttpInfoAsync(body).thenApply(response -> (SecurityFilterResponse)response.getData());
    }

    public ApiResponse<SecurityFilterResponse> createSecurityFilterWithHttpInfo(SecurityFilterCreateRequest body) throws ApiException {
        SecurityFilterCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSecurityFilter");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityFilterResponse>> createSecurityFilterWithHttpInfoAsync(SecurityFilterCreateRequest body) {
        Invocation.Builder builder;
        SecurityFilterCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSecurityFilter"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public SecurityMonitoringRuleResponse createSecurityMonitoringRule(SecurityMonitoringRuleCreatePayload body) throws ApiException {
        return this.createSecurityMonitoringRuleWithHttpInfo(body).getData();
    }

    public CompletableFuture<SecurityMonitoringRuleResponse> createSecurityMonitoringRuleAsync(SecurityMonitoringRuleCreatePayload body) {
        return this.createSecurityMonitoringRuleWithHttpInfoAsync(body).thenApply(response -> (SecurityMonitoringRuleResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringRuleResponse> createSecurityMonitoringRuleWithHttpInfo(SecurityMonitoringRuleCreatePayload body) throws ApiException {
        SecurityMonitoringRuleCreatePayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> createSecurityMonitoringRuleWithHttpInfoAsync(SecurityMonitoringRuleCreatePayload body) {
        Invocation.Builder builder;
        SecurityMonitoringRuleCreatePayload localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public SecurityMonitoringSuppressionResponse createSecurityMonitoringSuppression(SecurityMonitoringSuppressionCreateRequest body) throws ApiException {
        return this.createSecurityMonitoringSuppressionWithHttpInfo(body).getData();
    }

    public CompletableFuture<SecurityMonitoringSuppressionResponse> createSecurityMonitoringSuppressionAsync(SecurityMonitoringSuppressionCreateRequest body) {
        return this.createSecurityMonitoringSuppressionWithHttpInfoAsync(body).thenApply(response -> (SecurityMonitoringSuppressionResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSuppressionResponse> createSecurityMonitoringSuppressionWithHttpInfo(SecurityMonitoringSuppressionCreateRequest body) throws ApiException {
        SecurityMonitoringSuppressionCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSecurityMonitoringSuppression");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> createSecurityMonitoringSuppressionWithHttpInfoAsync(SecurityMonitoringSuppressionCreateRequest body) {
        Invocation.Builder builder;
        SecurityMonitoringSuppressionCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSecurityMonitoringSuppression"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionResponse>(){});
    }

    public void deleteSecurityFilter(String securityFilterId) throws ApiException {
        this.deleteSecurityFilterWithHttpInfo(securityFilterId);
    }

    public CompletableFuture<Void> deleteSecurityFilterAsync(String securityFilterId) {
        return this.deleteSecurityFilterWithHttpInfoAsync(securityFilterId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteSecurityFilterWithHttpInfo(String securityFilterId) throws ApiException {
        Object localVarPostBody = null;
        if (securityFilterId == null) {
            throw new ApiException(400, "Missing the required parameter 'securityFilterId' when calling deleteSecurityFilter");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteSecurityFilterWithHttpInfoAsync(String securityFilterId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (securityFilterId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'securityFilterId' when calling deleteSecurityFilter"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteSecurityMonitoringRule(String ruleId) throws ApiException {
        this.deleteSecurityMonitoringRuleWithHttpInfo(ruleId);
    }

    public CompletableFuture<Void> deleteSecurityMonitoringRuleAsync(String ruleId) {
        return this.deleteSecurityMonitoringRuleWithHttpInfoAsync(ruleId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteSecurityMonitoringRuleWithHttpInfo(String ruleId) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteSecurityMonitoringRuleWithHttpInfoAsync(String ruleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteSecurityMonitoringSuppression(String suppressionId) throws ApiException {
        this.deleteSecurityMonitoringSuppressionWithHttpInfo(suppressionId);
    }

    public CompletableFuture<Void> deleteSecurityMonitoringSuppressionAsync(String suppressionId) {
        return this.deleteSecurityMonitoringSuppressionWithHttpInfoAsync(suppressionId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteSecurityMonitoringSuppressionWithHttpInfo(String suppressionId) throws ApiException {
        Object localVarPostBody = null;
        if (suppressionId == null) {
            throw new ApiException(400, "Missing the required parameter 'suppressionId' when calling deleteSecurityMonitoringSuppression");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/{suppression_id}".replaceAll("\\{suppression_id\\}", this.apiClient.escapeString(suppressionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteSecurityMonitoringSuppressionWithHttpInfoAsync(String suppressionId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (suppressionId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'suppressionId' when calling deleteSecurityMonitoringSuppression"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/{suppression_id}".replaceAll("\\{suppression_id\\}", this.apiClient.escapeString(suppressionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public SecurityMonitoringSignalTriageUpdateResponse editSecurityMonitoringSignalAssignee(String signalId, SecurityMonitoringSignalAssigneeUpdateRequest body) throws ApiException {
        return this.editSecurityMonitoringSignalAssigneeWithHttpInfo(signalId, body).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalTriageUpdateResponse> editSecurityMonitoringSignalAssigneeAsync(String signalId, SecurityMonitoringSignalAssigneeUpdateRequest body) {
        return this.editSecurityMonitoringSignalAssigneeWithHttpInfoAsync(signalId, body).thenApply(response -> (SecurityMonitoringSignalTriageUpdateResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSignalTriageUpdateResponse> editSecurityMonitoringSignalAssigneeWithHttpInfo(String signalId, SecurityMonitoringSignalAssigneeUpdateRequest body) throws ApiException {
        SecurityMonitoringSignalAssigneeUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            throw new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalAssignee");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalAssignee");
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}/assignee".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.editSecurityMonitoringSignalAssignee", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalTriageUpdateResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> editSecurityMonitoringSignalAssigneeWithHttpInfoAsync(String signalId, SecurityMonitoringSignalAssigneeUpdateRequest body) {
        Invocation.Builder builder;
        SecurityMonitoringSignalAssigneeUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalAssignee"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalAssignee"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}/assignee".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.editSecurityMonitoringSignalAssignee", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalTriageUpdateResponse>(){});
    }

    public SecurityMonitoringSignalTriageUpdateResponse editSecurityMonitoringSignalIncidents(String signalId, SecurityMonitoringSignalIncidentsUpdateRequest body) throws ApiException {
        return this.editSecurityMonitoringSignalIncidentsWithHttpInfo(signalId, body).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalTriageUpdateResponse> editSecurityMonitoringSignalIncidentsAsync(String signalId, SecurityMonitoringSignalIncidentsUpdateRequest body) {
        return this.editSecurityMonitoringSignalIncidentsWithHttpInfoAsync(signalId, body).thenApply(response -> (SecurityMonitoringSignalTriageUpdateResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSignalTriageUpdateResponse> editSecurityMonitoringSignalIncidentsWithHttpInfo(String signalId, SecurityMonitoringSignalIncidentsUpdateRequest body) throws ApiException {
        SecurityMonitoringSignalIncidentsUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            throw new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalIncidents");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalIncidents");
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}/incidents".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.editSecurityMonitoringSignalIncidents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalTriageUpdateResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> editSecurityMonitoringSignalIncidentsWithHttpInfoAsync(String signalId, SecurityMonitoringSignalIncidentsUpdateRequest body) {
        Invocation.Builder builder;
        SecurityMonitoringSignalIncidentsUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalIncidents"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalIncidents"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}/incidents".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.editSecurityMonitoringSignalIncidents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalTriageUpdateResponse>(){});
    }

    public SecurityMonitoringSignalTriageUpdateResponse editSecurityMonitoringSignalState(String signalId, SecurityMonitoringSignalStateUpdateRequest body) throws ApiException {
        return this.editSecurityMonitoringSignalStateWithHttpInfo(signalId, body).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalTriageUpdateResponse> editSecurityMonitoringSignalStateAsync(String signalId, SecurityMonitoringSignalStateUpdateRequest body) {
        return this.editSecurityMonitoringSignalStateWithHttpInfoAsync(signalId, body).thenApply(response -> (SecurityMonitoringSignalTriageUpdateResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSignalTriageUpdateResponse> editSecurityMonitoringSignalStateWithHttpInfo(String signalId, SecurityMonitoringSignalStateUpdateRequest body) throws ApiException {
        SecurityMonitoringSignalStateUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            throw new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalState");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalState");
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}/state".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.editSecurityMonitoringSignalState", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalTriageUpdateResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> editSecurityMonitoringSignalStateWithHttpInfoAsync(String signalId, SecurityMonitoringSignalStateUpdateRequest body) {
        Invocation.Builder builder;
        SecurityMonitoringSignalStateUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalState"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalState"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}/state".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.editSecurityMonitoringSignalState", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalTriageUpdateResponse>(){});
    }

    public GetFindingResponse getFinding(String findingId) throws ApiException {
        return this.getFindingWithHttpInfo(findingId, new GetFindingOptionalParameters()).getData();
    }

    public CompletableFuture<GetFindingResponse> getFindingAsync(String findingId) {
        return this.getFindingWithHttpInfoAsync(findingId, new GetFindingOptionalParameters()).thenApply(response -> (GetFindingResponse)response.getData());
    }

    public GetFindingResponse getFinding(String findingId, GetFindingOptionalParameters parameters) throws ApiException {
        return this.getFindingWithHttpInfo(findingId, parameters).getData();
    }

    public CompletableFuture<GetFindingResponse> getFindingAsync(String findingId, GetFindingOptionalParameters parameters) {
        return this.getFindingWithHttpInfoAsync(findingId, parameters).thenApply(response -> (GetFindingResponse)response.getData());
    }

    public ApiResponse<GetFindingResponse> getFindingWithHttpInfo(String findingId, GetFindingOptionalParameters parameters) throws ApiException {
        String operationId = "getFinding";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (findingId == null) {
            throw new ApiException(400, "Missing the required parameter 'findingId' when calling getFinding");
        }
        Long snapshotTimestamp = parameters.snapshotTimestamp;
        String localVarPath = "/api/v2/posture_management/findings/{finding_id}".replaceAll("\\{finding_id\\}", this.apiClient.escapeString(findingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "snapshot_timestamp", snapshotTimestamp));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getFinding", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetFindingResponse>(){});
    }

    public CompletableFuture<ApiResponse<GetFindingResponse>> getFindingWithHttpInfoAsync(String findingId, GetFindingOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getFinding";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<GetFindingResponse>> result = new CompletableFuture<ApiResponse<GetFindingResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (findingId == null) {
            CompletableFuture<ApiResponse<GetFindingResponse>> result = new CompletableFuture<ApiResponse<GetFindingResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'findingId' when calling getFinding"));
            return result;
        }
        Long snapshotTimestamp = parameters.snapshotTimestamp;
        String localVarPath = "/api/v2/posture_management/findings/{finding_id}".replaceAll("\\{finding_id\\}", this.apiClient.escapeString(findingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "snapshot_timestamp", snapshotTimestamp));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getFinding", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetFindingResponse>> result = new CompletableFuture<ApiResponse<GetFindingResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetFindingResponse>(){});
    }

    public SecurityFilterResponse getSecurityFilter(String securityFilterId) throws ApiException {
        return this.getSecurityFilterWithHttpInfo(securityFilterId).getData();
    }

    public CompletableFuture<SecurityFilterResponse> getSecurityFilterAsync(String securityFilterId) {
        return this.getSecurityFilterWithHttpInfoAsync(securityFilterId).thenApply(response -> (SecurityFilterResponse)response.getData());
    }

    public ApiResponse<SecurityFilterResponse> getSecurityFilterWithHttpInfo(String securityFilterId) throws ApiException {
        Object localVarPostBody = null;
        if (securityFilterId == null) {
            throw new ApiException(400, "Missing the required parameter 'securityFilterId' when calling getSecurityFilter");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityFilterResponse>> getSecurityFilterWithHttpInfoAsync(String securityFilterId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (securityFilterId == null) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'securityFilterId' when calling getSecurityFilter"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public SecurityMonitoringRuleResponse getSecurityMonitoringRule(String ruleId) throws ApiException {
        return this.getSecurityMonitoringRuleWithHttpInfo(ruleId).getData();
    }

    public CompletableFuture<SecurityMonitoringRuleResponse> getSecurityMonitoringRuleAsync(String ruleId) {
        return this.getSecurityMonitoringRuleWithHttpInfoAsync(ruleId).thenApply(response -> (SecurityMonitoringRuleResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringRuleResponse> getSecurityMonitoringRuleWithHttpInfo(String ruleId) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling getSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> getSecurityMonitoringRuleWithHttpInfoAsync(String ruleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling getSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public SecurityMonitoringSignalResponse getSecurityMonitoringSignal(String signalId) throws ApiException {
        return this.getSecurityMonitoringSignalWithHttpInfo(signalId).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalResponse> getSecurityMonitoringSignalAsync(String signalId) {
        return this.getSecurityMonitoringSignalWithHttpInfoAsync(signalId).thenApply(response -> (SecurityMonitoringSignalResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSignalResponse> getSecurityMonitoringSignalWithHttpInfo(String signalId) throws ApiException {
        Object localVarPostBody = null;
        if (signalId == null) {
            throw new ApiException(400, "Missing the required parameter 'signalId' when calling getSecurityMonitoringSignal");
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringSignal", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>> getSecurityMonitoringSignalWithHttpInfoAsync(String signalId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (signalId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'signalId' when calling getSecurityMonitoringSignal"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringSignal", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalResponse>(){});
    }

    public SecurityMonitoringSuppressionResponse getSecurityMonitoringSuppression(String suppressionId) throws ApiException {
        return this.getSecurityMonitoringSuppressionWithHttpInfo(suppressionId).getData();
    }

    public CompletableFuture<SecurityMonitoringSuppressionResponse> getSecurityMonitoringSuppressionAsync(String suppressionId) {
        return this.getSecurityMonitoringSuppressionWithHttpInfoAsync(suppressionId).thenApply(response -> (SecurityMonitoringSuppressionResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSuppressionResponse> getSecurityMonitoringSuppressionWithHttpInfo(String suppressionId) throws ApiException {
        Object localVarPostBody = null;
        if (suppressionId == null) {
            throw new ApiException(400, "Missing the required parameter 'suppressionId' when calling getSecurityMonitoringSuppression");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/{suppression_id}".replaceAll("\\{suppression_id\\}", this.apiClient.escapeString(suppressionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> getSecurityMonitoringSuppressionWithHttpInfoAsync(String suppressionId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (suppressionId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'suppressionId' when calling getSecurityMonitoringSuppression"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/{suppression_id}".replaceAll("\\{suppression_id\\}", this.apiClient.escapeString(suppressionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionResponse>(){});
    }

    public ListFindingsResponse listFindings() throws ApiException {
        return this.listFindingsWithHttpInfo(new ListFindingsOptionalParameters()).getData();
    }

    public CompletableFuture<ListFindingsResponse> listFindingsAsync() {
        return this.listFindingsWithHttpInfoAsync(new ListFindingsOptionalParameters()).thenApply(response -> (ListFindingsResponse)response.getData());
    }

    public ListFindingsResponse listFindings(ListFindingsOptionalParameters parameters) throws ApiException {
        return this.listFindingsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListFindingsResponse> listFindingsAsync(ListFindingsOptionalParameters parameters) {
        return this.listFindingsWithHttpInfoAsync(parameters).thenApply(response -> (ListFindingsResponse)response.getData());
    }

    public PaginationIterable<Finding> listFindingsWithPagination() {
        ListFindingsOptionalParameters parameters = new ListFindingsOptionalParameters();
        return this.listFindingsWithPagination(parameters);
    }

    public PaginationIterable<Finding> listFindingsWithPagination(ListFindingsOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getCursor";
        String valueSetterPath = "pageCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 100L;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<Finding> iterator = new PaginationIterable<Finding>(this, "listFindings", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<ListFindingsResponse> listFindingsWithHttpInfo(ListFindingsOptionalParameters parameters) throws ApiException {
        String operationId = "listFindings";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageLimit = parameters.pageLimit;
        Long snapshotTimestamp = parameters.snapshotTimestamp;
        String pageCursor = parameters.pageCursor;
        String filterTags = parameters.filterTags;
        String filterEvaluationChangedAt = parameters.filterEvaluationChangedAt;
        Boolean filterMuted = parameters.filterMuted;
        String filterRuleId = parameters.filterRuleId;
        String filterRuleName = parameters.filterRuleName;
        String filterResourceType = parameters.filterResourceType;
        String filterDiscoveryTimestamp = parameters.filterDiscoveryTimestamp;
        FindingEvaluation filterEvaluation = parameters.filterEvaluation;
        FindingStatus filterStatus = parameters.filterStatus;
        String localVarPath = "/api/v2/posture_management/findings";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "snapshot_timestamp", snapshotTimestamp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags]", filterTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[evaluation_changed_at]", filterEvaluationChangedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[muted]", filterMuted));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule_id]", filterRuleId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule_name]", filterRuleName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[resource_type]", filterResourceType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[discovery_timestamp]", filterDiscoveryTimestamp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[evaluation]", filterEvaluation));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[status]", filterStatus));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listFindings", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListFindingsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListFindingsResponse>> listFindingsWithHttpInfoAsync(ListFindingsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listFindings";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ListFindingsResponse>> result = new CompletableFuture<ApiResponse<ListFindingsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageLimit = parameters.pageLimit;
        Long snapshotTimestamp = parameters.snapshotTimestamp;
        String pageCursor = parameters.pageCursor;
        String filterTags = parameters.filterTags;
        String filterEvaluationChangedAt = parameters.filterEvaluationChangedAt;
        Boolean filterMuted = parameters.filterMuted;
        String filterRuleId = parameters.filterRuleId;
        String filterRuleName = parameters.filterRuleName;
        String filterResourceType = parameters.filterResourceType;
        String filterDiscoveryTimestamp = parameters.filterDiscoveryTimestamp;
        FindingEvaluation filterEvaluation = parameters.filterEvaluation;
        FindingStatus filterStatus = parameters.filterStatus;
        String localVarPath = "/api/v2/posture_management/findings";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "snapshot_timestamp", snapshotTimestamp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags]", filterTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[evaluation_changed_at]", filterEvaluationChangedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[muted]", filterMuted));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule_id]", filterRuleId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule_name]", filterRuleName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[resource_type]", filterResourceType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[discovery_timestamp]", filterDiscoveryTimestamp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[evaluation]", filterEvaluation));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[status]", filterStatus));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listFindings", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListFindingsResponse>> result = new CompletableFuture<ApiResponse<ListFindingsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListFindingsResponse>(){});
    }

    public SecurityFiltersResponse listSecurityFilters() throws ApiException {
        return this.listSecurityFiltersWithHttpInfo().getData();
    }

    public CompletableFuture<SecurityFiltersResponse> listSecurityFiltersAsync() {
        return this.listSecurityFiltersWithHttpInfoAsync().thenApply(response -> (SecurityFiltersResponse)response.getData());
    }

    public ApiResponse<SecurityFiltersResponse> listSecurityFiltersWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFiltersResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityFiltersResponse>> listSecurityFiltersWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityFiltersResponse>> result = new CompletableFuture<ApiResponse<SecurityFiltersResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFiltersResponse>(){});
    }

    public SecurityMonitoringListRulesResponse listSecurityMonitoringRules() throws ApiException {
        return this.listSecurityMonitoringRulesWithHttpInfo(new ListSecurityMonitoringRulesOptionalParameters()).getData();
    }

    public CompletableFuture<SecurityMonitoringListRulesResponse> listSecurityMonitoringRulesAsync() {
        return this.listSecurityMonitoringRulesWithHttpInfoAsync(new ListSecurityMonitoringRulesOptionalParameters()).thenApply(response -> (SecurityMonitoringListRulesResponse)response.getData());
    }

    public SecurityMonitoringListRulesResponse listSecurityMonitoringRules(ListSecurityMonitoringRulesOptionalParameters parameters) throws ApiException {
        return this.listSecurityMonitoringRulesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SecurityMonitoringListRulesResponse> listSecurityMonitoringRulesAsync(ListSecurityMonitoringRulesOptionalParameters parameters) {
        return this.listSecurityMonitoringRulesWithHttpInfoAsync(parameters).thenApply(response -> (SecurityMonitoringListRulesResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringListRulesResponse> listSecurityMonitoringRulesWithHttpInfo(ListSecurityMonitoringRulesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/security_monitoring/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityMonitoringRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringListRulesResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringListRulesResponse>> listSecurityMonitoringRulesWithHttpInfoAsync(ListSecurityMonitoringRulesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/security_monitoring/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityMonitoringRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringListRulesResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringListRulesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringListRulesResponse>(){});
    }

    public SecurityMonitoringSignalsListResponse listSecurityMonitoringSignals() throws ApiException {
        return this.listSecurityMonitoringSignalsWithHttpInfo(new ListSecurityMonitoringSignalsOptionalParameters()).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> listSecurityMonitoringSignalsAsync() {
        return this.listSecurityMonitoringSignalsWithHttpInfoAsync(new ListSecurityMonitoringSignalsOptionalParameters()).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public SecurityMonitoringSignalsListResponse listSecurityMonitoringSignals(ListSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        return this.listSecurityMonitoringSignalsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> listSecurityMonitoringSignalsAsync(ListSecurityMonitoringSignalsOptionalParameters parameters) {
        return this.listSecurityMonitoringSignalsWithHttpInfoAsync(parameters).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public PaginationIterable<SecurityMonitoringSignal> listSecurityMonitoringSignalsWithPagination() {
        ListSecurityMonitoringSignalsOptionalParameters parameters = new ListSecurityMonitoringSignalsOptionalParameters();
        return this.listSecurityMonitoringSignalsWithPagination(parameters);
    }

    public PaginationIterable<SecurityMonitoringSignal> listSecurityMonitoringSignalsWithPagination(ListSecurityMonitoringSignalsOptionalParameters parameters) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "pageCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 10;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<SecurityMonitoringSignal> iterator = new PaginationIterable<SecurityMonitoringSignal>(this, "listSecurityMonitoringSignals", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<SecurityMonitoringSignalsListResponse> listSecurityMonitoringSignalsWithHttpInfo(ListSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        SecurityMonitoringSignalsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/security_monitoring/signals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityMonitoringSignals", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> listSecurityMonitoringSignalsWithHttpInfoAsync(ListSecurityMonitoringSignalsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        SecurityMonitoringSignalsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/security_monitoring/signals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityMonitoringSignals", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public SecurityMonitoringSuppressionsResponse listSecurityMonitoringSuppressions() throws ApiException {
        return this.listSecurityMonitoringSuppressionsWithHttpInfo().getData();
    }

    public CompletableFuture<SecurityMonitoringSuppressionsResponse> listSecurityMonitoringSuppressionsAsync() {
        return this.listSecurityMonitoringSuppressionsWithHttpInfoAsync().thenApply(response -> (SecurityMonitoringSuppressionsResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSuppressionsResponse> listSecurityMonitoringSuppressionsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityMonitoringSuppressions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>> listSecurityMonitoringSuppressionsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityMonitoringSuppressions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionsResponse>(){});
    }

    public BulkMuteFindingsResponse muteFindings(BulkMuteFindingsRequest body) throws ApiException {
        return this.muteFindingsWithHttpInfo(body).getData();
    }

    public CompletableFuture<BulkMuteFindingsResponse> muteFindingsAsync(BulkMuteFindingsRequest body) {
        return this.muteFindingsWithHttpInfoAsync(body).thenApply(response -> (BulkMuteFindingsResponse)response.getData());
    }

    public ApiResponse<BulkMuteFindingsResponse> muteFindingsWithHttpInfo(BulkMuteFindingsRequest body) throws ApiException {
        String operationId = "muteFindings";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        BulkMuteFindingsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling muteFindings");
        }
        String localVarPath = "/api/v2/posture_management/findings";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.muteFindings", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BulkMuteFindingsResponse>(){});
    }

    public CompletableFuture<ApiResponse<BulkMuteFindingsResponse>> muteFindingsWithHttpInfoAsync(BulkMuteFindingsRequest body) {
        Invocation.Builder builder;
        String operationId = "muteFindings";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<BulkMuteFindingsResponse>> result = new CompletableFuture<ApiResponse<BulkMuteFindingsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        BulkMuteFindingsRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<BulkMuteFindingsResponse>> result = new CompletableFuture<ApiResponse<BulkMuteFindingsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling muteFindings"));
            return result;
        }
        String localVarPath = "/api/v2/posture_management/findings";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.muteFindings", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<BulkMuteFindingsResponse>> result = new CompletableFuture<ApiResponse<BulkMuteFindingsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BulkMuteFindingsResponse>(){});
    }

    public SecurityMonitoringSignalsListResponse searchSecurityMonitoringSignals() throws ApiException {
        return this.searchSecurityMonitoringSignalsWithHttpInfo(new SearchSecurityMonitoringSignalsOptionalParameters()).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> searchSecurityMonitoringSignalsAsync() {
        return this.searchSecurityMonitoringSignalsWithHttpInfoAsync(new SearchSecurityMonitoringSignalsOptionalParameters()).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public SecurityMonitoringSignalsListResponse searchSecurityMonitoringSignals(SearchSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        return this.searchSecurityMonitoringSignalsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> searchSecurityMonitoringSignalsAsync(SearchSecurityMonitoringSignalsOptionalParameters parameters) {
        return this.searchSecurityMonitoringSignalsWithHttpInfoAsync(parameters).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public PaginationIterable<SecurityMonitoringSignal> searchSecurityMonitoringSignalsWithPagination() {
        SearchSecurityMonitoringSignalsOptionalParameters parameters = new SearchSecurityMonitoringSignalsOptionalParameters();
        return this.searchSecurityMonitoringSignalsWithPagination(parameters);
    }

    public PaginationIterable<SecurityMonitoringSignal> searchSecurityMonitoringSignalsWithPagination(SearchSecurityMonitoringSignalsOptionalParameters parameters) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "body.getPage.setCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.body == null) {
            parameters.body(new SecurityMonitoringSignalListRequest());
        }
        if (parameters.body.getPage() == null) {
            parameters.body.setPage(new SecurityMonitoringSignalListRequestPage());
        }
        if (parameters.body.getPage().getLimit() == null) {
            limit = 10;
            parameters.body.getPage().setLimit(limit);
        } else {
            limit = parameters.body.getPage().getLimit();
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<SecurityMonitoringSignal> iterator = new PaginationIterable<SecurityMonitoringSignal>(this, "searchSecurityMonitoringSignals", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<SecurityMonitoringSignalsListResponse> searchSecurityMonitoringSignalsWithHttpInfo(SearchSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        SecurityMonitoringSignalListRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/security_monitoring/signals/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.searchSecurityMonitoringSignals", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> searchSecurityMonitoringSignalsWithHttpInfoAsync(SearchSecurityMonitoringSignalsOptionalParameters parameters) {
        Invocation.Builder builder;
        SecurityMonitoringSignalListRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/security_monitoring/signals/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.searchSecurityMonitoringSignals", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public SecurityFilterResponse updateSecurityFilter(String securityFilterId, SecurityFilterUpdateRequest body) throws ApiException {
        return this.updateSecurityFilterWithHttpInfo(securityFilterId, body).getData();
    }

    public CompletableFuture<SecurityFilterResponse> updateSecurityFilterAsync(String securityFilterId, SecurityFilterUpdateRequest body) {
        return this.updateSecurityFilterWithHttpInfoAsync(securityFilterId, body).thenApply(response -> (SecurityFilterResponse)response.getData());
    }

    public ApiResponse<SecurityFilterResponse> updateSecurityFilterWithHttpInfo(String securityFilterId, SecurityFilterUpdateRequest body) throws ApiException {
        SecurityFilterUpdateRequest localVarPostBody = body;
        if (securityFilterId == null) {
            throw new ApiException(400, "Missing the required parameter 'securityFilterId' when calling updateSecurityFilter");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityFilter");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityFilterResponse>> updateSecurityFilterWithHttpInfoAsync(String securityFilterId, SecurityFilterUpdateRequest body) {
        Invocation.Builder builder;
        SecurityFilterUpdateRequest localVarPostBody = body;
        if (securityFilterId == null) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'securityFilterId' when calling updateSecurityFilter"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityFilter"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public SecurityMonitoringRuleResponse updateSecurityMonitoringRule(String ruleId, SecurityMonitoringRuleUpdatePayload body) throws ApiException {
        return this.updateSecurityMonitoringRuleWithHttpInfo(ruleId, body).getData();
    }

    public CompletableFuture<SecurityMonitoringRuleResponse> updateSecurityMonitoringRuleAsync(String ruleId, SecurityMonitoringRuleUpdatePayload body) {
        return this.updateSecurityMonitoringRuleWithHttpInfoAsync(ruleId, body).thenApply(response -> (SecurityMonitoringRuleResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringRuleResponse> updateSecurityMonitoringRuleWithHttpInfo(String ruleId, SecurityMonitoringRuleUpdatePayload body) throws ApiException {
        SecurityMonitoringRuleUpdatePayload localVarPostBody = body;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling updateSecurityMonitoringRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> updateSecurityMonitoringRuleWithHttpInfoAsync(String ruleId, SecurityMonitoringRuleUpdatePayload body) {
        Invocation.Builder builder;
        SecurityMonitoringRuleUpdatePayload localVarPostBody = body;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling updateSecurityMonitoringRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public SecurityMonitoringSuppressionResponse updateSecurityMonitoringSuppression(String suppressionId, SecurityMonitoringSuppressionUpdateRequest body) throws ApiException {
        return this.updateSecurityMonitoringSuppressionWithHttpInfo(suppressionId, body).getData();
    }

    public CompletableFuture<SecurityMonitoringSuppressionResponse> updateSecurityMonitoringSuppressionAsync(String suppressionId, SecurityMonitoringSuppressionUpdateRequest body) {
        return this.updateSecurityMonitoringSuppressionWithHttpInfoAsync(suppressionId, body).thenApply(response -> (SecurityMonitoringSuppressionResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSuppressionResponse> updateSecurityMonitoringSuppressionWithHttpInfo(String suppressionId, SecurityMonitoringSuppressionUpdateRequest body) throws ApiException {
        SecurityMonitoringSuppressionUpdateRequest localVarPostBody = body;
        if (suppressionId == null) {
            throw new ApiException(400, "Missing the required parameter 'suppressionId' when calling updateSecurityMonitoringSuppression");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityMonitoringSuppression");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/{suppression_id}".replaceAll("\\{suppression_id\\}", this.apiClient.escapeString(suppressionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> updateSecurityMonitoringSuppressionWithHttpInfoAsync(String suppressionId, SecurityMonitoringSuppressionUpdateRequest body) {
        Invocation.Builder builder;
        SecurityMonitoringSuppressionUpdateRequest localVarPostBody = body;
        if (suppressionId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'suppressionId' when calling updateSecurityMonitoringSuppression"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityMonitoringSuppression"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/{suppression_id}".replaceAll("\\{suppression_id\\}", this.apiClient.escapeString(suppressionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionResponse>(){});
    }

    public static class SearchSecurityMonitoringSignalsOptionalParameters {
        private SecurityMonitoringSignalListRequest body;

        public SearchSecurityMonitoringSignalsOptionalParameters body(SecurityMonitoringSignalListRequest body) {
            this.body = body;
            return this;
        }
    }

    public static class ListSecurityMonitoringSignalsOptionalParameters {
        private String filterQuery;
        private OffsetDateTime filterFrom;
        private OffsetDateTime filterTo;
        private SecurityMonitoringSignalsSort sort;
        private String pageCursor;
        private Integer pageLimit;

        public ListSecurityMonitoringSignalsOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters filterFrom(OffsetDateTime filterFrom) {
            this.filterFrom = filterFrom;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters filterTo(OffsetDateTime filterTo) {
            this.filterTo = filterTo;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters sort(SecurityMonitoringSignalsSort sort) {
            this.sort = sort;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }
    }

    public static class ListSecurityMonitoringRulesOptionalParameters {
        private Long pageSize;
        private Long pageNumber;

        public ListSecurityMonitoringRulesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListSecurityMonitoringRulesOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }
    }

    public static class ListFindingsOptionalParameters {
        private Long pageLimit;
        private Long snapshotTimestamp;
        private String pageCursor;
        private String filterTags;
        private String filterEvaluationChangedAt;
        private Boolean filterMuted;
        private String filterRuleId;
        private String filterRuleName;
        private String filterResourceType;
        private String filterDiscoveryTimestamp;
        private FindingEvaluation filterEvaluation;
        private FindingStatus filterStatus;

        public ListFindingsOptionalParameters pageLimit(Long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public ListFindingsOptionalParameters snapshotTimestamp(Long snapshotTimestamp) {
            this.snapshotTimestamp = snapshotTimestamp;
            return this;
        }

        public ListFindingsOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public ListFindingsOptionalParameters filterTags(String filterTags) {
            this.filterTags = filterTags;
            return this;
        }

        public ListFindingsOptionalParameters filterEvaluationChangedAt(String filterEvaluationChangedAt) {
            this.filterEvaluationChangedAt = filterEvaluationChangedAt;
            return this;
        }

        public ListFindingsOptionalParameters filterMuted(Boolean filterMuted) {
            this.filterMuted = filterMuted;
            return this;
        }

        public ListFindingsOptionalParameters filterRuleId(String filterRuleId) {
            this.filterRuleId = filterRuleId;
            return this;
        }

        public ListFindingsOptionalParameters filterRuleName(String filterRuleName) {
            this.filterRuleName = filterRuleName;
            return this;
        }

        public ListFindingsOptionalParameters filterResourceType(String filterResourceType) {
            this.filterResourceType = filterResourceType;
            return this;
        }

        public ListFindingsOptionalParameters filterDiscoveryTimestamp(String filterDiscoveryTimestamp) {
            this.filterDiscoveryTimestamp = filterDiscoveryTimestamp;
            return this;
        }

        public ListFindingsOptionalParameters filterEvaluation(FindingEvaluation filterEvaluation) {
            this.filterEvaluation = filterEvaluation;
            return this;
        }

        public ListFindingsOptionalParameters filterStatus(FindingStatus filterStatus) {
            this.filterStatus = filterStatus;
            return this;
        }
    }

    public static class GetFindingOptionalParameters {
        private Long snapshotTimestamp;

        public GetFindingOptionalParameters snapshotTimestamp(Long snapshotTimestamp) {
            this.snapshotTimestamp = snapshotTimestamp;
            return this;
        }
    }
}

