/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.Dashboard;
import com.datadog.api.client.v1.model.DashboardBulkDeleteRequest;
import com.datadog.api.client.v1.model.DashboardDeleteResponse;
import com.datadog.api.client.v1.model.DashboardRestoreRequest;
import com.datadog.api.client.v1.model.DashboardSummary;
import com.datadog.api.client.v1.model.DashboardSummaryDefinition;
import com.datadog.api.client.v1.model.DeleteSharedDashboardResponse;
import com.datadog.api.client.v1.model.SharedDashboard;
import com.datadog.api.client.v1.model.SharedDashboardInvites;
import com.datadog.api.client.v1.model.SharedDashboardUpdateRequest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class DashboardsApi {
    private ApiClient apiClient;

    public DashboardsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public DashboardsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Dashboard createDashboard(Dashboard body) throws ApiException {
        return this.createDashboardWithHttpInfo(body).getData();
    }

    public CompletableFuture<Dashboard> createDashboardAsync(Dashboard body) {
        return this.createDashboardWithHttpInfoAsync(body).thenApply(response -> (Dashboard)response.getData());
    }

    public ApiResponse<Dashboard> createDashboardWithHttpInfo(Dashboard body) throws ApiException {
        Dashboard localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDashboard");
        }
        String localVarPath = "/api/v1/dashboard";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardsApi.createDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Dashboard>(){});
    }

    public CompletableFuture<ApiResponse<Dashboard>> createDashboardWithHttpInfoAsync(Dashboard body) {
        Invocation.Builder builder;
        Dashboard localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Dashboard>> result = new CompletableFuture<ApiResponse<Dashboard>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createDashboard"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DashboardsApi.createDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Dashboard>> result = new CompletableFuture<ApiResponse<Dashboard>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Dashboard>(){});
    }

    public SharedDashboard createPublicDashboard(SharedDashboard body) throws ApiException {
        return this.createPublicDashboardWithHttpInfo(body).getData();
    }

    public CompletableFuture<SharedDashboard> createPublicDashboardAsync(SharedDashboard body) {
        return this.createPublicDashboardWithHttpInfoAsync(body).thenApply(response -> (SharedDashboard)response.getData());
    }

    public ApiResponse<SharedDashboard> createPublicDashboardWithHttpInfo(SharedDashboard body) throws ApiException {
        SharedDashboard localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createPublicDashboard");
        }
        String localVarPath = "/api/v1/dashboard/public";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardsApi.createPublicDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SharedDashboard>(){});
    }

    public CompletableFuture<ApiResponse<SharedDashboard>> createPublicDashboardWithHttpInfoAsync(SharedDashboard body) {
        Invocation.Builder builder;
        SharedDashboard localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SharedDashboard>> result = new CompletableFuture<ApiResponse<SharedDashboard>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createPublicDashboard"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/public";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DashboardsApi.createPublicDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SharedDashboard>> result = new CompletableFuture<ApiResponse<SharedDashboard>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SharedDashboard>(){});
    }

    public DashboardDeleteResponse deleteDashboard(String dashboardId) throws ApiException {
        return this.deleteDashboardWithHttpInfo(dashboardId).getData();
    }

    public CompletableFuture<DashboardDeleteResponse> deleteDashboardAsync(String dashboardId) {
        return this.deleteDashboardWithHttpInfoAsync(dashboardId).thenApply(response -> (DashboardDeleteResponse)response.getData());
    }

    public ApiResponse<DashboardDeleteResponse> deleteDashboardWithHttpInfo(String dashboardId) throws ApiException {
        Object localVarPostBody = null;
        if (dashboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardId' when calling deleteDashboard");
        }
        String localVarPath = "/api/v1/dashboard/{dashboard_id}".replaceAll("\\{dashboard_id\\}", this.apiClient.escapeString(dashboardId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardsApi.deleteDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardDeleteResponse>(){});
    }

    public CompletableFuture<ApiResponse<DashboardDeleteResponse>> deleteDashboardWithHttpInfoAsync(String dashboardId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (dashboardId == null) {
            CompletableFuture<ApiResponse<DashboardDeleteResponse>> result = new CompletableFuture<ApiResponse<DashboardDeleteResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'dashboardId' when calling deleteDashboard"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/{dashboard_id}".replaceAll("\\{dashboard_id\\}", this.apiClient.escapeString(dashboardId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DashboardsApi.deleteDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DashboardDeleteResponse>> result = new CompletableFuture<ApiResponse<DashboardDeleteResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardDeleteResponse>(){});
    }

    public void deleteDashboards(DashboardBulkDeleteRequest body) throws ApiException {
        this.deleteDashboardsWithHttpInfo(body);
    }

    public CompletableFuture<Void> deleteDashboardsAsync(DashboardBulkDeleteRequest body) {
        return this.deleteDashboardsWithHttpInfoAsync(body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteDashboardsWithHttpInfo(DashboardBulkDeleteRequest body) throws ApiException {
        DashboardBulkDeleteRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteDashboards");
        }
        String localVarPath = "/api/v1/dashboard";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardsApi.deleteDashboards", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteDashboardsWithHttpInfoAsync(DashboardBulkDeleteRequest body) {
        Invocation.Builder builder;
        DashboardBulkDeleteRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deleteDashboards"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DashboardsApi.deleteDashboards", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public DeleteSharedDashboardResponse deletePublicDashboard(String token) throws ApiException {
        return this.deletePublicDashboardWithHttpInfo(token).getData();
    }

    public CompletableFuture<DeleteSharedDashboardResponse> deletePublicDashboardAsync(String token) {
        return this.deletePublicDashboardWithHttpInfoAsync(token).thenApply(response -> (DeleteSharedDashboardResponse)response.getData());
    }

    public ApiResponse<DeleteSharedDashboardResponse> deletePublicDashboardWithHttpInfo(String token) throws ApiException {
        Object localVarPostBody = null;
        if (token == null) {
            throw new ApiException(400, "Missing the required parameter 'token' when calling deletePublicDashboard");
        }
        String localVarPath = "/api/v1/dashboard/public/{token}".replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardsApi.deletePublicDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeleteSharedDashboardResponse>(){});
    }

    public CompletableFuture<ApiResponse<DeleteSharedDashboardResponse>> deletePublicDashboardWithHttpInfoAsync(String token) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (token == null) {
            CompletableFuture<ApiResponse<DeleteSharedDashboardResponse>> result = new CompletableFuture<ApiResponse<DeleteSharedDashboardResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'token' when calling deletePublicDashboard"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/public/{token}".replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DashboardsApi.deletePublicDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DeleteSharedDashboardResponse>> result = new CompletableFuture<ApiResponse<DeleteSharedDashboardResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeleteSharedDashboardResponse>(){});
    }

    public void deletePublicDashboardInvitation(String token, SharedDashboardInvites body) throws ApiException {
        this.deletePublicDashboardInvitationWithHttpInfo(token, body);
    }

    public CompletableFuture<Void> deletePublicDashboardInvitationAsync(String token, SharedDashboardInvites body) {
        return this.deletePublicDashboardInvitationWithHttpInfoAsync(token, body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deletePublicDashboardInvitationWithHttpInfo(String token, SharedDashboardInvites body) throws ApiException {
        SharedDashboardInvites localVarPostBody = body;
        if (token == null) {
            throw new ApiException(400, "Missing the required parameter 'token' when calling deletePublicDashboardInvitation");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deletePublicDashboardInvitation");
        }
        String localVarPath = "/api/v1/dashboard/public/{token}/invitation".replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardsApi.deletePublicDashboardInvitation", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deletePublicDashboardInvitationWithHttpInfoAsync(String token, SharedDashboardInvites body) {
        Invocation.Builder builder;
        SharedDashboardInvites localVarPostBody = body;
        if (token == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'token' when calling deletePublicDashboardInvitation"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deletePublicDashboardInvitation"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/public/{token}/invitation".replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DashboardsApi.deletePublicDashboardInvitation", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public Dashboard getDashboard(String dashboardId) throws ApiException {
        return this.getDashboardWithHttpInfo(dashboardId).getData();
    }

    public CompletableFuture<Dashboard> getDashboardAsync(String dashboardId) {
        return this.getDashboardWithHttpInfoAsync(dashboardId).thenApply(response -> (Dashboard)response.getData());
    }

    public ApiResponse<Dashboard> getDashboardWithHttpInfo(String dashboardId) throws ApiException {
        Object localVarPostBody = null;
        if (dashboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardId' when calling getDashboard");
        }
        String localVarPath = "/api/v1/dashboard/{dashboard_id}".replaceAll("\\{dashboard_id\\}", this.apiClient.escapeString(dashboardId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardsApi.getDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Dashboard>(){});
    }

    public CompletableFuture<ApiResponse<Dashboard>> getDashboardWithHttpInfoAsync(String dashboardId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (dashboardId == null) {
            CompletableFuture<ApiResponse<Dashboard>> result = new CompletableFuture<ApiResponse<Dashboard>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'dashboardId' when calling getDashboard"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/{dashboard_id}".replaceAll("\\{dashboard_id\\}", this.apiClient.escapeString(dashboardId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DashboardsApi.getDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Dashboard>> result = new CompletableFuture<ApiResponse<Dashboard>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Dashboard>(){});
    }

    public SharedDashboard getPublicDashboard(String token) throws ApiException {
        return this.getPublicDashboardWithHttpInfo(token).getData();
    }

    public CompletableFuture<SharedDashboard> getPublicDashboardAsync(String token) {
        return this.getPublicDashboardWithHttpInfoAsync(token).thenApply(response -> (SharedDashboard)response.getData());
    }

    public ApiResponse<SharedDashboard> getPublicDashboardWithHttpInfo(String token) throws ApiException {
        Object localVarPostBody = null;
        if (token == null) {
            throw new ApiException(400, "Missing the required parameter 'token' when calling getPublicDashboard");
        }
        String localVarPath = "/api/v1/dashboard/public/{token}".replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardsApi.getPublicDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SharedDashboard>(){});
    }

    public CompletableFuture<ApiResponse<SharedDashboard>> getPublicDashboardWithHttpInfoAsync(String token) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (token == null) {
            CompletableFuture<ApiResponse<SharedDashboard>> result = new CompletableFuture<ApiResponse<SharedDashboard>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'token' when calling getPublicDashboard"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/public/{token}".replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DashboardsApi.getPublicDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SharedDashboard>> result = new CompletableFuture<ApiResponse<SharedDashboard>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SharedDashboard>(){});
    }

    public SharedDashboardInvites getPublicDashboardInvitations(String token) throws ApiException {
        return this.getPublicDashboardInvitationsWithHttpInfo(token, new GetPublicDashboardInvitationsOptionalParameters()).getData();
    }

    public CompletableFuture<SharedDashboardInvites> getPublicDashboardInvitationsAsync(String token) {
        return this.getPublicDashboardInvitationsWithHttpInfoAsync(token, new GetPublicDashboardInvitationsOptionalParameters()).thenApply(response -> (SharedDashboardInvites)response.getData());
    }

    public SharedDashboardInvites getPublicDashboardInvitations(String token, GetPublicDashboardInvitationsOptionalParameters parameters) throws ApiException {
        return this.getPublicDashboardInvitationsWithHttpInfo(token, parameters).getData();
    }

    public CompletableFuture<SharedDashboardInvites> getPublicDashboardInvitationsAsync(String token, GetPublicDashboardInvitationsOptionalParameters parameters) {
        return this.getPublicDashboardInvitationsWithHttpInfoAsync(token, parameters).thenApply(response -> (SharedDashboardInvites)response.getData());
    }

    public ApiResponse<SharedDashboardInvites> getPublicDashboardInvitationsWithHttpInfo(String token, GetPublicDashboardInvitationsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (token == null) {
            throw new ApiException(400, "Missing the required parameter 'token' when calling getPublicDashboardInvitations");
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v1/dashboard/public/{token}/invitation".replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_number", pageNumber));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardsApi.getPublicDashboardInvitations", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SharedDashboardInvites>(){});
    }

    public CompletableFuture<ApiResponse<SharedDashboardInvites>> getPublicDashboardInvitationsWithHttpInfoAsync(String token, GetPublicDashboardInvitationsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (token == null) {
            CompletableFuture<ApiResponse<SharedDashboardInvites>> result = new CompletableFuture<ApiResponse<SharedDashboardInvites>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'token' when calling getPublicDashboardInvitations"));
            return result;
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v1/dashboard/public/{token}/invitation".replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_number", pageNumber));
        try {
            builder = this.apiClient.createBuilder("v1.DashboardsApi.getPublicDashboardInvitations", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SharedDashboardInvites>> result = new CompletableFuture<ApiResponse<SharedDashboardInvites>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SharedDashboardInvites>(){});
    }

    public DashboardSummary listDashboards() throws ApiException {
        return this.listDashboardsWithHttpInfo(new ListDashboardsOptionalParameters()).getData();
    }

    public CompletableFuture<DashboardSummary> listDashboardsAsync() {
        return this.listDashboardsWithHttpInfoAsync(new ListDashboardsOptionalParameters()).thenApply(response -> (DashboardSummary)response.getData());
    }

    public DashboardSummary listDashboards(ListDashboardsOptionalParameters parameters) throws ApiException {
        return this.listDashboardsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<DashboardSummary> listDashboardsAsync(ListDashboardsOptionalParameters parameters) {
        return this.listDashboardsWithHttpInfoAsync(parameters).thenApply(response -> (DashboardSummary)response.getData());
    }

    public PaginationIterable<DashboardSummaryDefinition> listDashboardsWithPagination() {
        ListDashboardsOptionalParameters parameters = new ListDashboardsOptionalParameters();
        return this.listDashboardsWithPagination(parameters);
    }

    public PaginationIterable<DashboardSummaryDefinition> listDashboardsWithPagination(ListDashboardsOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getDashboards";
        String valueGetterPath = "";
        String valueSetterPath = "start";
        Boolean valueSetterParamOptional = true;
        if (parameters.count == null) {
            limit = 100L;
            parameters.count(limit);
        } else {
            limit = parameters.count;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<DashboardSummaryDefinition> iterator = new PaginationIterable<DashboardSummaryDefinition>(this, "listDashboards", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<DashboardSummary> listDashboardsWithHttpInfo(ListDashboardsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Boolean filterShared = parameters.filterShared;
        Boolean filterDeleted = parameters.filterDeleted;
        Long count = parameters.count;
        Long start = parameters.start;
        String localVarPath = "/api/v1/dashboard";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[shared]", filterShared));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[deleted]", filterDeleted));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardsApi.listDashboards", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardSummary>(){});
    }

    public CompletableFuture<ApiResponse<DashboardSummary>> listDashboardsWithHttpInfoAsync(ListDashboardsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Boolean filterShared = parameters.filterShared;
        Boolean filterDeleted = parameters.filterDeleted;
        Long count = parameters.count;
        Long start = parameters.start;
        String localVarPath = "/api/v1/dashboard";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[shared]", filterShared));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[deleted]", filterDeleted));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        try {
            builder = this.apiClient.createBuilder("v1.DashboardsApi.listDashboards", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DashboardSummary>> result = new CompletableFuture<ApiResponse<DashboardSummary>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DashboardSummary>(){});
    }

    public void restoreDashboards(DashboardRestoreRequest body) throws ApiException {
        this.restoreDashboardsWithHttpInfo(body);
    }

    public CompletableFuture<Void> restoreDashboardsAsync(DashboardRestoreRequest body) {
        return this.restoreDashboardsWithHttpInfoAsync(body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> restoreDashboardsWithHttpInfo(DashboardRestoreRequest body) throws ApiException {
        DashboardRestoreRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling restoreDashboards");
        }
        String localVarPath = "/api/v1/dashboard";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardsApi.restoreDashboards", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> restoreDashboardsWithHttpInfoAsync(DashboardRestoreRequest body) {
        Invocation.Builder builder;
        DashboardRestoreRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling restoreDashboards"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DashboardsApi.restoreDashboards", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public SharedDashboardInvites sendPublicDashboardInvitation(String token, SharedDashboardInvites body) throws ApiException {
        return this.sendPublicDashboardInvitationWithHttpInfo(token, body).getData();
    }

    public CompletableFuture<SharedDashboardInvites> sendPublicDashboardInvitationAsync(String token, SharedDashboardInvites body) {
        return this.sendPublicDashboardInvitationWithHttpInfoAsync(token, body).thenApply(response -> (SharedDashboardInvites)response.getData());
    }

    public ApiResponse<SharedDashboardInvites> sendPublicDashboardInvitationWithHttpInfo(String token, SharedDashboardInvites body) throws ApiException {
        SharedDashboardInvites localVarPostBody = body;
        if (token == null) {
            throw new ApiException(400, "Missing the required parameter 'token' when calling sendPublicDashboardInvitation");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling sendPublicDashboardInvitation");
        }
        String localVarPath = "/api/v1/dashboard/public/{token}/invitation".replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardsApi.sendPublicDashboardInvitation", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SharedDashboardInvites>(){});
    }

    public CompletableFuture<ApiResponse<SharedDashboardInvites>> sendPublicDashboardInvitationWithHttpInfoAsync(String token, SharedDashboardInvites body) {
        Invocation.Builder builder;
        SharedDashboardInvites localVarPostBody = body;
        if (token == null) {
            CompletableFuture<ApiResponse<SharedDashboardInvites>> result = new CompletableFuture<ApiResponse<SharedDashboardInvites>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'token' when calling sendPublicDashboardInvitation"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SharedDashboardInvites>> result = new CompletableFuture<ApiResponse<SharedDashboardInvites>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling sendPublicDashboardInvitation"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/public/{token}/invitation".replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DashboardsApi.sendPublicDashboardInvitation", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SharedDashboardInvites>> result = new CompletableFuture<ApiResponse<SharedDashboardInvites>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SharedDashboardInvites>(){});
    }

    public Dashboard updateDashboard(String dashboardId, Dashboard body) throws ApiException {
        return this.updateDashboardWithHttpInfo(dashboardId, body).getData();
    }

    public CompletableFuture<Dashboard> updateDashboardAsync(String dashboardId, Dashboard body) {
        return this.updateDashboardWithHttpInfoAsync(dashboardId, body).thenApply(response -> (Dashboard)response.getData());
    }

    public ApiResponse<Dashboard> updateDashboardWithHttpInfo(String dashboardId, Dashboard body) throws ApiException {
        Dashboard localVarPostBody = body;
        if (dashboardId == null) {
            throw new ApiException(400, "Missing the required parameter 'dashboardId' when calling updateDashboard");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDashboard");
        }
        String localVarPath = "/api/v1/dashboard/{dashboard_id}".replaceAll("\\{dashboard_id\\}", this.apiClient.escapeString(dashboardId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardsApi.updateDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Dashboard>(){});
    }

    public CompletableFuture<ApiResponse<Dashboard>> updateDashboardWithHttpInfoAsync(String dashboardId, Dashboard body) {
        Invocation.Builder builder;
        Dashboard localVarPostBody = body;
        if (dashboardId == null) {
            CompletableFuture<ApiResponse<Dashboard>> result = new CompletableFuture<ApiResponse<Dashboard>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'dashboardId' when calling updateDashboard"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Dashboard>> result = new CompletableFuture<ApiResponse<Dashboard>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateDashboard"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/{dashboard_id}".replaceAll("\\{dashboard_id\\}", this.apiClient.escapeString(dashboardId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DashboardsApi.updateDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Dashboard>> result = new CompletableFuture<ApiResponse<Dashboard>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Dashboard>(){});
    }

    public SharedDashboard updatePublicDashboard(String token, SharedDashboardUpdateRequest body) throws ApiException {
        return this.updatePublicDashboardWithHttpInfo(token, body).getData();
    }

    public CompletableFuture<SharedDashboard> updatePublicDashboardAsync(String token, SharedDashboardUpdateRequest body) {
        return this.updatePublicDashboardWithHttpInfoAsync(token, body).thenApply(response -> (SharedDashboard)response.getData());
    }

    public ApiResponse<SharedDashboard> updatePublicDashboardWithHttpInfo(String token, SharedDashboardUpdateRequest body) throws ApiException {
        SharedDashboardUpdateRequest localVarPostBody = body;
        if (token == null) {
            throw new ApiException(400, "Missing the required parameter 'token' when calling updatePublicDashboard");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updatePublicDashboard");
        }
        String localVarPath = "/api/v1/dashboard/public/{token}".replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.DashboardsApi.updatePublicDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SharedDashboard>(){});
    }

    public CompletableFuture<ApiResponse<SharedDashboard>> updatePublicDashboardWithHttpInfoAsync(String token, SharedDashboardUpdateRequest body) {
        Invocation.Builder builder;
        SharedDashboardUpdateRequest localVarPostBody = body;
        if (token == null) {
            CompletableFuture<ApiResponse<SharedDashboard>> result = new CompletableFuture<ApiResponse<SharedDashboard>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'token' when calling updatePublicDashboard"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SharedDashboard>> result = new CompletableFuture<ApiResponse<SharedDashboard>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updatePublicDashboard"));
            return result;
        }
        String localVarPath = "/api/v1/dashboard/public/{token}".replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.DashboardsApi.updatePublicDashboard", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SharedDashboard>> result = new CompletableFuture<ApiResponse<SharedDashboard>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SharedDashboard>(){});
    }

    public static class ListDashboardsOptionalParameters {
        private Boolean filterShared;
        private Boolean filterDeleted;
        private Long count;
        private Long start;

        public ListDashboardsOptionalParameters filterShared(Boolean filterShared) {
            this.filterShared = filterShared;
            return this;
        }

        public ListDashboardsOptionalParameters filterDeleted(Boolean filterDeleted) {
            this.filterDeleted = filterDeleted;
            return this;
        }

        public ListDashboardsOptionalParameters count(Long count) {
            this.count = count;
            return this;
        }

        public ListDashboardsOptionalParameters start(Long start) {
            this.start = start;
            return this;
        }
    }

    public static class GetPublicDashboardInvitationsOptionalParameters {
        private Long pageSize;
        private Long pageNumber;

        public GetPublicDashboardInvitationsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetPublicDashboardInvitationsOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }
    }
}

