/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.UsageAttributionBody;
import com.datadog.api.client.v1.model.UsageAttributionMetadata;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"metadata", "usage"})
public class UsageAttributionResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private UsageAttributionMetadata metadata;
    public static final String JSON_PROPERTY_USAGE = "usage";
    private List<UsageAttributionBody> usage = null;
    private Map<String, Object> additionalProperties;

    public UsageAttributionResponse metadata(UsageAttributionMetadata metadata) {
        this.metadata = metadata;
        this.unparsed |= metadata.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsageAttributionMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(UsageAttributionMetadata metadata) {
        this.metadata = metadata;
    }

    public UsageAttributionResponse usage(List<UsageAttributionBody> usage) {
        this.usage = usage;
        for (UsageAttributionBody item : usage) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public UsageAttributionResponse addUsageItem(UsageAttributionBody usageItem) {
        if (this.usage == null) {
            this.usage = new ArrayList<UsageAttributionBody>();
        }
        this.usage.add(usageItem);
        this.unparsed |= usageItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UsageAttributionBody> getUsage() {
        return this.usage;
    }

    public void setUsage(List<UsageAttributionBody> usage) {
        this.usage = usage;
    }

    @JsonAnySetter
    public UsageAttributionResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageAttributionResponse usageAttributionResponse = (UsageAttributionResponse)o;
        return Objects.equals(this.metadata, usageAttributionResponse.metadata) && Objects.equals(this.usage, usageAttributionResponse.usage) && Objects.equals(this.additionalProperties, usageAttributionResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.usage, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageAttributionResponse {\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

