/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.ListStreamComputeItems;
import com.datadog.api.client.v1.model.ListStreamGroupByItems;
import com.datadog.api.client.v1.model.ListStreamSource;
import com.datadog.api.client.v1.model.WidgetEventSize;
import com.datadog.api.client.v1.model.WidgetFieldSort;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"compute", "data_source", "event_size", "group_by", "indexes", "query_string", "sort", "storage"})
public class ListStreamQuery {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_COMPUTE = "compute";
    private List<ListStreamComputeItems> compute = null;
    public static final String JSON_PROPERTY_DATA_SOURCE = "data_source";
    private ListStreamSource dataSource = ListStreamSource.APM_ISSUE_STREAM;
    public static final String JSON_PROPERTY_EVENT_SIZE = "event_size";
    private WidgetEventSize eventSize;
    public static final String JSON_PROPERTY_GROUP_BY = "group_by";
    private List<ListStreamGroupByItems> groupBy = null;
    public static final String JSON_PROPERTY_INDEXES = "indexes";
    private List<String> indexes = null;
    public static final String JSON_PROPERTY_QUERY_STRING = "query_string";
    private String queryString;
    public static final String JSON_PROPERTY_SORT = "sort";
    private WidgetFieldSort sort;
    public static final String JSON_PROPERTY_STORAGE = "storage";
    private String storage;
    private Map<String, Object> additionalProperties;

    public ListStreamQuery() {
    }

    @JsonCreator
    public ListStreamQuery(@JsonProperty(required=true, value="data_source") ListStreamSource dataSource, @JsonProperty(required=true, value="query_string") String queryString) {
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
        this.queryString = queryString;
    }

    public ListStreamQuery compute(List<ListStreamComputeItems> compute) {
        this.compute = compute;
        for (ListStreamComputeItems item : compute) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ListStreamQuery addComputeItem(ListStreamComputeItems computeItem) {
        if (this.compute == null) {
            this.compute = new ArrayList<ListStreamComputeItems>();
        }
        this.compute.add(computeItem);
        this.unparsed |= computeItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="compute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ListStreamComputeItems> getCompute() {
        return this.compute;
    }

    public void setCompute(List<ListStreamComputeItems> compute) {
        this.compute = compute;
    }

    public ListStreamQuery dataSource(ListStreamSource dataSource) {
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
        return this;
    }

    @JsonProperty(value="data_source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ListStreamSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ListStreamSource dataSource) {
        if (!dataSource.isValid()) {
            this.unparsed = true;
        }
        this.dataSource = dataSource;
    }

    public ListStreamQuery eventSize(WidgetEventSize eventSize) {
        this.eventSize = eventSize;
        this.unparsed |= !eventSize.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="event_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetEventSize getEventSize() {
        return this.eventSize;
    }

    public void setEventSize(WidgetEventSize eventSize) {
        if (!eventSize.isValid()) {
            this.unparsed = true;
        }
        this.eventSize = eventSize;
    }

    public ListStreamQuery groupBy(List<ListStreamGroupByItems> groupBy) {
        this.groupBy = groupBy;
        for (ListStreamGroupByItems item : groupBy) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ListStreamQuery addGroupByItem(ListStreamGroupByItems groupByItem) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<ListStreamGroupByItems>();
        }
        this.groupBy.add(groupByItem);
        this.unparsed |= groupByItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="group_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ListStreamGroupByItems> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<ListStreamGroupByItems> groupBy) {
        this.groupBy = groupBy;
    }

    public ListStreamQuery indexes(List<String> indexes) {
        this.indexes = indexes;
        return this;
    }

    public ListStreamQuery addIndexesItem(String indexesItem) {
        if (this.indexes == null) {
            this.indexes = new ArrayList<String>();
        }
        this.indexes.add(indexesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="indexes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<String> indexes) {
        this.indexes = indexes;
    }

    public ListStreamQuery queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    @JsonProperty(value="query_string")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public ListStreamQuery sort(WidgetFieldSort sort) {
        this.sort = sort;
        this.unparsed |= sort.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetFieldSort getSort() {
        return this.sort;
    }

    public void setSort(WidgetFieldSort sort) {
        this.sort = sort;
    }

    public ListStreamQuery storage(String storage) {
        this.storage = storage;
        return this;
    }

    @Nullable
    @JsonProperty(value="storage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStorage() {
        return this.storage;
    }

    public void setStorage(String storage) {
        this.storage = storage;
    }

    @JsonAnySetter
    public ListStreamQuery putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListStreamQuery listStreamQuery = (ListStreamQuery)o;
        return Objects.equals(this.compute, listStreamQuery.compute) && Objects.equals(this.dataSource, listStreamQuery.dataSource) && Objects.equals(this.eventSize, listStreamQuery.eventSize) && Objects.equals(this.groupBy, listStreamQuery.groupBy) && Objects.equals(this.indexes, listStreamQuery.indexes) && Objects.equals(this.queryString, listStreamQuery.queryString) && Objects.equals(this.sort, listStreamQuery.sort) && Objects.equals(this.storage, listStreamQuery.storage) && Objects.equals(this.additionalProperties, listStreamQuery.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.compute, this.dataSource, this.eventSize, this.groupBy, this.indexes, this.queryString, this.sort, this.storage, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListStreamQuery {\n");
        sb.append("    compute: ").append(this.toIndentedString(this.compute)).append("\n");
        sb.append("    dataSource: ").append(this.toIndentedString(this.dataSource)).append("\n");
        sb.append("    eventSize: ").append(this.toIndentedString(this.eventSize)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    indexes: ").append(this.toIndentedString(this.indexes)).append("\n");
        sb.append("    queryString: ").append(this.toIndentedString(this.queryString)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    storage: ").append(this.toIndentedString(this.storage)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

