/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.LogsAggregateRequestPage;
import com.datadog.api.client.v2.model.LogsCompute;
import com.datadog.api.client.v2.model.LogsGroupBy;
import com.datadog.api.client.v2.model.LogsQueryFilter;
import com.datadog.api.client.v2.model.LogsQueryOptions;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"compute", "filter", "group_by", "options", "page"})
public class LogsAggregateRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_COMPUTE = "compute";
    private List<LogsCompute> compute = null;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private LogsQueryFilter filter;
    public static final String JSON_PROPERTY_GROUP_BY = "group_by";
    private List<LogsGroupBy> groupBy = null;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private LogsQueryOptions options;
    public static final String JSON_PROPERTY_PAGE = "page";
    private LogsAggregateRequestPage page;
    private Map<String, Object> additionalProperties;

    public LogsAggregateRequest compute(List<LogsCompute> compute) {
        this.compute = compute;
        for (LogsCompute item : compute) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsAggregateRequest addComputeItem(LogsCompute computeItem) {
        if (this.compute == null) {
            this.compute = new ArrayList<LogsCompute>();
        }
        this.compute.add(computeItem);
        this.unparsed |= computeItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="compute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsCompute> getCompute() {
        return this.compute;
    }

    public void setCompute(List<LogsCompute> compute) {
        this.compute = compute;
    }

    public LogsAggregateRequest filter(LogsQueryFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LogsQueryFilter filter) {
        this.filter = filter;
    }

    public LogsAggregateRequest groupBy(List<LogsGroupBy> groupBy) {
        this.groupBy = groupBy;
        for (LogsGroupBy item : groupBy) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsAggregateRequest addGroupByItem(LogsGroupBy groupByItem) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<LogsGroupBy>();
        }
        this.groupBy.add(groupByItem);
        this.unparsed |= groupByItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="group_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsGroupBy> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<LogsGroupBy> groupBy) {
        this.groupBy = groupBy;
    }

    public LogsAggregateRequest options(LogsQueryOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsQueryOptions getOptions() {
        return this.options;
    }

    public void setOptions(LogsQueryOptions options) {
        this.options = options;
    }

    public LogsAggregateRequest page(LogsAggregateRequestPage page) {
        this.page = page;
        this.unparsed |= page.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsAggregateRequestPage getPage() {
        return this.page;
    }

    public void setPage(LogsAggregateRequestPage page) {
        this.page = page;
    }

    @JsonAnySetter
    public LogsAggregateRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsAggregateRequest logsAggregateRequest = (LogsAggregateRequest)o;
        return Objects.equals(this.compute, logsAggregateRequest.compute) && Objects.equals(this.filter, logsAggregateRequest.filter) && Objects.equals(this.groupBy, logsAggregateRequest.groupBy) && Objects.equals(this.options, logsAggregateRequest.options) && Objects.equals(this.page, logsAggregateRequest.page) && Objects.equals(this.additionalProperties, logsAggregateRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.compute, this.filter, this.groupBy, this.options, this.page, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsAggregateRequest {\n");
        sb.append("    compute: ").append(this.toIndentedString(this.compute)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

