/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=FindingStatusSerializer.class)
public class FindingStatus {
    public static final FindingStatus CRITICAL = new FindingStatus("critical");
    public static final FindingStatus HIGH = new FindingStatus("high");
    public static final FindingStatus MEDIUM = new FindingStatus("medium");
    public static final FindingStatus LOW = new FindingStatus("low");
    public static final FindingStatus INFO = new FindingStatus("info");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("critical", "high", "medium", "low", "info"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    FindingStatus(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((FindingStatus)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static FindingStatus fromValue(String value) {
        return new FindingStatus(value);
    }

    public static class FindingStatusSerializer
    extends StdSerializer<FindingStatus> {
        public FindingStatusSerializer(Class<FindingStatus> t) {
            super(t);
        }

        public FindingStatusSerializer() {
            this(null);
        }

        public void serialize(FindingStatus value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

