/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=SLOTypeNumericSerializer.class)
public class SLOTypeNumeric {
    public static final SLOTypeNumeric MONITOR = new SLOTypeNumeric(0);
    public static final SLOTypeNumeric METRIC = new SLOTypeNumeric(1);
    private static final Set<Integer> allowedValues = new HashSet<Integer>(Arrays.asList(0, 1));
    private Integer value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    SLOTypeNumeric(Integer value) {
        this.value = value;
    }

    @JsonValue
    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((SLOTypeNumeric)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static SLOTypeNumeric fromValue(Integer value) {
        return new SLOTypeNumeric(value);
    }

    public static class SLOTypeNumericSerializer
    extends StdSerializer<SLOTypeNumeric> {
        public SLOTypeNumericSerializer(Class<SLOTypeNumeric> t) {
            super(t);
        }

        public SLOTypeNumericSerializer() {
            this(null);
        }

        public void serialize(SLOTypeNumeric value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

