/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SLOResponseData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"data", "errors"})
public class SLOResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private SLOResponseData data;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private List<String> errors = null;

    public SLOResponse data(SLOResponseData data) {
        this.data = data;
        this.unparsed |= data.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOResponseData getData() {
        return this.data;
    }

    public void setData(SLOResponseData data) {
        this.data = data;
    }

    public SLOResponse errors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public SLOResponse addErrorsItem(String errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOResponse sloResponse = (SLOResponse)o;
        return Objects.equals(this.data, sloResponse.data) && Objects.equals(this.errors, sloResponse.errors);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

