/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=MetricsAggregatorSerializer.class)
public class MetricsAggregator {
    public static final MetricsAggregator AVG = new MetricsAggregator("avg");
    public static final MetricsAggregator MIN = new MetricsAggregator("min");
    public static final MetricsAggregator MAX = new MetricsAggregator("max");
    public static final MetricsAggregator SUM = new MetricsAggregator("sum");
    public static final MetricsAggregator LAST = new MetricsAggregator("last");
    public static final MetricsAggregator PERCENTILE = new MetricsAggregator("percentile");
    public static final MetricsAggregator MEAN = new MetricsAggregator("mean");
    public static final MetricsAggregator L2NORM = new MetricsAggregator("l2norm");
    public static final MetricsAggregator AREA = new MetricsAggregator("area");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("avg", "min", "max", "sum", "last", "percentile", "mean", "l2norm", "area"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    MetricsAggregator(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((MetricsAggregator)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static MetricsAggregator fromValue(String value) {
        return new MetricsAggregator(value);
    }

    public static class MetricsAggregatorSerializer
    extends StdSerializer<MetricsAggregator> {
        public MetricsAggregatorSerializer(Class<MetricsAggregator> t) {
            super(t);
        }

        public MetricsAggregatorSerializer() {
            this(null);
        }

        public void serialize(MetricsAggregator value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

