/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.UserCreateAttributes;
import com.datadog.api.client.v2.model.UserRelationships;
import com.datadog.api.client.v2.model.UsersType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"attributes", "relationships", "type"})
public class UserCreateData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private UserCreateAttributes attributes;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private UserRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private UsersType type = UsersType.USERS;

    public UserCreateData() {
    }

    @JsonCreator
    public UserCreateData(@JsonProperty(required=true, value="attributes") UserCreateAttributes attributes, @JsonProperty(required=true, value="type") UsersType type) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public UserCreateData attributes(UserCreateAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UserCreateAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(UserCreateAttributes attributes) {
        this.attributes = attributes;
    }

    public UserCreateData relationships(UserRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(UserRelationships relationships) {
        this.relationships = relationships;
    }

    public UserCreateData type(UsersType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UsersType getType() {
        return this.type;
    }

    public void setType(UsersType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserCreateData userCreateData = (UserCreateData)o;
        return Objects.equals(this.attributes, userCreateData.attributes) && Objects.equals(this.relationships, userCreateData.relationships) && Objects.equals(this.type, userCreateData.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.relationships, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserCreateData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

