/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.RUMCompute;
import com.datadog.api.client.v2.model.RUMGroupBy;
import com.datadog.api.client.v2.model.RUMQueryFilter;
import com.datadog.api.client.v2.model.RUMQueryOptions;
import com.datadog.api.client.v2.model.RUMQueryPageOptions;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"compute", "filter", "group_by", "options", "page"})
public class RUMAggregateRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_COMPUTE = "compute";
    private List<RUMCompute> compute = null;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private RUMQueryFilter filter;
    public static final String JSON_PROPERTY_GROUP_BY = "group_by";
    private List<RUMGroupBy> groupBy = null;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private RUMQueryOptions options;
    public static final String JSON_PROPERTY_PAGE = "page";
    private RUMQueryPageOptions page;

    public RUMAggregateRequest compute(List<RUMCompute> compute) {
        this.compute = compute;
        for (RUMCompute item : compute) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public RUMAggregateRequest addComputeItem(RUMCompute computeItem) {
        if (this.compute == null) {
            this.compute = new ArrayList<RUMCompute>();
        }
        this.compute.add(computeItem);
        this.unparsed |= computeItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="compute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RUMCompute> getCompute() {
        return this.compute;
    }

    public void setCompute(List<RUMCompute> compute) {
        this.compute = compute;
    }

    public RUMAggregateRequest filter(RUMQueryFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(RUMQueryFilter filter) {
        this.filter = filter;
    }

    public RUMAggregateRequest groupBy(List<RUMGroupBy> groupBy) {
        this.groupBy = groupBy;
        for (RUMGroupBy item : groupBy) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public RUMAggregateRequest addGroupByItem(RUMGroupBy groupByItem) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<RUMGroupBy>();
        }
        this.groupBy.add(groupByItem);
        this.unparsed |= groupByItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="group_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RUMGroupBy> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<RUMGroupBy> groupBy) {
        this.groupBy = groupBy;
    }

    public RUMAggregateRequest options(RUMQueryOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMQueryOptions getOptions() {
        return this.options;
    }

    public void setOptions(RUMQueryOptions options) {
        this.options = options;
    }

    public RUMAggregateRequest page(RUMQueryPageOptions page) {
        this.page = page;
        this.unparsed |= page.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RUMQueryPageOptions getPage() {
        return this.page;
    }

    public void setPage(RUMQueryPageOptions page) {
        this.page = page;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RUMAggregateRequest rumAggregateRequest = (RUMAggregateRequest)o;
        return Objects.equals(this.compute, rumAggregateRequest.compute) && Objects.equals(this.filter, rumAggregateRequest.filter) && Objects.equals(this.groupBy, rumAggregateRequest.groupBy) && Objects.equals(this.options, rumAggregateRequest.options) && Objects.equals(this.page, rumAggregateRequest.page);
    }

    public int hashCode() {
        return Objects.hash(this.compute, this.filter, this.groupBy, this.options, this.page);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RUMAggregateRequest {\n");
        sb.append("    compute: ").append(this.toIndentedString(this.compute)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

