/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.JsonTimeSerializer;
import com.datadog.api.client.v2.model.MetricEstimateType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"estimate_type", "estimated_at", "estimated_output_series"})
public class MetricEstimateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ESTIMATE_TYPE = "estimate_type";
    private MetricEstimateType estimateType = MetricEstimateType.COUNT_OR_GAUGE;
    public static final String JSON_PROPERTY_ESTIMATED_AT = "estimated_at";
    @JsonSerialize(using=JsonTimeSerializer.class)
    private OffsetDateTime estimatedAt;
    public static final String JSON_PROPERTY_ESTIMATED_OUTPUT_SERIES = "estimated_output_series";
    private Long estimatedOutputSeries;

    public MetricEstimateAttributes estimateType(MetricEstimateType estimateType) {
        this.estimateType = estimateType;
        this.unparsed |= !estimateType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="estimate_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MetricEstimateType getEstimateType() {
        return this.estimateType;
    }

    public void setEstimateType(MetricEstimateType estimateType) {
        if (!estimateType.isValid()) {
            this.unparsed = true;
        }
        this.estimateType = estimateType;
    }

    public MetricEstimateAttributes estimatedAt(OffsetDateTime estimatedAt) {
        this.estimatedAt = estimatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="estimated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getEstimatedAt() {
        return this.estimatedAt;
    }

    public void setEstimatedAt(OffsetDateTime estimatedAt) {
        this.estimatedAt = estimatedAt;
    }

    public MetricEstimateAttributes estimatedOutputSeries(Long estimatedOutputSeries) {
        this.estimatedOutputSeries = estimatedOutputSeries;
        return this;
    }

    @Nullable
    @JsonProperty(value="estimated_output_series")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEstimatedOutputSeries() {
        return this.estimatedOutputSeries;
    }

    public void setEstimatedOutputSeries(Long estimatedOutputSeries) {
        this.estimatedOutputSeries = estimatedOutputSeries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricEstimateAttributes metricEstimateAttributes = (MetricEstimateAttributes)o;
        return Objects.equals(this.estimateType, metricEstimateAttributes.estimateType) && Objects.equals(this.estimatedAt, metricEstimateAttributes.estimatedAt) && Objects.equals(this.estimatedOutputSeries, metricEstimateAttributes.estimatedOutputSeries);
    }

    public int hashCode() {
        return Objects.hash(this.estimateType, this.estimatedAt, this.estimatedOutputSeries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricEstimateAttributes {\n");
        sb.append("    estimateType: ").append(this.toIndentedString(this.estimateType)).append("\n");
        sb.append("    estimatedAt: ").append(this.toIndentedString(this.estimatedAt)).append("\n");
        sb.append("    estimatedOutputSeries: ").append(this.toIndentedString(this.estimatedOutputSeries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

